/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.extensions.GuiGraphicsExtension;
import com.supermartijn642.core.gui.ArbitraryPictureInPictureRenderer;
import com.supermartijn642.core.render.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.inventory.tooltip.BelowOrAboveWidgetTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiMetadataSection;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public final class GuiGraphicsHelper {
    public static final ResourceLocation SCREEN_BACKGROUND_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"gui/background");
    public static final ResourceLocation BUTTON_DEFAULT_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"gui/button_default");
    public static final ResourceLocation BUTTON_HIGHLIGHTED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"gui/button_highlighted");
    public static final ResourceLocation BUTTON_DISABLED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"gui/button_disabled");
    public static final ResourceLocation SLOT_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"gui/slot");
    private final GuiGraphics guiGraphics;
    private TextProperties textProperties;
    private TextureProperties textureProperties;
    private RectangleProperties rectangleProperties;
    private TooltipContent tooltipContent;
    private TooltipProperties tooltipProperties;
    private ItemProperties itemProperties;

    public static GuiGraphicsHelper of(GuiGraphics guiGraphics) {
        GuiGraphicsHelper helper = ((GuiGraphicsExtension)guiGraphics).supermartijn642corelibGetHelper();
        if (helper == null) {
            helper = new GuiGraphicsHelper(guiGraphics);
            ((GuiGraphicsExtension)guiGraphics).supermartijn642corelibSetHelper(helper);
        }
        return helper;
    }

    private GuiGraphicsHelper(GuiGraphics guiGraphics) {
        this.guiGraphics = guiGraphics;
    }

    public Matrix3x2fStack poseStack() {
        return this.guiGraphics.pose();
    }

    public void pushScissor(float x, float y, int width, int height) {
        this.guiGraphics.enableScissor((int)x, (int)y, (int)(x + (float)width), (int)(y + (float)height));
    }

    public void popScissor() {
        this.guiGraphics.disableScissor();
    }

    public void nextStratum() {
        this.guiGraphics.nextStratum();
    }

    public boolean isPointInScissor(float x, float y) {
        return this.guiGraphics.containsPointInScissor((int)x, (int)y);
    }

    public void submitText(FormattedText text, float x, float y, Consumer<TextProperties> properties) {
        Font font;
        if (this.textProperties == null) {
            this.textProperties = new TextProperties();
        } else {
            this.textProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.textProperties);
        }
        Font font2 = font = this.textProperties.font == null ? ClientUtils.getFontRenderer() : this.textProperties.font;
        if (this.textProperties.wrapWidth != null) {
            List lines = font.split(text, this.textProperties.wrapWidth.intValue());
            if (this.textProperties.centerHorizontally) {
                int widestLine = 0;
                for (FormattedCharSequence line : lines) {
                    int width = font.width(line);
                    if (width <= widestLine) continue;
                    widestLine = width;
                }
                x -= (float)widestLine / 2.0f;
            }
            if (this.textProperties.centerVertically) {
                int n = lines.size();
                Objects.requireNonNull(font);
                y -= (float)(n * 9) / 2.0f;
            }
            Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)this.guiGraphics.pose());
            ScreenRectangle scissor = this.guiGraphics.scissorStack.peek();
            for (FormattedCharSequence line : lines) {
                this.guiGraphics.guiRenderState.submitText(new GuiTextRenderState(font, line, pose, (int)x, (int)y, this.textProperties.color, this.textProperties.backgroundColor, this.textProperties.shadow, scissor));
            }
            return;
        }
        if (this.textProperties.cutoffWidth != null) {
            int cutoff = this.textProperties.cutoffWidth;
            if (this.textProperties.cutoffPostfix != null) {
                cutoff -= font.width((FormattedText)this.textProperties.cutoffPostfix);
            }
            if (cutoff >= 0) {
                text = font.substrByWidth(text, cutoff);
                if (this.textProperties.cutoffPostfix != null) {
                    text = FormattedText.composite((FormattedText[])new FormattedText[]{text, this.textProperties.cutoffPostfix});
                }
            } else {
                text = font.substrByWidth((FormattedText)this.textProperties.cutoffPostfix, this.textProperties.cutoffWidth.intValue());
            }
        }
        if (this.textProperties.centerHorizontally) {
            x -= (float)font.width(text) / 2.0f;
        }
        if (this.textProperties.centerVertically) {
            Objects.requireNonNull(font);
            y -= 9.0f / 2.0f;
        }
        this.guiGraphics.guiRenderState.submitText(new GuiTextRenderState(font, Language.getInstance().getVisualOrder(text), new Matrix3x2f((Matrix3x2fc)this.guiGraphics.pose()), (int)x, (int)y, this.textProperties.color, this.textProperties.backgroundColor, this.textProperties.shadow, this.guiGraphics.scissorStack.peek()));
    }

    public void submitText(FormattedText text, float x, float y) {
        this.submitText(text, x, y, null);
    }

    public void submitText(String text, float x, float y, Consumer<TextProperties> properties) {
        this.submitText((FormattedText)Component.literal((String)text), x, y, properties);
    }

    public void submitText(String text, float x, float y) {
        this.submitText((FormattedText)Component.literal((String)text), x, y, null);
    }

    public void submitTexture(GpuTextureView texture, float x, float y, float width, float height, Consumer<TextureProperties> properties) {
        if (this.textureProperties == null) {
            this.textureProperties = new TextureProperties();
        } else {
            this.textureProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.textureProperties);
        }
        if (this.textureProperties.centerHorizontally) {
            x -= width / 2.0f;
        }
        if (this.textureProperties.centerVertically) {
            y -= height / 2.0f;
        }
        this.guiGraphics.submitBlit(this.textureProperties.renderPipeline, texture, (int)x, (int)y, (int)(x + width), (int)(y + height), this.textureProperties.u, this.textureProperties.u + this.textureProperties.w, this.textureProperties.v, this.textureProperties.v + this.textureProperties.h, this.textureProperties.color);
    }

    public void submitTexture(GpuTextureView texture, float x, float y, float width, float height) {
        this.submitTexture(texture, x, y, width, height, null);
    }

    public void submitTexture(ResourceLocation texture, float x, float y, float width, float height, Consumer<TextureProperties> properties) {
        GpuTextureView textureView = this.guiGraphics.minecraft.getTextureManager().getTexture(texture).getTextureView();
        this.submitTexture(textureView, x, y, width, height, properties);
    }

    public void submitTexture(ResourceLocation texture, float x, float y, float width, float height) {
        this.submitTexture(texture, x, y, width, height, null);
    }

    public void submitSprite(TextureAtlasSprite sprite, float x, float y, float width, float height, Consumer<TextureProperties> properties) {
        GuiSpriteScaling scaling = sprite.contents().metadata().getSection(GuiMetadataSection.TYPE).orElse(GuiMetadataSection.DEFAULT).scaling();
        if (scaling instanceof GuiSpriteScaling.Stretch || !sprite.atlasLocation().equals((Object)this.guiGraphics.sprites.textureAtlas.location())) {
            if (properties == null) {
                properties = p -> {};
            }
            this.submitTexture(sprite.atlasLocation(), x, y, width, height, properties.andThen(p -> {
                float u = sprite.getU(p.u);
                float v = sprite.getV(p.v);
                p.uv(u, v, sprite.getU(p.u + p.w) - u, sprite.getV(p.v + p.h) - v);
            }));
            return;
        }
        if (this.textureProperties == null) {
            this.textureProperties = new TextureProperties();
        } else {
            this.textureProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.textureProperties);
        }
        if (this.textureProperties.centerHorizontally) {
            x -= width / 2.0f;
        }
        if (this.textureProperties.centerVertically) {
            y -= height / 2.0f;
        }
        this.guiGraphics.blitSprite(this.textureProperties.renderPipeline, sprite.contents().name(), (int)x, (int)y, (int)width, (int)height, this.textureProperties.color);
    }

    public void submitSprite(TextureAtlasSprite sprite, float x, float y, float width, float height) {
        this.submitSprite(sprite, x, y, width, height, null);
    }

    public void submitSprite(ResourceLocation sprite, float x, float y, float width, float height, Consumer<TextureProperties> properties) {
        this.submitSprite(this.guiGraphics.sprites.getSprite(sprite), x, y, width, height, properties);
    }

    public void submitSprite(ResourceLocation sprite, float x, float y, float width, float height) {
        this.submitSprite(sprite, x, y, width, height, null);
    }

    public void submitDefaultScreenBackground(float x, float y, float width, float height) {
        this.submitSprite(SCREEN_BACKGROUND_SPRITE, x, y, width, height, null);
    }

    public void submitDefaultButton(ButtonState state, float x, float y, float width, float height) {
        this.submitSprite(switch (state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BUTTON_DEFAULT_SPRITE;
            case 2 -> BUTTON_DISABLED_SPRITE;
            case 1 -> BUTTON_HIGHLIGHTED_SPRITE;
        }, x, y, width, height, null);
    }

    public void submitDefaultSlot(float x, float y, float width, float height) {
        this.submitSprite(SLOT_SPRITE, x, y, width, height, null);
    }

    public void submitDefaultSlot(float x, float y) {
        this.submitDefaultSlot(x, y, 18.0f, 18.0f);
    }

    public void submitRectangle(float x, float y, float width, float height, Consumer<RectangleProperties> properties) {
        if (this.rectangleProperties == null) {
            this.rectangleProperties = new RectangleProperties();
        } else {
            this.rectangleProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.rectangleProperties);
        }
        if (this.rectangleProperties.centerHorizontally) {
            x -= width / 2.0f;
        }
        if (this.rectangleProperties.centerVertically) {
            y -= height / 2.0f;
        }
        if (this.rectangleProperties.border != -1) {
            int border = this.rectangleProperties.border;
            int color = this.rectangleProperties.beginColor;
            RenderPipeline renderPipeline = this.rectangleProperties.renderPipeline;
            this.guiGraphics.fill(renderPipeline, (int)x, (int)y, (int)(x + width), (int)y + border, color);
            this.guiGraphics.fill(renderPipeline, (int)x, (int)y - border, (int)(x + width), (int)y, color);
            this.guiGraphics.fill(renderPipeline, (int)x, (int)y + border, (int)x + border, (int)(y + height) - border, color);
            this.guiGraphics.fill(renderPipeline, (int)x - border, (int)y + border, (int)x, (int)(y + height) - border, color);
            return;
        }
        this.guiGraphics.submitColoredRectangle(this.rectangleProperties.renderPipeline, TextureSetup.noTexture(), (int)x, (int)y, (int)(x + width), (int)(y + height), this.rectangleProperties.beginColor, Integer.valueOf(this.rectangleProperties.endColor));
    }

    void submitRectangle(float x, float y, float width, float height) {
        this.submitRectangle(x, y, width, height, null);
    }

    public void submitTooltip(Consumer<TooltipContent> content, float x, float y, Consumer<TooltipProperties> properties) {
        if (this.tooltipContent == null) {
            this.tooltipContent = new TooltipContent();
        } else {
            this.tooltipContent.clear();
        }
        content.accept(this.tooltipContent);
        if (this.tooltipContent.content.isEmpty()) {
            return;
        }
        if (this.tooltipProperties == null) {
            this.tooltipProperties = new TooltipProperties();
        } else {
            this.tooltipProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.tooltipProperties);
        }
        this.guiGraphics.renderTooltip(this.tooltipProperties.font == null ? ClientUtils.getFontRenderer() : this.tooltipProperties.font, List.copyOf(this.tooltipContent.content), (int)x, (int)y, this.tooltipProperties.positioner, this.tooltipProperties.frame);
    }

    public void submitTooltip(Consumer<TooltipContent> content, float x, float y) {
        this.submitTooltip(content, x, y, null);
    }

    public void submitTooltipForTopStratum(Consumer<TooltipContent> content, float x, float y, Consumer<TooltipProperties> properties) {
        if (this.tooltipContent == null) {
            this.tooltipContent = new TooltipContent();
        } else {
            this.tooltipContent.clear();
        }
        content.accept(this.tooltipContent);
        if (this.tooltipContent.content.isEmpty()) {
            return;
        }
        if (this.tooltipProperties == null) {
            this.tooltipProperties = new TooltipProperties();
        } else {
            this.tooltipProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.tooltipProperties);
        }
        Matrix3x2f matrix = new Matrix3x2f((Matrix3x2fc)this.guiGraphics.pose());
        Font font = this.tooltipProperties.font == null ? ClientUtils.getFontRenderer() : this.tooltipProperties.font;
        List<ClientTooltipComponent> components = List.copyOf(this.tooltipContent.content);
        ClientTooltipPositioner positioner = this.tooltipProperties.positioner;
        ResourceLocation frame = this.tooltipProperties.frame;
        this.guiGraphics.deferredTooltip = () -> {
            this.guiGraphics.pose().pushMatrix().set((Matrix3x2fc)matrix);
            this.guiGraphics.renderTooltip(font, components, (int)x, (int)y, positioner, frame);
            this.guiGraphics.pose().popMatrix();
        };
    }

    public void submitTooltipForTopStratum(Consumer<TooltipContent> content, float x, float y) {
        this.submitTooltipForTopStratum(content, x, y, null);
    }

    public void submitItem(ItemStack item, float x, float y, Consumer<ItemProperties> properties) {
        if (item.isEmpty()) {
            return;
        }
        if (this.itemProperties == null) {
            this.itemProperties = new ItemProperties();
        } else {
            this.itemProperties.clear();
        }
        if (properties != null) {
            properties.accept(this.itemProperties);
        }
        TrackingItemStackRenderState renderState = new TrackingItemStackRenderState();
        if (!this.itemProperties.allowOversized) {
            renderState.setOversizedInGui(false);
        }
        ClientUtils.getMinecraft().getItemModelResolver().updateForTopItem((ItemStackRenderState)renderState, item, this.itemProperties.displayContext, this.itemProperties.level, this.itemProperties.entity, 0);
        this.guiGraphics.guiRenderState.submitItem(new GuiItemRenderState(item.getItem().getName().toString(), new Matrix3x2f((Matrix3x2fc)this.guiGraphics.pose()), renderState, (int)x, (int)y, this.guiGraphics.scissorStack.peek()));
        if (this.itemProperties.showBar) {
            this.guiGraphics.renderItemBar(item, (int)x, (int)y);
        }
        if (this.itemProperties.showCooldown) {
            this.guiGraphics.renderItemCooldown(item, (int)x, (int)y);
        }
        if (this.itemProperties.showCount) {
            this.guiGraphics.renderItemCount(ClientUtils.getFontRenderer(), item, (int)x, (int)y, null);
        }
    }

    public void submitItem(ItemStack item, float x, float y) {
        this.submitItem(item, x, y, null);
    }

    public void submitGuiElement(GuiElementRenderState element) {
        this.guiGraphics.guiRenderState.submitGuiElement(element);
    }

    public void submitPictureInPicture(PictureInPictureRenderState element) {
        this.guiGraphics.guiRenderState.submitPicturesInPictureState(element);
    }

    public void submitCustomRendering(int x, int y, int width, int height, BiConsumer<PoseStack, MultiBufferSource.BufferSource> rendering) {
        this.guiGraphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new ArbitraryPictureInPictureRenderer.State(x, y, width, height, new Matrix3x2f((Matrix3x2fc)this.guiGraphics.pose()), rendering));
    }

    @Deprecated
    public void submitCustomRendering(int x, int y, int width, int height, Consumer<PoseStack> rendering) {
        this.guiGraphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new ArbitraryPictureInPictureRenderer.State(x, y, width, height, new Matrix3x2f((Matrix3x2fc)this.guiGraphics.pose()), (poseStack, bufferSource) -> {
            RenderUtils.GUI_BUFFER_SOURCE_OVERWRITE.set((MultiBufferSource.BufferSource)bufferSource);
            rendering.accept((PoseStack)poseStack);
            RenderUtils.GUI_BUFFER_SOURCE_OVERWRITE.remove();
        }));
    }

    public static final class TextProperties {
        private Font font;
        private int color;
        private int backgroundColor;
        private boolean shadow;
        private boolean centerHorizontally;
        private boolean centerVertically;
        private Integer wrapWidth;
        private Integer cutoffWidth;
        private Component cutoffPostfix;

        private TextProperties() {
            this.clear();
        }

        private void clear() {
            this.defaultFont();
            this.defaultColor();
            this.noBackground();
            this.shadow(false);
            this.centerHorizontally(false);
            this.centerVertically(false);
            this.wrapWidth = null;
            this.cutoffWidth = null;
            this.cutoffPostfix = null;
        }

        public TextProperties font(Font font) {
            this.font = font;
            return this;
        }

        public TextProperties defaultFont() {
            return this.font(null);
        }

        public TextProperties color(int color) {
            this.color = color | 0xFF000000;
            return this;
        }

        public TextProperties color(int red, int green, int blue) {
            return this.color(ARGB.color((int)red, (int)green, (int)blue));
        }

        public TextProperties color(int red, int green, int blue, int alpha) {
            return this.color(ARGB.color((int)alpha, (int)red, (int)green, (int)blue));
        }

        public TextProperties defaultColor() {
            return this.color(0x404040);
        }

        public TextProperties activeColor() {
            return this.color(0xE0E0E0);
        }

        public TextProperties inactiveColor() {
            return this.color(0x707070);
        }

        public TextProperties backgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public TextProperties noBackground() {
            return this.backgroundColor(0);
        }

        public TextProperties shadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        public TextProperties shadow() {
            return this.shadow(true);
        }

        public TextProperties centerHorizontally(boolean center) {
            this.centerHorizontally = center;
            return this;
        }

        public TextProperties centerHorizontally() {
            return this.centerHorizontally(true);
        }

        public TextProperties centerVertically(boolean center) {
            this.centerVertically = center;
            return this;
        }

        public TextProperties centerVertically() {
            return this.centerVertically(true);
        }

        public TextProperties center() {
            this.centerHorizontally();
            return this.centerVertically();
        }

        public TextProperties wrap(int maxWidth) {
            if (maxWidth < 0) {
                maxWidth = 0;
            }
            this.wrapWidth = maxWidth;
            this.cutoffWidth = null;
            this.cutoffPostfix = null;
            return this;
        }

        public TextProperties cutoff(int maxWidth, Component postfix) {
            if (maxWidth < 0) {
                maxWidth = 0;
            }
            this.cutoffWidth = maxWidth;
            this.cutoffPostfix = postfix;
            this.wrapWidth = null;
            return this;
        }

        public TextProperties cutoff(int maxWidth) {
            return this.cutoff(maxWidth, null);
        }

        public TextProperties cutoffWithDots(int maxWidth) {
            return this.cutoff(maxWidth, (Component)Component.literal((String)"..."));
        }
    }

    public static final class TextureProperties {
        private RenderPipeline renderPipeline;
        private float u;
        private float v;
        private float w;
        private float h;
        private int color;
        private boolean centerHorizontally;
        private boolean centerVertically;

        private TextureProperties() {
            this.clear();
        }

        private void clear() {
            this.defaultPipeline();
            this.fullUV();
            this.color(-1);
            this.centerHorizontally(false);
            this.centerVertically(false);
        }

        public TextureProperties renderPipeline(RenderPipeline renderPipeline) {
            this.renderPipeline = renderPipeline;
            return this;
        }

        public TextureProperties defaultPipeline() {
            return this.renderPipeline(RenderPipelines.GUI_TEXTURED);
        }

        public TextureProperties uv(float u, float v, float width, float height) {
            this.u = u;
            this.v = v;
            this.w = width;
            this.h = height;
            return this;
        }

        public TextureProperties fullUV() {
            return this.uv(0.0f, 0.0f, 1.0f, 1.0f);
        }

        public TextureProperties color(int color) {
            this.color = color;
            return this;
        }

        public TextureProperties color(int red, int green, int blue) {
            return this.color(ARGB.color((int)red, (int)green, (int)blue));
        }

        public TextureProperties color(int red, int green, int blue, int alpha) {
            return this.color(ARGB.color((int)alpha, (int)red, (int)green, (int)blue));
        }

        public TextureProperties centerHorizontally(boolean center) {
            this.centerHorizontally = center;
            return this;
        }

        public TextureProperties centerHorizontally() {
            return this.centerHorizontally(true);
        }

        public TextureProperties centerVertically(boolean center) {
            this.centerVertically = center;
            return this;
        }

        public TextureProperties centerVertically() {
            return this.centerVertically(true);
        }

        public TextureProperties center() {
            this.centerHorizontally();
            return this.centerVertically();
        }
    }

    public static enum ButtonState {
        DEFAULT,
        HIGHLIGHTED,
        DISABLED;

    }

    public static final class RectangleProperties {
        private RenderPipeline renderPipeline;
        private int beginColor;
        private int endColor;
        private boolean centerHorizontally;
        private boolean centerVertically;
        private int border;

        private RectangleProperties() {
            this.clear();
        }

        private void clear() {
            this.defaultPipeline();
            this.color(-1);
            this.centerHorizontally(false);
            this.centerVertically(false);
            this.border = -1;
        }

        public RectangleProperties renderPipeline(RenderPipeline renderPipeline) {
            this.renderPipeline = renderPipeline;
            return this;
        }

        public RectangleProperties defaultPipeline() {
            return this.renderPipeline(RenderPipelines.GUI);
        }

        public RectangleProperties color(int beginColor, int endColor) {
            this.beginColor = beginColor;
            this.endColor = endColor;
            return this;
        }

        public RectangleProperties color(int color) {
            return this.color(color, color);
        }

        public RectangleProperties color(int red, int green, int blue) {
            return this.color(ARGB.color((int)red, (int)green, (int)blue));
        }

        public RectangleProperties color(int red, int green, int blue, int alpha) {
            return this.color(ARGB.color((int)alpha, (int)red, (int)green, (int)blue));
        }

        public RectangleProperties centerHorizontally(boolean center) {
            this.centerHorizontally = center;
            return this;
        }

        public RectangleProperties centerHorizontally() {
            return this.centerHorizontally(true);
        }

        public RectangleProperties centerVertically(boolean center) {
            this.centerVertically = center;
            return this;
        }

        public RectangleProperties centerVertically() {
            return this.centerVertically(true);
        }

        public RectangleProperties center() {
            this.centerHorizontally();
            return this.centerVertically();
        }

        public RectangleProperties unfilled(int borderThickness) {
            this.border = borderThickness;
            return this;
        }
    }

    public static class TooltipContent {
        private final List<ClientTooltipComponent> content = new ArrayList<ClientTooltipComponent>(10);

        private TooltipContent() {
        }

        private void clear() {
            this.content.clear();
        }

        public TooltipContent add(Collection<ClientTooltipComponent> components) {
            this.content.addAll(components);
            return this;
        }

        public TooltipContent add(ClientTooltipComponent ... components) {
            return this.add(Arrays.asList(components));
        }

        public TooltipContent text(Collection<Component> components) {
            this.content.addAll(components.stream().map(c -> ClientTooltipComponent.create((FormattedCharSequence)c.getVisualOrderText())).toList());
            return this;
        }

        public TooltipContent text(Component ... components) {
            return this.text(Arrays.asList(components));
        }

        public TooltipContent literal(Collection<String> s) {
            this.content.addAll(s.stream().map(s2 -> ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.forward((String)s2, (Style)Style.EMPTY))).toList());
            return this;
        }

        public TooltipContent literal(String ... s) {
            return this.literal(Arrays.asList(s));
        }

        public TooltipContent synced(Collection<TooltipComponent> components) {
            this.content.addAll(components.stream().map(ClientTooltipComponent::create).toList());
            return this;
        }

        public TooltipContent synced(TooltipComponent ... components) {
            return this.synced(Arrays.asList(components));
        }
    }

    public static class TooltipProperties {
        private ClientTooltipPositioner positioner;
        private Font font;
        private ResourceLocation frame;

        private TooltipProperties() {
            this.clear();
        }

        private void clear() {
            this.defaultPositioner();
            this.defaultFont();
            this.defaultFrame();
        }

        public TooltipProperties positioner(ClientTooltipPositioner positioner) {
            this.positioner = positioner;
            return this;
        }

        public TooltipProperties defaultPositioner() {
            return this.positioner(DefaultTooltipPositioner.INSTANCE);
        }

        public TooltipProperties aboveOrBelow(float x, float y, float width, float height) {
            return this.positioner((ClientTooltipPositioner)new BelowOrAboveWidgetTooltipPositioner(new ScreenRectangle((int)x, (int)y, (int)width, (int)height)));
        }

        public TooltipProperties font(Font font) {
            this.font = font;
            return this;
        }

        public TooltipProperties defaultFont() {
            return this.font(null);
        }

        public TooltipProperties frame(ResourceLocation texture) {
            this.frame = texture;
            return this;
        }

        public TooltipProperties defaultFrame() {
            return this.frame(null);
        }
    }

    public static final class ItemProperties {
        private Level level;
        private LivingEntity entity;
        private boolean allowOversized;
        private boolean showBar;
        private boolean showCount;
        private boolean showCooldown;
        private ItemDisplayContext displayContext;

        private ItemProperties() {
            this.clear();
        }

        private void clear() {
            this.level = null;
            this.entity = null;
            this.allowOversized = true;
            this.showBar = true;
            this.showCount = true;
            this.showCooldown = true;
            this.guiDisplayContext();
        }

        public ItemProperties level(Level level) {
            this.level = level;
            return this;
        }

        public ItemProperties entity(LivingEntity entity) {
            this.entity = entity;
            return this;
        }

        public ItemProperties allowOversized(boolean allowOversized) {
            this.allowOversized = allowOversized;
            return this;
        }

        public ItemProperties forceNoOversized() {
            return this.allowOversized(false);
        }

        public ItemProperties showBar(boolean showBar) {
            this.showBar = showBar;
            return this;
        }

        public ItemProperties noBar() {
            return this.showBar(false);
        }

        public ItemProperties showCount(boolean showCount) {
            this.showCount = showCount;
            return this;
        }

        public ItemProperties noCount() {
            return this.showCount(false);
        }

        public ItemProperties showCooldown(boolean showCooldown) {
            this.showCooldown = showCooldown;
            return this;
        }

        public ItemProperties noCooldown() {
            return this.showCooldown(false);
        }

        public ItemProperties noDecorations() {
            this.showBar(false);
            this.showCount(false);
            return this.showCooldown(false);
        }

        public ItemProperties displayContext(ItemDisplayContext displayContext) {
            this.displayContext = displayContext;
            return this;
        }

        public ItemProperties guiDisplayContext() {
            return this.displayContext(ItemDisplayContext.GUI);
        }
    }
}

