/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.MutableWidgetRenderContext;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.client.event.ForgeEventFactoryClient;

public class WidgetContainerScreen<T extends Widget, X extends BaseContainer>
extends AbstractContainerScreen<X> {
    private final MutableWidgetRenderContext widgetRenderContext = MutableWidgetRenderContext.create();
    protected final X container;
    protected final T widget;
    private boolean initialized = false;
    private final boolean drawSlots;
    private final boolean isPauseScreen;

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots, isPauseScreen);
    }

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots);
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        super(container, ((BaseContainer)((Object)container)).player.getInventory(), (Component)TextComponents.empty().get());
        this.widget = widget;
        this.container = container;
        this.drawSlots = drawSlots;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots) {
        this(widget, container, drawSlots, false);
    }

    public void init() {
        if (!this.initialized) {
            if (this.widget instanceof ContainerWidget) {
                ((ContainerWidget)this.widget).initialize(this.container);
            } else {
                this.widget.initialize();
            }
            this.initialized = true;
        }
        this.imageWidth = this.widget.width();
        this.imageHeight = this.widget.height();
        super.init();
    }

    public void onClose() {
        this.widget.discard();
        super.onClose();
    }

    protected void containerTick() {
        this.widget.update();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.widgetRenderContext.update(guiGraphics, partialTicks, this.font, this.minecraft);
        GuiGraphicsHelper helper = GuiGraphicsHelper.of(guiGraphics);
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int offsetMouseX = mouseX - offsetX;
        int offsetMouseY = mouseY - offsetY;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY);
        this.widget.setFocused(offsetMouseX >= 0 && offsetMouseX < this.widget.width() && offsetMouseY >= 0 && offsetMouseY < this.widget.height());
        this.widget.renderBackground(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.container)).slots) {
                helper.submitDefaultSlot(slot.x - 1, slot.y - 1);
            }
        }
        guiGraphics.pose().popMatrix();
        ForgeEventFactoryClient.onContainerRenderBackground((AbstractContainerScreen)this, (GuiGraphics)guiGraphics, (int)mouseX, (int)mouseY);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY);
        this.widget.render(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        this.hoveredSlot = null;
        for (Slot slot : ((BaseContainer)((Object)this.container)).slots) {
            if (!slot.isActive()) continue;
            if (this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) {
                this.hoveredSlot = slot;
                helper.submitSprite(AbstractContainerScreen.SLOT_HIGHLIGHT_BACK_SPRITE, (float)(slot.x - 4), (float)(slot.y - 4), 24.0f, 24.0f);
            }
            this.renderSlot(guiGraphics, slot);
            if (this.hoveredSlot != slot) continue;
            helper.submitSprite(AbstractContainerScreen.SLOT_HIGHLIGHT_FRONT_SPRITE, (float)(slot.x - 4), (float)(slot.y - 4), 24.0f, 24.0f);
        }
        this.widget.renderForeground(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        guiGraphics.pose().popMatrix();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        ForgeEventFactoryClient.onContainerRenderForeground((AbstractContainerScreen)this, (GuiGraphics)guiGraphics, (int)mouseX, (int)mouseY);
        this.renderCarriedItem(guiGraphics, mouseX, mouseY);
        this.renderSnapbackItem(guiGraphics);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY);
        this.widget.renderOverlay(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        this.widget.renderTooltips(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        guiGraphics.pose().popMatrix();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mousePressed((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.height - this.widget.height()) / 2), button, false) || super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mouseReleased((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.height - this.widget.height()) / 2), button, false) || super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.height - this.widget.height()) / 2), horizontalAmount, false) || super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().options.keyInventory.isActiveAndMatches(key)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.widget.keyReleased(keyCode, false) || super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char character, int modifiers) {
        return this.widget.charTyped(character, false) || super.charTyped(character, modifiers);
    }

    public boolean isPauseScreen() {
        return this.isPauseScreen;
    }

    public Component getNarrationMessage() {
        Component message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

