/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.screen;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.network.message.ServerboundInventoryButtonPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class InventoryButtonReturnConfirmScreen
extends ConfirmScreen {
    private final Component waystoneName;

    public InventoryButtonReturnConfirmScreen() {
        this("");
    }

    public InventoryButtonReturnConfirmScreen(String targetWaystone) {
        super(result -> {
            if (result) {
                Balm.getNetworking().sendToServer((CustomPacketPayload)ServerboundInventoryButtonPacket.INSTANCE);
            }
            Minecraft.getInstance().setScreen(null);
        }, (Component)Component.translatable((String)"gui.waystones.inventory.confirm_return"), (Component)Component.empty());
        this.waystoneName = InventoryButtonReturnConfirmScreen.getWaystoneName(targetWaystone);
    }

    private static Component getWaystoneName(String targetWaystone) {
        if (!targetWaystone.isEmpty()) {
            return Component.translatable((String)"gui.waystones.inventory.confirm_return_bound_to", (Object[])new Object[]{targetWaystone}).withStyle(ChatFormatting.GRAY);
        }
        LocalPlayer player = Minecraft.getInstance().player;
        Optional<Waystone> nearestWaystone = PlayerWaystoneManager.getNearestWaystone((Player)player);
        return (Component)nearestWaystone.map(Waystone::getName).map(it -> Component.translatable((String)"gui.waystones.inventory.confirm_return_bound_to", (Object[])new Object[]{it}).withStyle(ChatFormatting.GRAY)).orElse(Component.translatable((String)"gui.waystones.inventory.no_waystones_activated").withStyle(ChatFormatting.GRAY));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawCenteredString(font, this.waystoneName, this.width / 2, 100, 0xFFFFFF);
    }
}

