/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import net.blay09.mods.waystones.Waystones;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public record ClientboundTeleportEffectPacket(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundTeleportEffectPacket> TYPE = new CustomPacketPayload.Type(Waystones.id("teleport_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundTeleportEffectPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClientboundTeleportEffectPacket::pos, ClientboundTeleportEffectPacket::new);

    public static void handle(Player player, ClientboundTeleportEffectPacket message) {
        Level level = player.level();
        if (level != null) {
            for (int i = 0; i < 128; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)message.pos.getX() + (level.random.nextDouble() - 0.5) * 3.0, (double)message.pos.getY() + level.random.nextDouble() * 3.0, (double)message.pos.getZ() + (level.random.nextDouble() - 0.5) * 3.0, (level.random.nextDouble() - 0.5) * 2.0, -level.random.nextDouble(), (level.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

