/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record ServerboundSortWaystonePacket(UUID waystoneUid, UUID otherWaystoneUid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSortWaystonePacket> TYPE = new CustomPacketPayload.Type(Waystones.id("sort_waystone"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundSortWaystonePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, ServerboundSortWaystonePacket::waystoneUid, (StreamCodec)UUIDUtil.STREAM_CODEC, ServerboundSortWaystonePacket::otherWaystoneUid, ServerboundSortWaystonePacket::new);
    public static final UUID SORT_FIRST = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final UUID SORT_LAST = UUID.fromString("ffffffff-ffff-ffff-ffff-ffffffffffff");

    public static void handle(ServerPlayer player, ServerboundSortWaystonePacket message) {
        if (player == null) {
            return;
        }
        if (message.otherWaystoneUid.equals(SORT_FIRST)) {
            PlayerWaystoneManager.sortWaystoneAsFirst((Player)player, message.waystoneUid);
        } else if (message.otherWaystoneUid.equals(SORT_LAST)) {
            PlayerWaystoneManager.sortWaystoneAsLast((Player)player, message.waystoneUid);
        } else {
            PlayerWaystoneManager.sortWaystoneSwap((Player)player, message.waystoneUid, message.otherWaystoneUid);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

