/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.store;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.store.EventfulWaystonesStore;
import net.blay09.mods.waystones.store.InMemoryWaystonesStore;
import net.blay09.mods.waystones.store.WaystonesStore;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class SavedDataWaystonesStore
extends SavedData
implements WaystonesStore {
    private static final String DATA_NAME = "waystones";
    private static final Codec<SavedDataWaystonesStore> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WaystoneImpl.CODEC.codec().listOf().fieldOf("Waystones").forGetter(WaystonesStore::getWaystones)).apply((Applicative)instance, SavedDataWaystonesStore::new));
    public static final SavedDataType<SavedDataWaystonesStore> TYPE = new SavedDataType("waystones", context -> new SavedDataWaystonesStore(List.of()), ctx -> CODEC, null);
    private final WaystonesStore store;

    public SavedDataWaystonesStore(List<Waystone> waystones) {
        this.store = new EventfulWaystonesStore(new InMemoryWaystonesStore(waystones));
    }

    @Override
    public void addWaystone(Waystone waystone) {
        this.store.addWaystone(waystone);
        this.setDirty();
    }

    @Override
    public void updateWaystone(Waystone waystone) {
        this.store.updateWaystone(waystone);
        this.setDirty();
    }

    @Override
    public void removeWaystone(Waystone waystone) {
        this.store.removeWaystone(waystone);
        this.setDirty();
    }

    @Override
    public Optional<Waystone> getWaystoneAt(BlockGetter world, BlockPos pos) {
        return this.store.getWaystoneAt(world, pos);
    }

    @Override
    public Optional<Waystone> getWaystoneById(UUID waystoneUid) {
        return this.store.getWaystoneById(waystoneUid);
    }

    @Override
    public Optional<Waystone> findWaystoneByName(String name) {
        return this.store.findWaystoneByName(name);
    }

    @Override
    public List<Waystone> getWaystones() {
        return this.store.getWaystones();
    }

    @Override
    public Collection<Waystone> getWaystonesByType(ResourceLocation type) {
        return this.store.getWaystonesByType(type);
    }

    @Override
    public List<Waystone> getGlobalWaystones() {
        return this.store.getGlobalWaystones();
    }

    public static SavedDataWaystonesStore get(MinecraftServer server) {
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        return (SavedDataWaystonesStore)Objects.requireNonNull(overworld).getDataStorage().computeIfAbsent(TYPE);
    }
}

