/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.wormhole.StabilizerBlockEntity;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class StabilizerBlock
extends PortalGroupBlock {
    public static final BooleanProperty ON_PROPERTY = BooleanProperty.create((String)"on");

    public StabilizerBlock() {
        super(() -> Wormhole.stabilizer_tile);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ON_PROPERTY, (Comparable)Boolean.valueOf(false)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof StabilizerBlockEntity) {
            return ((StabilizerBlockEntity)entity).activate(player) ? BaseBlock.InteractionFeedback.SUCCESS : BaseBlock.InteractionFeedback.PASS;
        }
        return BaseBlock.InteractionFeedback.PASS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ON_PROPERTY});
    }

    public void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"wormhole.portal_stabilizer.info").color(ChatFormatting.AQUA).get());
        CompoundTag tag = (CompoundTag)stack.get(BaseBlock.TILE_DATA);
        int targets = tag == null || tag.isEmpty() ? 0 : tag.getIntOr("targetCount", 0);
        int targetCapacity = WormholeConfig.stabilizerTargetCapacity.get();
        if (targetCapacity > 0) {
            info.accept((Component)TextComponents.translation((String)"wormhole.portal_stabilizer.info.targets", (Object[])new Object[]{targets, targetCapacity}).color(ChatFormatting.YELLOW).get());
        }
        int energy = tag == null || tag.isEmpty() ? 0 : tag.getIntOr("energy", 0);
        int energyCapacity = WormholeConfig.stabilizerEnergyCapacity.get();
        if (energyCapacity > 0) {
            info.accept((Component)TextComponents.translation((String)EnergyFormat.formatCapacityWithUnit((int)energy, (int)energyCapacity)).color(ChatFormatting.YELLOW).get());
        }
    }
}

