/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class TeleportHelper {
    private static final int TELEPORT_COOLDOWN = 40;

    public static boolean queTeleport(Entity entity, PortalTarget target) {
        if (!TeleportHelper.canTeleport(entity, target)) {
            return false;
        }
        for (Entity passenger : entity.getIndirectPassengers()) {
            if (!(passenger instanceof Player)) continue;
            return false;
        }
        Entity lowestEntity = entity.getRootVehicle();
        if (!entity.level().isClientSide) {
            lowestEntity.level().getServer().schedule((Runnable)new TickTask(0, () -> TeleportHelper.teleportEntityAndPassengers(lowestEntity, null, target)));
            TeleportHelper.markEntityAndPassengers(lowestEntity);
        }
        return true;
    }

    public static boolean canTeleport(Entity entity, PortalTarget target) {
        if (entity.level().isClientSide || !target.getLevel(entity.getServer()).isPresent()) {
            return false;
        }
        if (entity.isPassenger()) {
            return TeleportHelper.canTeleport(entity.getRootVehicle(), target);
        }
        for (Entity rider : entity.getIndirectPassengers()) {
            CompoundTag tag = rider.getPersistentData();
            if (!tag.getLong("wormhole:teleported").map(l -> (long)rider.tickCount - l).map(l -> l >= 0L && l < 40L).orElse(false).booleanValue()) continue;
            return false;
        }
        CompoundTag tag = entity.getPersistentData();
        return tag.getLong("wormhole:teleported").map(l -> (long)entity.tickCount - l).map(l -> l < 0L || l >= 40L).orElse(true);
    }

    private static void markEntityAndPassengers(Entity entity) {
        entity.getPersistentData().putLong("wormhole:teleported", (long)entity.tickCount);
        entity.getPassengers().forEach(TeleportHelper::markEntityAndPassengers);
    }

    private static void teleportEntityAndPassengers(Entity entity, Entity entityBeingRidden, PortalTarget target) {
        if (entity.level().isClientSide || target.getLevel(entity.getServer()).isEmpty()) {
            return;
        }
        Optional<ServerLevel> targetLevel = target.getLevel(entity.getServer()).filter(ServerLevel.class::isInstance).map(ServerLevel.class::cast);
        if (targetLevel.isEmpty()) {
            return;
        }
        List passengers = entity.getPassengers();
        entity.ejectPassengers();
        Entity newEntity = TeleportHelper.teleportEntity(entity, targetLevel.get(), target);
        if (newEntity != null && entityBeingRidden != null) {
            newEntity.startRiding(entityBeingRidden);
            if (newEntity instanceof ServerPlayer) {
                ((ServerPlayer)newEntity).connection.send((Packet)new ClientboundSetPassengersPacket(entityBeingRidden));
            }
        }
        passengers.forEach(e -> TeleportHelper.teleportEntityAndPassengers(e, newEntity, target));
    }

    private static Entity teleportEntity(Entity entity, ServerLevel targetLevel, PortalTarget target) {
        if (targetLevel == entity.level()) {
            if (entity instanceof ServerPlayer) {
                entity.teleportTo(targetLevel, (double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5, Set.of(), target.yaw, 0.0f, true);
            } else {
                entity.teleportTo((double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5);
            }
            entity.setYHeadRot(target.yaw);
            entity.setDeltaMovement(Vec3.ZERO);
            entity.fallDistance = 0.0;
            entity.setOnGround(true);
        } else {
            if (!ForgeEventFactory.onTravelToDimension((Entity)entity, (ResourceKey)targetLevel.dimension())) {
                return null;
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.isChangingDimension = true;
                LevelData levelData = targetLevel.getLevelData();
                player.connection.send((Packet)new ClientboundRespawnPacket(player.createCommonSpawnInfo(targetLevel), 3));
                player.connection.send((Packet)new ClientboundChangeDifficultyPacket(levelData.getDifficulty(), levelData.isDifficultyLocked()));
                PlayerList playerList = player.getServer().getPlayerList();
                playerList.sendPlayerPermissionLevel(player);
                ServerLevel oldLevel = player.level();
                oldLevel.removePlayerImmediately(player, Entity.RemovalReason.CHANGED_DIMENSION);
                player.unsetRemoved();
                if (targetLevel.dimension() == Level.NETHER) {
                    player.enteredNetherPosition = new Vec3((double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5);
                }
                player.setServerLevel(targetLevel);
                player.connection.teleport((double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5, target.yaw, 0.0f);
                player.connection.resetPosition();
                targetLevel.addDuringTeleport((Entity)player);
                player.triggerDimensionChangeTriggers(oldLevel);
                player.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
                playerList.sendLevelInfo(player, targetLevel);
                playerList.sendAllPlayerInfo(player);
                playerList.sendActivePlayerEffects(player);
                player.lastSentExp = -1;
                player.lastSentHealth = -1.0f;
                player.lastSentFood = -1;
                ForgeEventFactory.onPlayerChangedDimension((Player)player, (ResourceKey)oldLevel.dimension(), (ResourceKey)targetLevel.dimension());
            } else {
                Entity newEntity = entity.getType().create((Level)targetLevel, EntitySpawnReason.DIMENSION_TRAVEL);
                if (newEntity != null) {
                    newEntity.restoreFrom(entity);
                    newEntity.snapTo((double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5, target.yaw, 0.0f);
                    newEntity.setYHeadRot(target.yaw);
                    newEntity.setDeltaMovement(Vec3.ZERO);
                    newEntity.fallDistance = 0.0;
                    newEntity.setOnGround(true);
                    entity.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
                    targetLevel.addDuringTeleport(newEntity);
                    return newEntity;
                }
            }
        }
        return entity;
    }
}

