/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.data;

import com.supermartijn642.core.generator.ModelGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class WormholeModelGenerator
extends ModelGenerator {
    public WormholeModelGenerator(ResourceCache cache) {
        super("wormhole", cache);
    }

    public void generate() {
        this.cubeAll("block/portal_frame", ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"portal_frame"));
        this.model("block/portals/portal_x").parent("minecraft", "block/block").texture("portal", "#all").particleTexture("#all").element(element -> element.shape(6.0f, 0.0f, 0, 10.0f, 16.0f, 16.0f).face(Direction.EAST, face -> face.texture("portal")).face(Direction.WEST, face -> face.texture("portal")));
        this.model("block/portals/portal_y").parent("minecraft", "block/block").texture("portal", "#all").particleTexture("#all").element(element -> element.shape(0.0f, 6.0f, 0, 16.0f, 10.0f, 16.0f).face(Direction.UP, face -> face.texture("portal")).face(Direction.DOWN, face -> face.texture("portal")));
        this.model("block/portals/portal_z").parent("minecraft", "block/block").texture("portal", "#all").particleTexture("#all").element(element -> element.shape(0.0f, 0.0f, 6, 16.0f, 16.0f, 10.0f).face(Direction.NORTH, face -> face.texture("portal")).face(Direction.SOUTH, face -> face.texture("portal")));
        for (DyeColor color : DyeColor.values()) {
            this.model("block/portals/portal_x_" + color.getName()).parent("block/portals/portal_x").texture("all", "portal/portal_" + color.getName());
            this.model("block/portals/portal_y_" + color.getName()).parent("block/portals/portal_y").texture("all", "portal/portal_" + color.getName());
            this.model("block/portals/portal_z_" + color.getName()).parent("block/portals/portal_z").texture("all", "portal/portal_" + color.getName());
        }
        this.cubeAll("block/portal_stabilizer_off", ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"portal_stabilizer_off"));
        this.cubeAll("block/portal_stabilizer_on", ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"portal_stabilizer_on"));
        for (int i = 0; i < 16; ++i) {
            this.cubeAll("block/energy_cells/basic_energy_cell_" + i, ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)("energy_cells/basic_energy_cell_" + i)));
            this.cubeAll("block/energy_cells/advanced_energy_cell_" + i, ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)("energy_cells/basic_energy_cell_" + i)));
        }
        this.cubeAll("block/energy_cells/creative_energy_cell", ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"energy_cells/basic_energy_cell_15"));
        this.model("item/basic_energy_cell").parent("block/energy_cells/basic_energy_cell_0");
        this.model("item/advanced_energy_cell").parent("block/energy_cells/advanced_energy_cell_0");
        this.model("item/creative_energy_cell").parent("block/energy_cells/creative_energy_cell");
        for (TargetCellType type : TargetCellType.values()) {
            for (int i = 0; i <= type.getVisualCapacity(); ++i) {
                this.cubeAll("block/target_cells/" + type.getRegistryName() + "_" + i, ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)("target_cells/" + type.getRegistryName() + "_" + i)));
            }
        }
        this.itemGenerated("item/target_device", ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"target_device"));
        this.itemGenerated("item/advanced_target_device", ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"advanced_target_device"));
    }
}

