/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PortalRendererHelper {
    private static final int ROTATE_TIME = 30000;
    private static final RandomSource RANDOM = RandomSource.create();

    public static void drawPortal(PoseStack poseStack, PortalShape shape, float x, float y, float width, float height) {
        Level level = ClientUtils.getWorld();
        float scale = Math.min(width, height) / ((float)shape.span + 1.0f);
        Vector3f center = new Vector3f((float)(shape.maxCorner.getX() + shape.minCorner.getX()) / 2.0f, (float)(shape.maxCorner.getY() + shape.minCorner.getY()) / 2.0f, (float)(shape.maxCorner.getZ() + shape.minCorner.getZ()) / 2.0f);
        poseStack.pushPose();
        poseStack.translate(x + width / 2.0f, y + height / 2.0f, 0.0f);
        poseStack.scale(scale, -scale, -scale);
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(0.7853981633974483, 1.0, 0.0, 0.0));
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis((double)(System.currentTimeMillis() % 30000L) / 30000.0 * 2.0 * Math.PI, 0.0, 1.0, 0.0));
        poseStack.translate(-center.x(), -center.y(), -center.z());
        for (BlockPos pos : shape.frame) {
            PortalRendererHelper.renderBlock(level, pos, poseStack, (MultiBufferSource)bufferSource, true);
        }
        for (BlockPos pos : shape.area) {
            if (level.isEmptyBlock(pos)) continue;
            PortalRendererHelper.renderBlock(level, pos, poseStack, (MultiBufferSource)bufferSource, level.getBlockState(pos).getBlock() instanceof PortalBlock);
            PortalRendererHelper.renderBlockEntity(level, pos, poseStack, (MultiBufferSource)bufferSource);
        }
        bufferSource.endBatch();
        poseStack.popPose();
    }

    private static void renderBlock(Level level, BlockPos pos, PoseStack poseStack, MultiBufferSource bufferSource, boolean valid) {
        BlockState state = level.getBlockState(pos);
        if (!(state.getBlock() instanceof EnergyCellBlock) && !(state.getBlock() instanceof TargetCellBlock) && state.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        BlockEntity entity = level.getBlockEntity(pos);
        BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
        ModelData modelData = entity == null ? ModelData.EMPTY : entity.getModelData();
        modelData = model.getModelData((BlockAndTintGetter)level, pos, state, modelData);
        poseStack.pushPose();
        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        poseStack.translate(-0.5, -0.5, -0.5);
        for (ChunkSectionLayer layer : model.getRenderTypes(state, RANDOM, modelData)) {
            ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)bufferSource.getBuffer(RenderTypeHelper.getEntityRenderType((ChunkSectionLayer)layer)), (BlockStateModel)model, (float)(valid ? 1.0f : 0.5f), (float)(valid ? 1.0f : 0.5f), (float)(valid ? 1.0f : 0.8f), (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelData)modelData, (ChunkSectionLayer)layer);
        }
        poseStack.popPose();
    }

    private static void renderBlockEntity(Level level, BlockPos pos, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockEntityRenderer entityRenderer;
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity != null && (entityRenderer = ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().getRenderer(entity)) != null) {
            poseStack.pushPose();
            poseStack.translate((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5);
            entityRenderer.render(entity, ClientUtils.getPartialTicks(), poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, Vec3.ZERO);
            poseStack.popPose();
        }
    }
}

