/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.wormhole.WormholeClient;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.screen.PortalGroupScreen;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class PortalTargetEditColorButton
extends AbstractButtonWidget {
    public static final ResourceLocation BUTTONS = ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"gui/small_color_buttons");
    public boolean visible = true;
    private final Supplier<PortalTarget> target = () -> screen.getPortalGroup().getTarget((Integer)targetIndex.get());
    private final Supplier<DyeColor> color;

    public PortalTargetEditColorButton(PortalGroupScreen screen, int x, int y, Supplier<Integer> targetIndex, Supplier<DyeColor> color, Runnable returnScreen) {
        super(x, y, 10, 10, () -> {
            PortalTarget target = screen.getPortalGroup().getTarget((Integer)targetIndex.get());
            if (target != null) {
                WormholeClient.openPortalTargetColorScreen(screen.pos, (Integer)targetIndex.get(), returnScreen);
            }
        });
        this.color = color;
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        PortalTarget target = this.target.get();
        DyeColor color = this.color.get();
        float x = color == null ? 0.0f : (float)(color.getId() + 1) * 8.0f / 136.0f;
        float y = target != null && this.isFocused() ? 0.5f : 0.0f;
        graphics.submitSprite(BUTTONS, (float)this.x, (float)this.y, (float)this.width, (float)this.height, p -> p.uv(x, y, 0.05882353f, 0.5f));
    }

    public void onPress() {
        if (this.visible) {
            super.onPress();
        }
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        if (this.visible) {
            tooltips.accept((Component)TextComponents.translation((String)"wormhole.portal.gui.target_color").get());
        }
    }

    public Component getNarrationMessage() {
        return this.visible ? TextComponents.translation((String)"wormhole.portal.gui.target_color").get() : null;
    }
}

