/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.ingame.WaypointRenderer;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.PlayerPoint;
import journeymap.common.Journeymap;
import journeymap.common.mixin.client.GameRendererInvoker;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class WaypointDecorationRenderer
extends WaypointRenderer {
    @Override
    public void render(GuiGraphics graphics, PoseStack poseStack) {
        this.waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        Collection<ClientWaypointImpl> waypoints = WaypointStore.getInstance().getAll();
        List<ClientWaypointImpl> waypointsOrdered = this.waypointsToDraw(waypoints);
        waypointsOrdered.addAll(WaypointStore.getInstance().getPlayerPoints());
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
        if (waypointsOrdered.isEmpty()) {
            return;
        }
        for (DrawStep.Pass pass : DrawStep.Pass.values()) {
            if (pass == DrawStep.Pass.PreObject || pass == DrawStep.Pass.PostObject || pass == DrawStep.Pass.Tooltip) continue;
            graphics.pose().pushMatrix();
            graphics.pose().scale(1.0f / (float)JmUI.calculateScaleFactor());
            for (ClientWaypointImpl waypoint : waypointsOrdered) {
                try {
                    this.renderWaypoint(graphics, waypoint, poseStack, pass, (MultiBufferSource)buffers);
                }
                catch (Exception t) {
                    Journeymap.getLogger().error("Waypoint decoration failed to render for " + waypoint.getName() + ": ", (Throwable)t);
                }
            }
            buffers.endBatch();
            graphics.pose().popMatrix();
        }
    }

    private List<ClientWaypointImpl> waypointsToDraw(Collection<ClientWaypointImpl> waypoints) {
        String playerDim = this.minecraft.player.level().dimension().location().toString();
        ArrayList<ClientWaypointImpl> toDraw = new ArrayList<ClientWaypointImpl>();
        double closestAngle = 0.0;
        ClientWaypointImpl closestHolder = null;
        for (ClientWaypointImpl waypoint : waypoints) {
            double angle;
            if (!this.canDrawWaypoint(waypoint, playerDim) || this.waypointProperties.shaderBeacon.get().booleanValue() && !this.waypointProperties.showRotatingBeam.get().booleanValue() && !this.waypointProperties.showStaticBeam.get().booleanValue() || !((angle = this.angleToBeacon(waypoint.getPosition())) < 180.0)) continue;
            if (closestHolder == null || angle < closestAngle) {
                if (closestHolder != null) {
                    toDraw.add(closestHolder);
                }
                closestHolder = waypoint;
                closestAngle = angle;
                continue;
            }
            toDraw.add(waypoint);
        }
        if (closestHolder != null) {
            toDraw.add(closestHolder);
        }
        return toDraw;
    }

    private double angleToBeacon(Vec3 waypointVec) {
        double playerDegrees;
        double angle;
        double playerYaw;
        double yaw = Math.atan2(this.renderManager.camera.getPosition().z() - waypointVec.z, this.renderManager.camera.getPosition().x() - waypointVec.x);
        double degrees = Math.toDegrees(yaw) + 90.0;
        if (degrees < 0.0) {
            degrees += 360.0;
        }
        if ((playerYaw = (double)(this.minecraft.cameraEntity.getYHeadRot() % 360.0f)) < 0.0) {
            playerYaw += 360.0;
        }
        if ((angle = Math.abs(degrees - (playerDegrees = Math.toDegrees(playerYaw = Math.toRadians(playerYaw))))) > 180.0) {
            angle -= 180.0;
        }
        return angle;
    }

    @Override
    protected void render(GuiGraphics graphics, PoseStack poseStack, DrawStep.Pass pass, MultiBufferSource buffers, ClientWaypointImpl waypoint, float partialTicks, long gameTime, float[] rgba, float fadeAlpha, double shiftX, double shiftY, double shiftZ, Vec3 playerVec, Vec3 waypointVec, double viewDistance, double actualDistance, double scale) {
        GameRenderer gameRenderer = this.minecraft.gameRenderer;
        Vector4f position = new Vector4f((float)shiftX, (float)shiftY, (float)shiftZ, 1.0f);
        double angle = this.angleToBeacon(waypoint.getPosition());
        Quaternionf rotation = new Quaternionf();
        this.renderManager.camera.rotation().conjugate(rotation);
        position.rotate((Quaternionfc)rotation);
        position.rotateY((float)Math.PI);
        if (position.z <= 0.0f) {
            return;
        }
        Matrix4f projection = gameRenderer.getProjectionMatrix(((GameRendererInvoker)gameRenderer).invokeGetFov(this.renderManager.camera, partialTicks, true));
        position.mulProject((Matrix4fc)projection);
        Window mainWindow = this.minecraft.getWindow();
        int halfWidth = mainWindow.getWidth() / 2;
        int halfHeight = mainWindow.getHeight() / 2;
        double x = position.x * (float)halfWidth + (float)halfWidth;
        double y = position.y * (float)halfHeight + (float)halfHeight;
        scale = this.waypointProperties.textureSmall.get() != false ? 2.0 : 4.0;
        int size = (int)((double)(waypoint instanceof PlayerPoint ? 8 : 16) * scale);
        if (pass == DrawStep.Pass.TextBG || pass == DrawStep.Pass.Text) {
            if (actualDistance > 0.5 && (angle < (double)this.waypointProperties.autoHideLabelAngle.get().intValue() || !this.waypointProperties.autoHideLabel.get().booleanValue())) {
                this.renderNameTag(graphics, waypoint, x, y, fadeAlpha, actualDistance, size);
            }
            if (actualDistance > 0.5 && (waypoint.showDeviation() && angle < (double)this.waypointProperties.autoHideLabelAngle.get().intValue() || !this.waypointProperties.autoHideLabel.get().booleanValue() && waypoint.showDeviation())) {
                this.renderDeviation(graphics, waypoint, x, y, fadeAlpha, playerVec, waypointVec, size);
            }
        }
        if (pass == DrawStep.Pass.Object && actualDistance > 0.1 && (!this.waypointProperties.autoHideIcon.get().booleanValue() || angle < (double)this.waypointProperties.autoHideIconAngle.get().intValue())) {
            this.renderIcon(graphics, waypoint, x, y, fadeAlpha, size);
        }
    }

    protected void renderIcon(GuiGraphics graphics, ClientWaypointImpl waypoint, double iconX, double iconY, float alpha, int size) {
        ResourceLocation texture = waypoint.getTextureResource();
        if (TextureCache.getWaypointIcon(texture) == null) {
            texture = TextureCache.Waypoint;
        }
        DrawUtil.drawOnMapImageScaleCorrected(graphics, texture, waypoint.getIconColor(), alpha, iconX, iconY, size, size, 1.0f, 0.0, false);
    }

    protected void renderWaypointLabel(GuiGraphics graphics, String label, ClientWaypointImpl waypoint, double labelX, double labelY, float alpha) {
        double fontScale = this.waypointProperties.fontScale.get().floatValue();
        DrawUtil.drawLabel(graphics, (Component)Component.literal((String)label), labelX, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.75f * alpha, waypoint.getSafeColor(), alpha, fontScale, false, 0.0);
    }

    protected void renderNameTag(GuiGraphics graphics, ClientWaypointImpl waypoint, double labelX, double labelY, float alpha, double actualDistance, int size) {
        String distanceLabel = Constants.getString("jm.waypoint.distance_meters", "%1.0f");
        String label = waypoint.getDisplayName();
        boolean showName = this.waypointProperties.showName.get() != false && label != null && label.length() > 0;
        boolean showDistance = this.waypointProperties.showDistance.get();
        if (showName || showDistance) {
            StringBuilder sb = new StringBuilder();
            if (this.waypointProperties.boldLabel.get().booleanValue()) {
                sb.append(ChatFormatting.BOLD);
            }
            if (showName) {
                sb.append(label);
            }
            if (showName && showDistance) {
                sb.append(" ");
            }
            if (showDistance) {
                sb.append(String.format(distanceLabel, actualDistance));
            }
            if (sb.length() > 0) {
                label = sb.toString();
                labelY = labelY - (double)(size >> 1) - 8.0;
                this.renderWaypointLabel(graphics, label, waypoint, labelX, labelY, alpha);
            }
        }
    }

    protected void renderDeviation(GuiGraphics graphics, ClientWaypointImpl waypoint, double labelX, double labelY, float alpha, Vec3 playerVec, Vec3 waypointVec, int size) {
        StringBuilder sb = new StringBuilder();
        Vec3 vecTo = playerVec.vectorTo(waypointVec);
        if (this.waypointProperties.boldLabel.get().booleanValue()) {
            sb.append(ChatFormatting.BOLD);
        }
        sb.append(String.format("x:%d, y:%d, z:%d", (int)vecTo.x, (int)vecTo.y, (int)vecTo.z));
        labelY = labelY + (double)(size >> 1) + 36.0;
        this.renderWaypointLabel(graphics, sb.toString(), waypoint, labelX, labelY, alpha);
    }
}

