/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.JourneymapClient;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.WaypointParser;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointImpl;
import journeymap.common.waypoint.WaypointOrigin;
import journeymap.common.waypoint.WaypointPos;
import journeymap.common.waypoint.WaypointSettings;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.waypoints.TrackedWaypoint;
import org.jetbrains.annotations.ApiStatus;

public class ClientWaypointImpl
extends WaypointImpl {
    public ClientWaypointImpl(Waypoint waypoint) {
        super((WaypointImpl)waypoint);
    }

    public ClientWaypointImpl(String name, String version, String modId, String guid, String origin, String groupId, WaypointPos pos, Integer color, WaypointIcon icon, WaypointSettings settings, TreeSet<String> dimensions, Optional<String> customData) {
        super(name, guid);
        this.origin = origin;
        this.pos = pos;
        this.color = color;
        this.icon = icon;
        this.dimensions = dimensions;
        this.version = version;
        this.modId = modId;
        this.settings = settings;
        this.groupId = groupId;
        customData.ifPresent(this::setCustomData);
        if (dimensions.size() == 1) {
            pos.setPrimaryDimension(dimensions.first());
        }
    }

    @ApiStatus.Internal
    public ClientWaypointImpl(String name, WaypointPos pos, Integer color, WaypointSettings settings, String origin, TreeSet<String> dimensions, WaypointIcon icon, String groupId) {
        this(name, "1", WaypointOrigin.fromValue(origin) == null ? origin : "journeymap", UUID.randomUUID().toString(), WaypointOrigin.fromValue(origin) != null ? origin : "journeymap", groupId, pos, color, icon, settings, dimensions, Optional.empty());
        if (!dimensions.isEmpty()) {
            pos.setPrimaryDimension(dimensions.first());
            if ("minecraft:the_nether".equals(pos.getPrimaryDimension())) {
                pos.setX(pos.getX() >> 3);
                pos.setZ(pos.getZ() >> 3);
            }
        }
    }

    public String getDisplayName() {
        String tag = this.getGroup().getTag();
        if (tag != null && !tag.isEmpty()) {
            return "[" + tag + "] " + this.getName();
        }
        return this.getName();
    }

    @Override
    public int getX() {
        Minecraft mc = Minecraft.getInstance();
        if (mc != null && mc.player != null && this.neitherShiftRight((Level)mc.level)) {
            return super.getX() >> 3;
        }
        if (mc != null && mc.player != null && this.netherShiftLeft((Level)mc.level)) {
            return super.getX() << 3;
        }
        return super.getX();
    }

    @Override
    public int getZ() {
        Minecraft mc = Minecraft.getInstance();
        if (mc != null && mc.player != null && this.neitherShiftRight((Level)mc.level)) {
            return super.getZ() >> 3;
        }
        if (mc != null && mc.player != null && this.netherShiftLeft((Level)mc.level)) {
            return super.getZ() << 3;
        }
        return super.getZ();
    }

    public int getRawX() {
        return super.getX();
    }

    public int getRawZ() {
        return super.getZ();
    }

    public double getRawCenterX() {
        return (double)super.getX() + 0.5;
    }

    public double getRawCenterZ() {
        return (double)super.getZ() + 0.5;
    }

    public double getBlockCenteredX() {
        return (double)this.getX() + 0.5;
    }

    public double getBlockCenteredY() {
        return (double)this.getY() + 0.5;
    }

    public double getBlockCenteredZ() {
        return (double)this.getZ() + 0.5;
    }

    public Vec3 getPosition() {
        return new Vec3(this.getBlockCenteredX(), this.getBlockCenteredY(), this.getBlockCenteredZ());
    }

    @Override
    public Integer getIconColor() {
        if (this.getIcon() != null && !this.getIcon().useBeaconColor()) {
            return this.getIcon().getColor();
        }
        return this.getRenderColor();
    }

    public int getRenderColor() {
        if (this.getGroup().colorOverride() && this.getGroup().getColor() != null) {
            return this.getGroup().getColor();
        }
        return super.getColor();
    }

    public boolean isDeathPoint() {
        return WaypointGroupStore.DEATH.getGuid().equals(this.groupId);
    }

    public Integer getSafeColor() {
        if (this.getRed() + this.getGreen() + this.getBlue() >= 100) {
            return this.getRenderColor();
        }
        return 0x404040;
    }

    public AbstractTexture getTexture() {
        AbstractTexture tex = TextureCache.getTexture(this.getTextureResource());
        if (tex == null) {
            tex = TextureCache.getTexture(TextureCache.Waypoint);
        }
        ((TextureAccess)tex).journeymap$setDisplayHeight(16);
        ((TextureAccess)tex).journeymap$setDisplayWidth(16);
        return tex;
    }

    public boolean isTeleportReady() {
        return this.getY() >= Minecraft.getInstance().level.getMinY() && this.isInPlayerDimension();
    }

    public boolean isInPlayerDimension() {
        return this.getDimensions().contains(Minecraft.getInstance().player.level().dimension().location().toString());
    }

    public String toChatString() {
        boolean useName = !this.getName().equals(String.format("%s, %s", this.getX(), this.getZ()));
        return this.toChatString(useName);
    }

    public String toChatString(boolean useName) {
        return ClientWaypointImpl.toChatString(this, useName);
    }

    public static String toChatString(Waypoint waypoint) {
        boolean useName = !waypoint.getName().equals(String.format("%s, %s", waypoint.getX(), waypoint.getZ()));
        return ClientWaypointImpl.toChatString(waypoint, useName);
    }

    public static String toChatString(Waypoint waypoint, boolean useName) {
        String format;
        String result;
        String dim = waypoint.getPrimaryDimension();
        if (!waypoint.getDimensions().isEmpty()) {
            dim = (String)waypoint.getDimensions().first();
        }
        boolean useDim = !"overworld".equalsIgnoreCase(dim);
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<Object> args = new ArrayList<Object>();
        if (useName) {
            parts.add("name:\"%s\"");
            args.add(waypoint.getName().replaceAll("\"", " "));
        }
        parts.add("x:%s, y:%s, z:%s");
        args.add(waypoint.getX());
        args.add(waypoint.getY());
        args.add(waypoint.getZ());
        if (useDim) {
            parts.add("dim:%s");
            args.add(dim);
        }
        if (WaypointParser.parse(result = String.format(format = "[" + Joiner.on((String)", ").join(parts) + "]", args.toArray())) == null) {
            Journeymap.getLogger().warn("Couldn't produce parsable chat string from Waypoint: " + String.valueOf(waypoint));
            if (useName) {
                return ClientWaypointImpl.toChatString(waypoint, false);
            }
        }
        return result;
    }

    public String getPrettyName() {
        ChatFormatting textFormatting = ChatFormatting.WHITE;
        for (ChatFormatting tf : ChatFormatting.values()) {
            if (tf.getColor() == null || !tf.getColor().equals((this.getRed() & 0xFF) << 16 | (this.getGreen() & 0xFF) << 8 | this.getBlue() & 0xFF)) continue;
            textFormatting = tf;
        }
        return String.valueOf(textFormatting) + this.getName() + String.valueOf(ChatFormatting.WHITE);
    }

    public static ClientWaypointImpl fromString(String json) {
        WaypointImpl waypoint = (WaypointImpl)GSON.fromJson(json, WaypointImpl.class);
        return new ClientWaypointImpl((Waypoint)waypoint);
    }

    public ResourceLocation getTextureResource() {
        if (this.getGroup().getIconResourceLocation() != null && this.getGroup().iconOverride()) {
            return this.getGroup().getIconResourceLocation();
        }
        if (this.getIcon() != null && this.getIcon().getResourceLocation() != null) {
            return this.getIcon().getResourceLocation();
        }
        if (WaypointGroupStore.DEATH.getGuid().equals(this.groupId)) {
            return WaypointIcon.DEFAULT_ICON_DEATH;
        }
        return WaypointIcon.DEFAULT_ICON_NORMAL;
    }

    public boolean hasCustomTexture() {
        if (this.getIcon() != null && this.getIcon().getResourceLocation() != null) {
            return this.getIcon().getResourceLocation() != WaypointIcon.DEFAULT_ICON_DEATH && this.getIcon().getResourceLocation() != WaypointIcon.DEFAULT_ICON_NORMAL;
        }
        return false;
    }

    public boolean hasCustomIconColor() {
        return this.hasCustomTexture() && this.getIcon().getColor() != null;
    }

    public String getUuid() {
        return this.getGuid();
    }

    private boolean showOnLocatorBar() {
        return ((WaypointGroupImpl)this.getGroup()).shouldShowOnLocatorBar() && JourneymapClient.getInstance().getWaypointProperties().displayOnLocatorBar.get() != false && this.isEnabled();
    }

    private Vec3 positionFromPlayer() {
        LocalPlayer player = Minecraft.getInstance().player;
        return Minecraft.getInstance().player.blockPosition().distManhattan((Vec3i)this.getBlockPos()) > 3 ? Vec3.atCenterOf((Vec3i)this.getBlockPos()) : player.getEyePosition();
    }

    public double yawAngleToCamera(Level level, TrackedWaypoint.Camera camera) {
        Vec3 vec3 = camera.position().subtract(this.positionFromPlayer()).rotateClockwise90();
        float f = (float)Mth.atan2((double)vec3.z(), (double)vec3.x()) * 57.295776f;
        return Mth.degreesDifference((float)camera.yaw(), (float)f);
    }

    public TrackedWaypoint.PitchDirection pitchDirectionToCamera(Level level, TrackedWaypoint.Projector projector) {
        double d;
        Vec3 vec3 = projector.projectPointToScreen(this.positionFromPlayer());
        boolean bl = vec3.z > 1.0;
        double d2 = d = bl ? -vec3.y : vec3.y;
        if (d < -1.0) {
            return TrackedWaypoint.PitchDirection.DOWN;
        }
        if (d > 1.0) {
            return TrackedWaypoint.PitchDirection.UP;
        }
        if (bl) {
            if (vec3.y > 0.0) {
                return TrackedWaypoint.PitchDirection.UP;
            }
            if (vec3.y < 0.0) {
                return TrackedWaypoint.PitchDirection.DOWN;
            }
        }
        return TrackedWaypoint.PitchDirection.NONE;
    }

    public double distanceSquared(Entity entity) {
        return entity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.getBlockPos()));
    }

    public void renderToLocatorBar(GuiGraphics guiGraphics, int top, ResourceLocation down, ResourceLocation up, Level level) {
        if (this.showOnLocatorBar()) {
            Minecraft minecraft = Minecraft.getInstance();
            double d = this.yawAngleToCamera(level, (TrackedWaypoint.Camera)minecraft.gameRenderer.getMainCamera());
            if (!(d <= -61.0) && !(d > 60.0)) {
                int j = Mth.ceil((float)((float)(guiGraphics.guiWidth() - 9) / 2.0f));
                ResourceLocation resourceLocation = this.getTextureResource();
                int color = this.getIconColor();
                int l = (int)(d * 173.0 / 2.0 / 60.0);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourceLocation, j + l, top - 1, 0.0f, 0.0f, 8, 8, 8, 8, color);
                TrackedWaypoint.PitchDirection pitchDirection = this.pitchDirectionToCamera(level, (TrackedWaypoint.Projector)minecraft.gameRenderer);
                if (pitchDirection != TrackedWaypoint.PitchDirection.NONE) {
                    ResourceLocation resourceLocation2;
                    int m;
                    if (pitchDirection == TrackedWaypoint.PitchDirection.DOWN) {
                        m = 6;
                        resourceLocation2 = down;
                    } else {
                        m = -6;
                        resourceLocation2 = up;
                    }
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, resourceLocation2, j + l, top + m, 7, 5);
                }
            }
        }
    }
}

