/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helpers;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.stream.Collectors;
import journeymap.api.services.ClientPlatformService;
import journeymap.client.event.handlers.KeyEventHandler;
import journeymap.client.event.handlers.keymapping.KeyConflictContext;
import journeymap.client.event.handlers.keymapping.KeyModifier;
import journeymap.client.event.handlers.keymapping.UpdateAwareKeyBinding;
import journeymap.client.event.keymapping.ForgeUpdateAwareKeyBinding;
import journeymap.client.model.block.BlockMD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class ForgeClientHooks
implements ClientPlatformService {
    @Override
    public TextureAtlasSprite getTextureAtlasSprite(BlockMD blockMD) {
        ResourceLocation loc = IClientFluidTypeExtensions.of((FluidType)((LiquidBlock)blockMD.getBlock()).getFluid().getFluidType()).getStillTexture();
        TextureAtlasSprite tas = Minecraft.getInstance().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).getSprite(loc);
        return tas;
    }

    @Override
    public List<BakedQuad> getQuads(BlockStateModel model, @Nullable BlockState blockState, @Nullable Direction facing, @Nullable BlockPos blockPos, ChunkSectionLayer type) {
        return model.collectParts(RandomSource.create()).stream().flatMap(qm -> qm.getQuads(facing).stream()).collect(Collectors.toList());
    }

    @Override
    public int getFluidTint(BlockMD blockMD) {
        FlowingFluid fluidBlock = ((LiquidBlock)blockMD.getBlock()).getFluid();
        if (Fluids.FLOWING_WATER.equals(fluidBlock) || Fluids.WATER.equals(fluidBlock)) {
            return 4159204;
        }
        return IClientFluidTypeExtensions.of((FluidType)fluidBlock.getFluidType()).getTintColor();
    }

    @Override
    public UpdateAwareKeyBinding getKeyBinding(String description, KeyConflictContext keyConflictContext, KeyModifier keyModifier, InputConstants.Type inputType, int keyCode, String category, KeyEventHandler handler) {
        return new ForgeUpdateAwareKeyBinding(description, keyConflictContext, keyModifier, InputConstants.Type.KEYSYM, keyCode, category, handler);
    }

    private ModelData getModelData(BlockPos blockPos) {
        ModelData data = ModelData.EMPTY;
        if (blockPos != null && (data = Minecraft.getInstance().level.getModelDataManager().getAt(blockPos)) == null) {
            data = ModelData.EMPTY;
        }
        return data;
    }
}

