/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.block.entity;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.block.BalmBlockEntities;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntityFactory;
import net.blay09.mods.balm.forge.DeferredRegisters;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ForgeBalmBlockEntities
implements BalmBlockEntities {
    @Override
    public <T extends BlockEntity> DeferredObject<BlockEntityType<T>> registerBlockEntity(ResourceLocation identifier, BalmBlockEntityFactory<T> factory, Supplier<Block[]> blocks) {
        DeferredRegister register = DeferredRegisters.get(Registries.BLOCK_ENTITY_TYPE, identifier.getNamespace());
        RegistryObject registryObject = register.register(identifier.getPath(), () -> {
            Set<Block> resolvedBlocks = Set.of((Block[])blocks.get());
            return new BlockEntityType(factory::create, resolvedBlocks);
        });
        return new DeferredObject<BlockEntityType<T>>(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    @Override
    public <T extends BlockEntity> DeferredObject<BlockEntityType<T>> registerBlockEntity(ResourceLocation identifier, BalmBlockEntityFactory<T> factory, DeferredObject<Block> ... blocks) {
        DeferredRegister register = DeferredRegisters.get(Registries.BLOCK_ENTITY_TYPE, identifier.getNamespace());
        RegistryObject registryObject = register.register(identifier.getPath(), () -> {
            Set resolvedBlocks = Arrays.stream(blocks).map(DeferredObject::get).collect(Collectors.toSet());
            return new BlockEntityType(factory::create, resolvedBlocks);
        });
        return new DeferredObject<BlockEntityType<T>>(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }
}

