/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.forge.DeferredRegisters;
import net.blay09.mods.balm.forge.ModBusEventRegister;
import net.blay09.mods.balm.forge.ModBusEventRegisters;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public record ForgeBalmEntities(NamespaceResolver namespaceResolver) implements BalmEntities
{
    @Override
    public <T extends Entity> DeferredObject<EntityType<T>> registerEntity(ResourceLocation identifier, EntityType.Builder<T> typeBuilder) {
        DeferredRegister register = DeferredRegisters.get(Registries.ENTITY_TYPE, identifier.getNamespace());
        RegistryObject registryObject = register.register(identifier.getPath(), () -> typeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)identifier)));
        return new DeferredObject<EntityType<T>>(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    @Override
    public <T extends LivingEntity> DeferredObject<EntityType<T>> registerEntity(ResourceLocation identifier, EntityType.Builder<T> typeBuilder, Supplier<AttributeSupplier.Builder> attributeBuilder) {
        DeferredRegister register = DeferredRegisters.get(Registries.ENTITY_TYPE, identifier.getNamespace());
        Registrations registrations = this.getActiveRegistrations();
        RegistryObject registryObject = register.register(identifier.getPath(), () -> {
            EntityType entityType = typeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)identifier));
            registrations.attributeSuppliers.put((EntityType<? extends LivingEntity>)entityType, ((AttributeSupplier.Builder)attributeBuilder.get()).build());
            return entityType;
        });
        return new DeferredObject<EntityType<T>>(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    private Registrations getActiveRegistrations() {
        return ModBusEventRegisters.getRegistrations(this.namespaceResolver.getDefaultNamespace(), Registrations.class);
    }

    public static class Registrations
    implements ModBusEventRegister {
        public final Map<EntityType<? extends LivingEntity>, AttributeSupplier> attributeSuppliers = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier>();

        private void registerAttributes(EntityAttributeCreationEvent event) {
            for (Map.Entry<EntityType<? extends LivingEntity>, AttributeSupplier> entry : this.attributeSuppliers.entrySet()) {
                event.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void register(BusGroup busGroup) {
            EntityAttributeCreationEvent.getBus((BusGroup)busGroup).addListener(this::registerAttributes);
        }
    }
}

