/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.io.javalin;

import info.journeymap.shaded.io.javalin.config.EventConfig;
import info.journeymap.shaded.io.javalin.config.JavalinConfig;
import info.journeymap.shaded.io.javalin.http.ExceptionHandler;
import info.journeymap.shaded.io.javalin.http.Handler;
import info.journeymap.shaded.io.javalin.jetty.JettyServer;
import info.journeymap.shaded.io.javalin.router.Endpoint;
import info.journeymap.shaded.io.javalin.router.JavalinDefaultRoutingApi;
import info.journeymap.shaded.io.javalin.security.RouteRole;
import info.journeymap.shaded.io.javalin.util.Util;
import info.journeymap.shaded.io.javalin.websocket.WsConfig;
import info.journeymap.shaded.io.javalin.websocket.WsExceptionHandler;
import info.journeymap.shaded.io.javalin.websocket.WsHandlerType;
import info.journeymap.shaded.jakarta.servlet.Servlet;
import info.journeymap.shaded.kotlin.kotlin.Lazy;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.util.function.Consumer;

public class Javalin
implements JavalinDefaultRoutingApi<Javalin> {
    private final JavalinConfig cfg;
    protected final Lazy<JettyServer> jettyServer;

    protected Javalin(JavalinConfig config) {
        this.cfg = config;
        this.jettyServer = Util.createLazy(() -> new JettyServer(this.cfg));
    }

    @NotNull
    public JavalinConfig unsafeConfig() {
        return this.cfg;
    }

    public JettyServer jettyServer() {
        return this.jettyServer.getValue();
    }

    public static Javalin create() {
        return Javalin.create(config -> {});
    }

    public static Javalin create(Consumer<JavalinConfig> config) {
        JavalinConfig cfg = new JavalinConfig();
        JavalinConfig.applyUserConfig(cfg, config);
        Javalin app = new Javalin(cfg);
        app.jettyServer.getValue();
        return app;
    }

    public static Javalin createAndStart(Consumer<JavalinConfig> config) {
        return Javalin.create(cfg -> {
            cfg.startupWatcherEnabled = false;
            config.accept((JavalinConfig)cfg);
        }).start();
    }

    public Servlet javalinServlet() {
        return this.cfg.pvt.servlet.getValue().getServlet();
    }

    public Javalin start(String host2, int port) {
        this.jettyServer.getValue().start(host2, port);
        return this;
    }

    public Javalin start(int port) {
        this.jettyServer.getValue().start(null, port);
        return this;
    }

    public Javalin start() {
        this.jettyServer.getValue().start(null, null);
        return this;
    }

    public Javalin stop() {
        if (this.jettyServer.getValue().server().isStopping() || this.jettyServer.getValue().server().isStopped()) {
            return this;
        }
        this.jettyServer.getValue().stop();
        return this;
    }

    public Javalin events(Consumer<EventConfig> listener) {
        listener.accept(this.cfg.events);
        return this;
    }

    public int port() {
        return this.jettyServer.getValue().port();
    }

    @Override
    @NotNull
    public <E extends Exception> Javalin exception(@NotNull Class<E> exceptionClass, @NotNull ExceptionHandler<? super E> exceptionHandler) {
        this.cfg.pvt.internalRouter.addHttpExceptionHandler(exceptionClass, exceptionHandler);
        return this;
    }

    @Override
    @NotNull
    public Javalin error(int status, @NotNull String contentType, @NotNull Handler handler) {
        this.cfg.pvt.internalRouter.addHttpErrorHandler(status, contentType, handler);
        return this;
    }

    @Override
    @NotNull
    public Javalin addEndpoint(@NotNull Endpoint endpoint) {
        this.cfg.pvt.internalRouter.addHttpEndpoint(endpoint);
        return this;
    }

    @Override
    @NotNull
    public <E extends Exception> Javalin wsException(@NotNull Class<E> exceptionClass, @NotNull WsExceptionHandler<? super E> exceptionHandler) {
        this.cfg.pvt.internalRouter.addWsExceptionHandler(exceptionClass, exceptionHandler);
        return this;
    }

    @Override
    @NotNull
    public Javalin addWsHandler(@NotNull WsHandlerType handlerType, @NotNull String path, @NotNull Consumer<WsConfig> wsConfig, RouteRole ... roles) {
        this.cfg.pvt.internalRouter.addWsHandler(handlerType, path, wsConfig, roles);
        return this;
    }
}

