/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.io.javalin.jetty;

import info.journeymap.shaded.io.javalin.compression.CompressionStrategy;
import info.journeymap.shaded.io.javalin.compression.CompressionStrategyKt;
import info.journeymap.shaded.io.javalin.compression.Compressor;
import info.journeymap.shaded.io.javalin.http.Context;
import info.journeymap.shaded.io.javalin.util.JavalinLogger;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.collections.CollectionsKt;
import info.journeymap.shaded.kotlin.kotlin.io.ByteStreamsKt;
import info.journeymap.shaded.kotlin.kotlin.jvm.JvmField;
import info.journeymap.shaded.kotlin.kotlin.jvm.JvmStatic;
import info.journeymap.shaded.kotlin.kotlin.jvm.functions.Function1;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.SourceDebugExtension;
import info.journeymap.shaded.kotlin.kotlin.text.StringsKt;
import info.journeymap.shaded.org.eclipse.jetty.http.MimeTypes;
import info.journeymap.shaded.org.eclipse.jetty.util.resource.Resource;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0002J&\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Linfo/journeymap/shaded/io/javalin/jetty/JettyPrecompressingResourceHandler;", "", "()V", "compressedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getCompressedFiles", "()Ljava/util/concurrent/ConcurrentHashMap;", "resourceMaxSize", "", "clearCache", "", "excludedMimeType", "", "mimeType", "compressionStrategy", "Linfo/journeymap/shaded/io/javalin/compression/CompressionStrategy;", "findMatchingCompressor", "Linfo/journeymap/shaded/io/javalin/compression/Compressor;", "contentTypeHeader", "getCompressedByteArray", "resource", "Linfo/journeymap/shaded/org/eclipse/jetty/util/resource/Resource;", "compressor", "getStaticResourceByteArray", "target", "handle", "ctx", "Linfo/journeymap/shaded/io/javalin/http/Context;", "compStrat", "javalin"})
@SourceDebugExtension(value={"SMAP\nJettyPrecompressingResourceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JettyPrecompressingResourceHandler.kt\nio/javalin/jetty/JettyPrecompressingResourceHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1747#2,3:89\n1549#2:92\n1620#2,3:93\n1#3:96\n*S KotlinDebug\n*F\n+ 1 JettyPrecompressingResourceHandler.kt\nio/javalin/jetty/JettyPrecompressingResourceHandler\n*L\n76#1:89,3\n85#1:92\n85#1:93,3\n*E\n"})
public final class JettyPrecompressingResourceHandler {
    @NotNull
    public static final JettyPrecompressingResourceHandler INSTANCE = new JettyPrecompressingResourceHandler();
    @NotNull
    private static final ConcurrentHashMap<String, byte[]> compressedFiles = new ConcurrentHashMap();
    @JvmField
    public static int resourceMaxSize = 0x200000;

    private JettyPrecompressingResourceHandler() {
    }

    @NotNull
    public final ConcurrentHashMap<String, byte[]> getCompressedFiles() {
        return compressedFiles;
    }

    @JvmStatic
    public static final void clearCache() {
        compressedFiles.clear();
    }

    public final boolean handle(@NotNull String target, @NotNull Resource resource, @NotNull Context ctx, @NotNull CompressionStrategy compStrat) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(resource, "resource");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(compStrat, "compStrat");
        String string = ctx.header("Accept-Encoding");
        if (string == null) {
            string = "";
        }
        Compressor compressor = this.findMatchingCompressor(string, compStrat);
        String contentType = MimeTypes.getDefaultMimeByExtension(target);
        if (contentType == null || this.excludedMimeType(contentType, compStrat)) {
            compressor = null;
        }
        byte[] byArray = this.getStaticResourceByteArray(resource, target, compressor);
        if (byArray == null) {
            return false;
        }
        byte[] resultByteArray = byArray;
        if (compressor != null) {
            ctx.header("Content-Encoding", compressor.encoding());
        }
        ctx.header("Content-Length", String.valueOf(resultByteArray.length));
        String string2 = contentType;
        if (string2 == null) {
            string2 = "";
        }
        ctx.header("Content-Type", string2);
        String string3 = ctx.header("If-None-Match");
        if (string3 != null) {
            String requestEtag = string3;
            boolean bl = false;
            if (Intrinsics.areEqual(requestEtag, resource.getWeakETag())) {
                ctx.status(304);
                return true;
            }
        }
        String string4 = resource.getWeakETag();
        Intrinsics.checkNotNullExpressionValue(string4, "getWeakETag(...)");
        ctx.header("ETag", string4);
        ctx.result(resultByteArray);
        return true;
    }

    private final byte[] getStaticResourceByteArray(Resource resource, String target, Compressor compressor) {
        if (resource.length() > (long)resourceMaxSize) {
            JavalinLogger.warn$default("Static file '" + target + "' is larger than configured max size for pre-compression (" + resourceMaxSize + " bytes).\nYou can configure the max size with `JettyPrecompressingResourceHandler.resourceMaxSize = newMaxSize`.", null, 2, null);
            return null;
        }
        Object object = compressor;
        if (object == null || (object = object.extension()) == null) {
            object = "";
        }
        Object ext = object;
        return compressedFiles.computeIfAbsent(target + (String)ext, arg_0 -> JettyPrecompressingResourceHandler.getStaticResourceByteArray$lambda$1(new Function1<String, byte[]>(resource, compressor){
            final /* synthetic */ Resource $resource;
            final /* synthetic */ Compressor $compressor;
            {
                this.$resource = $resource;
                this.$compressor = $compressor;
                super(1);
            }

            @NotNull
            public final byte[] invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return JettyPrecompressingResourceHandler.access$getCompressedByteArray(JettyPrecompressingResourceHandler.INSTANCE, this.$resource, this.$compressor);
            }
        }, arg_0));
    }

    private final byte[] getCompressedByteArray(Resource resource, Compressor compressor) {
        InputStream fileInput = resource.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Object object = compressor;
        if (object == null || (object = object.compress(byteArrayOutputStream)) == null) {
            object = byteArrayOutputStream;
        }
        Object outputStream = object;
        Intrinsics.checkNotNull(fileInput);
        ByteStreamsKt.copyTo$default(fileInput, (OutputStream)outputStream, 0, 2, null);
        fileInput.close();
        ((OutputStream)outputStream).close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    private final boolean excludedMimeType(String mimeType, CompressionStrategy compressionStrategy) {
        boolean bl;
        block7: {
            if (Intrinsics.areEqual(mimeType, "")) {
                bl = false;
            } else if (compressionStrategy.getAllowedMimeTypes().contains(mimeType)) {
                bl = false;
            } else {
                Iterable $this$any$iv = compressionStrategy.getExcludedMimeTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String excluded = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains((CharSequence)mimeType, excluded, true)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Compressor findMatchingCompressor(String contentTypeHeader, CompressionStrategy compressionStrategy) {
        Object object;
        block2: {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)contentTypeHeader, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            for (String it : (Iterable)((List)destination$iv$iv)) {
                boolean bl = false;
                object2 = CompressionStrategyKt.forType(compressionStrategy.getCompressors(), it);
                if (object2 == null) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return object;
    }

    private static final byte[] getStaticResourceByteArray$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (byte[])$tmp0.invoke(p0);
    }

    public static final /* synthetic */ byte[] access$getCompressedByteArray(JettyPrecompressingResourceHandler $this, Resource resource, Compressor compressor) {
        return $this.getCompressedByteArray(resource, compressor);
    }
}

