/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.io.javalin.router;

import info.journeymap.shaded.io.javalin.config.RouterConfig;
import info.journeymap.shaded.io.javalin.event.EventManager;
import info.journeymap.shaded.io.javalin.event.HandlerMetaInfo;
import info.journeymap.shaded.io.javalin.event.WsHandlerMetaInfo;
import info.journeymap.shaded.io.javalin.http.Context;
import info.journeymap.shaded.io.javalin.http.ExceptionHandler;
import info.journeymap.shaded.io.javalin.http.Handler;
import info.journeymap.shaded.io.javalin.http.HandlerType;
import info.journeymap.shaded.io.javalin.router.Endpoint;
import info.journeymap.shaded.io.javalin.router.ParsedEndpoint;
import info.journeymap.shaded.io.javalin.router.error.ErrorMapper;
import info.journeymap.shaded.io.javalin.router.exception.ExceptionMapper;
import info.journeymap.shaded.io.javalin.router.matcher.PathMatcher;
import info.journeymap.shaded.io.javalin.security.Roles;
import info.journeymap.shaded.io.javalin.security.RouteRole;
import info.journeymap.shaded.io.javalin.util.Util;
import info.journeymap.shaded.io.javalin.websocket.WsConfig;
import info.journeymap.shaded.io.javalin.websocket.WsExceptionHandler;
import info.journeymap.shaded.io.javalin.websocket.WsHandlerEntry;
import info.journeymap.shaded.io.javalin.websocket.WsHandlerType;
import info.journeymap.shaded.io.javalin.websocket.WsRouter;
import info.journeymap.shaded.jakarta.servlet.http.HttpServletResponse;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.collections.ArraysKt;
import info.journeymap.shaded.kotlin.kotlin.collections.SetsKt;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J4\u0010\u001f\u001a\u00020\u0000\"\f\b\u0000\u0010 *\u00060!j\u0002`\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H 0$2\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u0002H 0&H\u0016J4\u0010'\u001a\u00020\u0000\"\f\b\u0000\u0010 *\u00060!j\u0002`\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H 0$2\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u0002H 0(H\u0016J?\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001c2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020201\"\u000202H\u0016\u00a2\u0006\u0002\u00103J\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\f\u00107\u001a\b\u0012\u0004\u0012\u00020805J\"\u00109\u001a\b\u0012\u0004\u0012\u0002060:2\u0006\u0010*\u001a\u00020;2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020>2\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0016J\u001a\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020H2\u0006\u0010C\u001a\u00020DH\u0016J\u0018\u0010I\u001a\u00020J2\u0006\u0010*\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Linfo/journeymap/shaded/io/javalin/router/InternalRouter;", "", "wsRouter", "Linfo/journeymap/shaded/io/javalin/websocket/WsRouter;", "eventManager", "Linfo/journeymap/shaded/io/javalin/event/EventManager;", "routerConfig", "Linfo/journeymap/shaded/io/javalin/config/RouterConfig;", "(Lio/javalin/websocket/WsRouter;Lio/javalin/event/EventManager;Lio/javalin/config/RouterConfig;)V", "httpErrorMapper", "Linfo/journeymap/shaded/io/javalin/router/error/ErrorMapper;", "getHttpErrorMapper", "()Lio/javalin/router/error/ErrorMapper;", "httpExceptionMapper", "Linfo/journeymap/shaded/io/javalin/router/exception/ExceptionMapper;", "getHttpExceptionMapper", "()Lio/javalin/router/exception/ExceptionMapper;", "httpPathMatcher", "Linfo/journeymap/shaded/io/javalin/router/matcher/PathMatcher;", "getHttpPathMatcher", "()Lio/javalin/router/matcher/PathMatcher;", "addHttpEndpoint", "endpoint", "Linfo/journeymap/shaded/io/javalin/router/Endpoint;", "addHttpErrorHandler", "status", "", "contentType", "", "handler", "Linfo/journeymap/shaded/io/javalin/http/Handler;", "addHttpExceptionHandler", "E", "Ljava/lang/Exception;", "Linfo/journeymap/shaded/kotlin/kotlin/Exception;", "exceptionClass", "Ljava/lang/Class;", "exceptionHandler", "Linfo/journeymap/shaded/io/javalin/http/ExceptionHandler;", "addWsExceptionHandler", "Linfo/journeymap/shaded/io/javalin/websocket/WsExceptionHandler;", "addWsHandler", "handlerType", "Linfo/journeymap/shaded/io/javalin/websocket/WsHandlerType;", "path", "wsConfig", "Ljava/util/function/Consumer;", "Linfo/journeymap/shaded/io/javalin/websocket/WsConfig;", "roles", "", "Linfo/journeymap/shaded/io/javalin/security/RouteRole;", "(Lio/javalin/websocket/WsHandlerType;Ljava/lang/String;Ljava/util/function/Consumer;[Lio/javalin/security/RouteRole;)Lio/javalin/router/InternalRouter;", "allHttpHandlers", "", "Linfo/journeymap/shaded/io/javalin/router/ParsedEndpoint;", "allWsHandlers", "Linfo/journeymap/shaded/io/javalin/websocket/WsHandlerEntry;", "findHttpHandlerEntries", "Ljava/util/stream/Stream;", "Linfo/journeymap/shaded/io/javalin/http/HandlerType;", "requestUri", "handleHttpError", "", "statusCode", "ctx", "Linfo/journeymap/shaded/io/javalin/http/Context;", "handleHttpException", "throwable", "", "handleHttpUnexpectedThrowable", "", "res", "Linfo/journeymap/shaded/jakarta/servlet/http/HttpServletResponse;", "hasHttpHandlerEntry", "", "javalin"})
public class InternalRouter {
    @NotNull
    private final WsRouter wsRouter;
    @NotNull
    private final EventManager eventManager;
    @NotNull
    private final RouterConfig routerConfig;
    @NotNull
    private final PathMatcher httpPathMatcher;
    @NotNull
    private final ErrorMapper httpErrorMapper;
    @NotNull
    private final ExceptionMapper httpExceptionMapper;

    public InternalRouter(@NotNull WsRouter wsRouter, @NotNull EventManager eventManager2, @NotNull RouterConfig routerConfig) {
        Intrinsics.checkNotNullParameter(wsRouter, "wsRouter");
        Intrinsics.checkNotNullParameter(eventManager2, "eventManager");
        Intrinsics.checkNotNullParameter(routerConfig, "routerConfig");
        this.wsRouter = wsRouter;
        this.eventManager = eventManager2;
        this.routerConfig = routerConfig;
        this.httpPathMatcher = new PathMatcher();
        this.httpErrorMapper = new ErrorMapper();
        this.httpExceptionMapper = new ExceptionMapper(this.routerConfig);
    }

    @NotNull
    protected PathMatcher getHttpPathMatcher() {
        return this.httpPathMatcher;
    }

    @NotNull
    protected ErrorMapper getHttpErrorMapper() {
        return this.httpErrorMapper;
    }

    @NotNull
    protected ExceptionMapper getHttpExceptionMapper() {
        return this.httpExceptionMapper;
    }

    @NotNull
    public InternalRouter addHttpEndpoint(@NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter(endpoint, "endpoint");
        this.getHttpPathMatcher().add(new ParsedEndpoint(endpoint, this.routerConfig));
        HandlerType handlerType = endpoint.getMethod();
        String string = Util.prefixContextPath(this.routerConfig.contextPath, endpoint.getPath());
        Handler handler = endpoint.getHandler();
        Object object = endpoint.metadata(Roles.class);
        if (object == null || (object = ((Roles)object).getRoles()) == null) {
            object = SetsKt.emptySet();
        }
        this.eventManager.fireHandlerAddedEvent(new HandlerMetaInfo(handlerType, string, handler, (Set<? extends RouteRole>)object));
        return this;
    }

    @NotNull
    public final List<ParsedEndpoint> allHttpHandlers() {
        return this.getHttpPathMatcher().allEntries();
    }

    public boolean hasHttpHandlerEntry(@NotNull HandlerType handlerType, @NotNull String requestUri) {
        Intrinsics.checkNotNullParameter((Object)handlerType, "handlerType");
        Intrinsics.checkNotNullParameter(requestUri, "requestUri");
        return this.getHttpPathMatcher().hasEntries$javalin(handlerType, requestUri);
    }

    @NotNull
    public Stream<ParsedEndpoint> findHttpHandlerEntries(@NotNull HandlerType handlerType, @Nullable String requestUri) {
        Intrinsics.checkNotNullParameter((Object)handlerType, "handlerType");
        return this.getHttpPathMatcher().findEntries(handlerType, requestUri);
    }

    public static /* synthetic */ Stream findHttpHandlerEntries$default(InternalRouter internalRouter, HandlerType handlerType, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findHttpHandlerEntries");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return internalRouter.findHttpHandlerEntries(handlerType, string);
    }

    @NotNull
    public InternalRouter addHttpErrorHandler(int status, @NotNull String contentType, @NotNull Handler handler) {
        Intrinsics.checkNotNullParameter(contentType, "contentType");
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.getHttpErrorMapper().addHandler(status, contentType, handler);
        return this;
    }

    public void handleHttpError(int statusCode, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        this.getHttpErrorMapper().handle(statusCode, ctx);
    }

    @NotNull
    public <E extends Exception> InternalRouter addHttpExceptionHandler(@NotNull Class<E> exceptionClass, @NotNull ExceptionHandler<? super E> exceptionHandler) {
        Intrinsics.checkNotNullParameter(exceptionClass, "exceptionClass");
        Intrinsics.checkNotNullParameter(exceptionHandler, "exceptionHandler");
        this.getHttpExceptionMapper().getHandlers().put(exceptionClass, exceptionHandler);
        return this;
    }

    public void handleHttpException(@NotNull Context ctx, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.getHttpExceptionMapper().handle$javalin(ctx, throwable);
    }

    @Nullable
    public Void handleHttpUnexpectedThrowable(@NotNull HttpServletResponse res, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(res, "res");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        return this.getHttpExceptionMapper().handleUnexpectedThrowable$javalin(res, throwable);
    }

    @NotNull
    public <E extends Exception> InternalRouter addWsExceptionHandler(@NotNull Class<E> exceptionClass, @NotNull WsExceptionHandler<? super E> exceptionHandler) {
        Intrinsics.checkNotNullParameter(exceptionClass, "exceptionClass");
        Intrinsics.checkNotNullParameter(exceptionHandler, "exceptionHandler");
        this.wsRouter.getWsExceptionMapper().getHandlers().put(exceptionClass, exceptionHandler);
        return this;
    }

    @NotNull
    public InternalRouter addWsHandler(@NotNull WsHandlerType handlerType, @NotNull String path, @NotNull Consumer<WsConfig> wsConfig, RouteRole ... roles) {
        Intrinsics.checkNotNullParameter((Object)handlerType, "handlerType");
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(wsConfig, "wsConfig");
        Intrinsics.checkNotNullParameter(roles, "roles");
        HashSet roleSet = new HashSet(ArraysKt.asList(roles));
        this.wsRouter.addHandler(handlerType, path, wsConfig, roleSet);
        this.eventManager.fireWsHandlerAddedEvent(new WsHandlerMetaInfo(handlerType, Util.prefixContextPath(this.routerConfig.contextPath, path), wsConfig, roleSet));
        return this;
    }

    @NotNull
    public final List<WsHandlerEntry> allWsHandlers() {
        return this.wsRouter.getWsPathMatcher().allEntries();
    }
}

