/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.org.eclipse.jetty.server.handler;

import info.journeymap.shaded.jakarta.servlet.DispatcherType;
import info.journeymap.shaded.jakarta.servlet.ServletException;
import info.journeymap.shaded.jakarta.servlet.http.HttpServletRequest;
import info.journeymap.shaded.jakarta.servlet.http.HttpServletResponse;
import info.journeymap.shaded.org.eclipse.jetty.server.Handler;
import info.journeymap.shaded.org.eclipse.jetty.server.Request;
import info.journeymap.shaded.org.eclipse.jetty.server.Server;
import info.journeymap.shaded.org.eclipse.jetty.util.annotation.ManagedObject;
import info.journeymap.shaded.org.eclipse.jetty.util.component.ContainerLifeCycle;
import info.journeymap.shaded.org.slf4j.Logger;
import info.journeymap.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;

@ManagedObject(value="Jetty Handler")
public abstract class AbstractHandler
extends ContainerLifeCycle
implements Handler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHandler.class);
    private Server _server;

    @Override
    public abstract void handle(String var1, Request var2, HttpServletRequest var3, HttpServletResponse var4) throws IOException, ServletException;

    @Deprecated
    protected void doError(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object o = request.getAttribute("info.journeymap.shaded.jakarta.servlet.error.status_code");
        int code = o instanceof Integer ? (Integer)o : (o != null ? Integer.parseInt(o.toString()) : 500);
        response.setStatus(code);
        baseRequest.setHandled(true);
    }

    @Override
    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting {}", (Object)this);
        }
        if (this._server == null) {
            LOG.warn("No Server set for {}", (Object)this);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stopping {}", (Object)this);
        }
        super.doStop();
    }

    @Override
    public void setServer(Server server) {
        if (this._server == server) {
            return;
        }
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._server = server;
    }

    @Override
    public Server getServer() {
        return this._server;
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        super.destroy();
    }

    @Deprecated
    public static abstract class ErrorDispatchHandler
    extends AbstractHandler {
        @Override
        public final void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (baseRequest.getDispatcherType() == DispatcherType.ERROR) {
                this.doError(target, baseRequest, request, response);
            } else {
                this.doNonErrorHandle(target, baseRequest, request, response);
            }
        }

        @Deprecated
        protected abstract void doNonErrorHandle(String var1, Request var2, HttpServletRequest var3, HttpServletResponse var4) throws IOException, ServletException;
    }
}

