/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.internal;

import info.journeymap.shaded.jakarta.servlet.http.HttpServletRequest;
import info.journeymap.shaded.jakarta.servlet.http.HttpServletResponse;
import info.journeymap.shaded.org.eclipse.jetty.http.HttpMethod;
import info.journeymap.shaded.org.eclipse.jetty.http.HttpVersion;
import info.journeymap.shaded.org.eclipse.jetty.io.ByteBufferPool;
import info.journeymap.shaded.org.eclipse.jetty.io.EndPoint;
import info.journeymap.shaded.org.eclipse.jetty.io.RetainableByteBufferPool;
import info.journeymap.shaded.org.eclipse.jetty.server.Connector;
import info.journeymap.shaded.org.eclipse.jetty.server.HttpChannel;
import info.journeymap.shaded.org.eclipse.jetty.server.Request;
import info.journeymap.shaded.org.eclipse.jetty.server.Response;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.FrameHandler;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.WebSocketComponents;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.internal.WebSocketConnection;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.internal.WebSocketCoreSession;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.WebSocketNegotiation;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.internal.AbstractHandshaker;
import info.journeymap.shaded.org.eclipse.jetty.websocket.core.server.internal.RFC8441Negotiation;

public class RFC8441Handshaker
extends AbstractHandshaker {
    @Override
    protected boolean validateRequest(HttpServletRequest request) {
        if (!HttpMethod.CONNECT.is(request.getMethod())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded method!=GET {}", (Object)request);
            }
            return false;
        }
        if (!HttpVersion.HTTP_2.is(request.getProtocol())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded HttpVersion!=2 {}", (Object)request);
            }
            return false;
        }
        return true;
    }

    @Override
    protected WebSocketNegotiation newNegotiation(HttpServletRequest request, HttpServletResponse response, WebSocketComponents webSocketComponents) {
        return new RFC8441Negotiation(Request.getBaseRequest(request), request, response, webSocketComponents);
    }

    @Override
    protected boolean validateFrameHandler(FrameHandler frameHandler, HttpServletResponse response) {
        if (frameHandler == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded: no frame handler provided");
            }
            response.setStatus(503);
        }
        return true;
    }

    @Override
    protected WebSocketConnection createWebSocketConnection(Request baseRequest, WebSocketCoreSession coreSession) {
        HttpChannel httpChannel = baseRequest.getHttpChannel();
        Connector connector = httpChannel.getConnector();
        EndPoint endPoint = httpChannel.getTunnellingEndPoint();
        ByteBufferPool byteBufferPool = connector.getByteBufferPool();
        RetainableByteBufferPool retainableByteBufferPool = byteBufferPool.asRetainableByteBufferPool();
        return this.newWebSocketConnection(endPoint, connector.getExecutor(), connector.getScheduler(), byteBufferPool, retainableByteBufferPool, coreSession);
    }

    @Override
    protected void prepareResponse(Response response, WebSocketNegotiation negotiation) {
        response.setStatus(200);
    }
}

