/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.oreharvester_common_fabric.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.BlockFunctions;
import com.natamus.collective_common_fabric.functions.ItemFunctions;
import com.natamus.oreharvester_common_fabric.config.ConfigHandler;
import com.natamus.oreharvester_common_fabric.data.Variables;
import com.natamus.oreharvester_common_fabric.util.Util;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class OreMineEvents {
    public static boolean onOreHarvest(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        class_2248 block;
        if (level.field_9236) {
            return true;
        }
        Pair cachePair = new Pair((Object)level, (Object)player);
        if (!Variables.harvestSpeedCache.containsKey(cachePair)) {
            if (ConfigHandler.oreHarvestWithoutSneak ? player.method_18276() : !player.method_18276()) {
                return true;
            }
        } else {
            Variables.harvestSpeedCache.remove(cachePair);
        }
        if (!Util.isOre(block = blockState.method_26204())) {
            return true;
        }
        class_1799 handStack = player.method_5998(class_1268.field_5808);
        if (!Variables.allowedPickaxes.contains(handStack.method_7909())) {
            return true;
        }
        List<class_2338> oresAround = Util.getOresNextToEachOther(level, blockPos, block);
        int oreCount = oresAround.size();
        if (oreCount < 0) {
            return true;
        }
        if (ConfigHandler.dropOresAtFirstBrokenBlock) {
            class_1792 oreItem = Util.getOreDrop(level, blockState, block, handStack, player, class_243.method_24953((class_2382)blockPos));
            if (!Variables.lastDropLocations.containsKey(oreItem)) {
                Variables.lastDropLocations.put(oreItem, new CopyOnWriteArrayList());
            }
            class_2338 immutableBlockPos = blockPos.method_10062();
            Variables.lastDropLocations.get(oreItem).add(immutableBlockPos);
            Variables.lastAction.put(immutableBlockPos, new Date());
        }
        int durabilityLoseCount = (int)Math.ceil(1.0 / ConfigHandler.loseDurabilityModifier);
        int durabilityStartCount = -1;
        class_3222 serverPlayer = (class_3222)player;
        for (class_2338 orePos : oresAround) {
            class_2680 logstate = level.method_8320(orePos);
            class_2248 log = logstate.method_26204();
            BlockFunctions.dropBlock((class_1937)level, (class_2338)orePos, (class_1297)player, (class_1799)handStack);
            if (player.method_68878()) continue;
            if (ConfigHandler.loseDurabilityPerHarvestedOre) {
                if (durabilityStartCount == -1) {
                    durabilityStartCount = durabilityLoseCount;
                    ItemFunctions.itemHurtBreakAndEvent((class_1799)handStack, (class_3222)serverPlayer, (class_1268)class_1268.field_5808, (int)1);
                } else if (--durabilityLoseCount == 0) {
                    ItemFunctions.itemHurtBreakAndEvent((class_1799)handStack, (class_3222)serverPlayer, (class_1268)class_1268.field_5808, (int)1);
                    durabilityLoseCount = durabilityStartCount;
                }
            }
            if (!ConfigHandler.increaseExhaustionPerHarvestedOre) continue;
            player.method_7322(0.025f * (float)ConfigHandler.increaseExhaustionModifier);
        }
        return false;
    }

    public static float onHarvestBreakSpeed(class_1937 level, class_1657 player, float digSpeed, class_2680 state) {
        if (!ConfigHandler.increaseHarvestingTimePerOre) {
            return digSpeed;
        }
        class_2248 block = state.method_26204();
        if (!Util.isOre(block)) {
            return digSpeed;
        }
        if (ConfigHandler.oreHarvestWithoutSneak ? player.method_18276() : !player.method_18276()) {
            return digSpeed;
        }
        class_1799 handStack = player.method_5998(class_1268.field_5808);
        if (!Variables.allowedPickaxes.contains(handStack.method_7909())) {
            return digSpeed;
        }
        int oreCount = -1;
        Date now = new Date();
        Pair keyPair = new Pair((Object)level, (Object)player);
        if (Variables.harvestSpeedCache.containsKey(keyPair)) {
            Pair<Date, Integer> valuePair = Variables.harvestSpeedCache.get(keyPair);
            long ms = now.getTime() - ((Date)valuePair.getFirst()).getTime();
            if (ms < 1000L) {
                oreCount = (Integer)valuePair.getSecond();
            } else {
                Variables.harvestSpeedCache.remove(keyPair);
            }
        }
        class_2338 blockPos = null;
        class_239 hitResult = player.method_5745(20.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            blockPos = ((class_3965)hitResult).method_17777();
        }
        if (blockPos == null) {
            return digSpeed;
        }
        boolean recheck = false;
        if (oreCount < 0) {
            List<class_2338> oresAround = Util.getOresNextToEachOther(level, blockPos, block);
            oreCount = oresAround.size();
            if (oreCount == 0) {
                return digSpeed;
            }
            Variables.harvestSpeedCache.put((Pair<class_1937, class_1657>)keyPair, (Pair<Date, Integer>)new Pair((Object)now, (Object)oreCount));
            recheck = true;
        }
        return digSpeed / (1.0f + (float)oreCount * (float)ConfigHandler.increasedHarvestingTimePerOreModifier);
    }
}

