/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.oreharvester_common_neoforge.events;

import com.natamus.oreharvester_common_neoforge.config.ConfigHandler;
import com.natamus.oreharvester_common_neoforge.data.Variables;
import com.natamus.oreharvester_common_neoforge.processing.PickaxeBlacklist;
import java.util.Date;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class WorldEvents {
    public static void onWorldLoad(Level level) {
        PickaxeBlacklist.attemptProcessingPickaxeBlacklist(level);
    }

    public static void onItemEntityJoinWorld(Level world, Entity entity) {
        if (!ConfigHandler.dropOresAtFirstBrokenBlock) {
            return;
        }
        if (world.isClientSide) {
            return;
        }
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity ie = (ItemEntity)entity;
        Item item = ie.getItem().getItem();
        if (!Variables.lastDropLocations.containsKey(item)) {
            return;
        }
        Date now = new Date();
        BlockPos blockPos = entity.blockPosition();
        BlockPos lowBlockPos = new BlockPos(blockPos.getX(), 1, blockPos.getZ());
        for (BlockPos lastDropPos : Variables.lastDropLocations.get(item)) {
            if (Variables.lastAction.containsKey(lastDropPos)) {
                Date lastdate = Variables.lastAction.get(lastDropPos);
                long ms = now.getTime() - lastdate.getTime();
                if (ms > 2000L) {
                    Variables.lastDropLocations.get(item).remove(lastDropPos);
                    Variables.lastAction.remove(lastDropPos);
                    continue;
                }
            }
            if (!lowBlockPos.closerThan((Vec3i)new BlockPos(lastDropPos.getX(), 1, lastDropPos.getZ()), 20.0)) continue;
            entity.setDeltaMovement(0.0, 0.0, 0.0);
            entity.teleportTo((double)lastDropPos.getX() + 0.5, (double)lastDropPos.getY() + 0.5, (double)lastDropPos.getZ() + 0.5);
            Variables.lastAction.put(lastDropPos.immutable(), now);
        }
    }
}

