/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import net.optifine.Config;

public class ComparableVersion
implements Comparable<ComparableVersion> {
    private int[] elements;

    public ComparableVersion(String ver) {
        String[] parts = Config.tokenize((String)ver, (String)".");
        this.elements = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            int elem;
            String part = parts[i];
            this.elements[i] = elem = Config.parseInt((String)part, (int)-1);
        }
    }

    @Override
    public int compareTo(ComparableVersion cv) {
        for (int i = 0; i < this.elements.length && i < cv.elements.length; ++i) {
            if (this.elements[i] == cv.elements[i]) continue;
            return this.elements[i] - cv.elements[i];
        }
        if (this.elements.length != cv.elements.length) {
            return this.elements.length - cv.elements.length;
        }
        return 0;
    }

    public int getMajor() {
        if (this.elements.length < 1) {
            return -1;
        }
        return this.elements[0];
    }

    public int getMinor() {
        if (this.elements.length < 2) {
            return -1;
        }
        return this.elements[1];
    }

    public int getPatch() {
        if (this.elements.length < 3) {
            return -1;
        }
        return this.elements[2];
    }

    public String toString() {
        return Config.arrayToString((int[])this.elements, (String)".");
    }
}

