/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomColorFader;
import net.optifine.CustomColormap;
import net.optifine.CustomColors;
import net.optifine.LightMap;
import net.optifine.LightMapPack;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.render.RenderEnv;
import net.optifine.util.BiomeUtils;
import net.optifine.util.ColorUtils;
import net.optifine.util.EntityUtils;
import net.optifine.util.PotionUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import net.optifine.util.WorldUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomColors {
    private static String paletteFormatDefault = "vanilla";
    private static CustomColormap waterColors = null;
    private static CustomColormap foliagePineColors = null;
    private static CustomColormap foliageBirchColors = null;
    private static CustomColormap swampFoliageColors = null;
    private static CustomColormap swampGrassColors = null;
    private static CustomColormap[] colorsBlockColormaps = null;
    private static CustomColormap[][] blockColormaps = null;
    private static CustomColormap skyColors = null;
    private static CustomColorFader skyColorFader = new CustomColorFader();
    private static CustomColormap fogColors = null;
    private static CustomColorFader fogColorFader = new CustomColorFader();
    private static CustomColormap underwaterColors = null;
    private static CustomColorFader underwaterColorFader = new CustomColorFader();
    private static CustomColormap underlavaColors = null;
    private static CustomColorFader underlavaColorFader = new CustomColorFader();
    private static LightMapPack[] lightMapPacks = null;
    private static int lightmapMinDimensionId = 0;
    private static CustomColormap redstoneColors = null;
    private static CustomColormap xpOrbColors = null;
    private static int xpOrbTime = -1;
    private static CustomColormap durabilityColors = null;
    private static CustomColormap stemColors = null;
    private static CustomColormap stemMelonColors = null;
    private static CustomColormap stemPumpkinColors = null;
    private static CustomColormap lavaDropColors = null;
    private static CustomColormap myceliumParticleColors = null;
    private static boolean useDefaultGrassFoliageColors = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static int expBarTextColor = -1;
    private static int bossTextColor = -1;
    private static int signTextColor = -1;
    private static fis fogColorNether = null;
    private static fis fogColorEnd = null;
    private static fis skyColorEnd = null;
    private static int[] spawnEggPrimaryColors = null;
    private static int[] spawnEggSecondaryColors = null;
    private static int[] wolfCollarColors = null;
    private static int[] sheepColors = null;
    private static int[] textColors = null;
    private static int[] mapColorsOriginal = null;
    private static int[] dyeColorsOriginal = null;
    private static int[] potionColors = null;
    private static final eeb BLOCK_STATE_DIRT = dqb.j.m();
    private static final eeb BLOCK_STATE_WATER = dqb.J.m();
    public static Random random = new Random();
    private static final IColorizer COLORIZER_GRASS = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_FOLIAGE = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_FOLIAGE_PINE = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_FOLIAGE_BIRCH = new /* Unavailable Anonymous Inner Class!! */;
    private static final IColorizer COLORIZER_WATER = new /* Unavailable Anonymous Inner Class!! */;

    public static void update() {
        paletteFormatDefault = "vanilla";
        waterColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        underlavaColors = null;
        redstoneColors = null;
        xpOrbColors = null;
        xpOrbTime = -1;
        durabilityColors = null;
        stemColors = null;
        lavaDropColors = null;
        myceliumParticleColors = null;
        lightMapPacks = null;
        particleWaterColor = -1;
        particlePortalColor = -1;
        lilyPadColor = -1;
        expBarTextColor = -1;
        bossTextColor = -1;
        signTextColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        colorsBlockColormaps = null;
        blockColormaps = null;
        useDefaultGrassFoliageColors = true;
        spawnEggPrimaryColors = null;
        spawnEggSecondaryColors = null;
        wolfCollarColors = null;
        sheepColors = null;
        textColors = null;
        CustomColors.setMapColors((int[])mapColorsOriginal);
        CustomColors.setDyeColors((int[])dyeColorsOriginal);
        potionColors = null;
        paletteFormatDefault = CustomColors.getValidProperty((String)"optifine/color.properties", (String)"palette.format", (String[])CustomColormap.FORMAT_STRINGS, (String)"vanilla");
        String mcpColormap = "optifine/colormap/";
        String[] waterPaths = new String[]{"water.png", "watercolorx.png"};
        waterColors = CustomColors.getCustomColors((String)mcpColormap, (String[])waterPaths, (int)256, (int)-1);
        CustomColors.updateUseDefaultGrassFoliageColors();
        if (!Config.isCustomColors()) {
            return;
        }
        String[] pinePaths = new String[]{"pine.png", "pinecolor.png"};
        foliagePineColors = CustomColors.getCustomColors((String)mcpColormap, (String[])pinePaths, (int)256, (int)-1);
        String[] birchPaths = new String[]{"birch.png", "birchcolor.png"};
        foliageBirchColors = CustomColors.getCustomColors((String)mcpColormap, (String[])birchPaths, (int)256, (int)-1);
        String[] swampGrassPaths = new String[]{"swampgrass.png", "swampgrasscolor.png"};
        swampGrassColors = CustomColors.getCustomColors((String)mcpColormap, (String[])swampGrassPaths, (int)256, (int)-1);
        String[] swampFoliagePaths = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
        swampFoliageColors = CustomColors.getCustomColors((String)mcpColormap, (String[])swampFoliagePaths, (int)256, (int)-1);
        String[] sky0Paths = new String[]{"sky0.png", "skycolor0.png"};
        skyColors = CustomColors.getCustomColors((String)mcpColormap, (String[])sky0Paths, (int)256, (int)-1);
        String[] fog0Paths = new String[]{"fog0.png", "fogcolor0.png"};
        fogColors = CustomColors.getCustomColors((String)mcpColormap, (String[])fog0Paths, (int)256, (int)-1);
        String[] underwaterPaths = new String[]{"underwater.png", "underwatercolor.png"};
        underwaterColors = CustomColors.getCustomColors((String)mcpColormap, (String[])underwaterPaths, (int)256, (int)-1);
        String[] underlavaPaths = new String[]{"underlava.png", "underlavacolor.png"};
        underlavaColors = CustomColors.getCustomColors((String)mcpColormap, (String[])underlavaPaths, (int)256, (int)-1);
        String[] redstonePaths = new String[]{"redstone.png", "redstonecolor.png"};
        redstoneColors = CustomColors.getCustomColors((String)mcpColormap, (String[])redstonePaths, (int)16, (int)1);
        xpOrbColors = CustomColors.getCustomColors((String)(mcpColormap + "xporb.png"), (int)-1, (int)-1);
        durabilityColors = CustomColors.getCustomColors((String)(mcpColormap + "durability.png"), (int)-1, (int)-1);
        String[] stemPaths = new String[]{"stem.png", "stemcolor.png"};
        stemColors = CustomColors.getCustomColors((String)mcpColormap, (String[])stemPaths, (int)8, (int)1);
        stemPumpkinColors = CustomColors.getCustomColors((String)(mcpColormap + "pumpkinstem.png"), (int)8, (int)1);
        stemMelonColors = CustomColors.getCustomColors((String)(mcpColormap + "melonstem.png"), (int)8, (int)1);
        lavaDropColors = CustomColors.getCustomColors((String)(mcpColormap + "lavadrop.png"), (int)-1, (int)1);
        String[] myceliumPaths = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
        myceliumParticleColors = CustomColors.getCustomColors((String)mcpColormap, (String[])myceliumPaths, (int)-1, (int)-1);
        Pair lightMaps = CustomColors.parseLightMapPacks();
        lightMapPacks = (LightMapPack[])lightMaps.getLeft();
        lightmapMinDimensionId = (Integer)lightMaps.getRight();
        CustomColors.readColorProperties((String)"optifine/color.properties");
        blockColormaps = CustomColors.readBlockColormaps((String[])new String[]{mcpColormap + "custom/", mcpColormap + "blocks/"}, (CustomColormap[])colorsBlockColormaps, (int)256, (int)-1);
        CustomColors.updateUseDefaultGrassFoliageColors();
    }

    private static String getValidProperty(String fileName, String key, String[] validValues, String valDef) {
        try {
            ame loc = new ame(fileName);
            InputStream in = Config.getResourceStream((ame)loc);
            if (in == null) {
                return valDef;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            String val = props.getProperty(key);
            if (val == null) {
                return valDef;
            }
            List<String> listValidValues = Arrays.asList(validValues);
            if (!listValidValues.contains(val)) {
                CustomColors.warn((String)("Invalid value: " + key + "=" + val));
                CustomColors.warn((String)("Expected values: " + Config.arrayToString((Object[])validValues)));
                return valDef;
            }
            CustomColors.dbg((String)(key + "=" + val));
            return val;
        }
        catch (FileNotFoundException e) {
            return valDef;
        }
        catch (IOException e) {
            e.printStackTrace();
            return valDef;
        }
    }

    private static Pair<LightMapPack[], Integer> parseLightMapPacks() {
        String lightmapPrefix = "optifine/lightmap/world";
        String lightmapSuffix = ".png";
        String[] pathsLightmap = ResUtils.collectFiles((String)lightmapPrefix, (String)lightmapSuffix);
        HashMap<Integer, String> mapLightmaps = new HashMap<Integer, String>();
        for (int i = 0; i < pathsLightmap.length; ++i) {
            String path = pathsLightmap[i];
            String dimIdStr = StrUtils.removePrefixSuffix((String)path, (String)lightmapPrefix, (String)lightmapSuffix);
            int dimId = Config.parseInt((String)dimIdStr, (int)Integer.MIN_VALUE);
            if (dimId == Integer.MIN_VALUE) continue;
            mapLightmaps.put(dimId, path);
        }
        Set setDimIds = mapLightmaps.keySet();
        Object[] dimIds = setDimIds.toArray(new Integer[setDimIds.size()]);
        Arrays.sort(dimIds);
        if (dimIds.length <= 0) {
            return new ImmutablePair(null, (Object)0);
        }
        int minDimId = (Integer)dimIds[0];
        int maxDimId = (Integer)dimIds[dimIds.length - 1];
        int countDim = maxDimId - minDimId + 1;
        CustomColormap[] colormaps = new CustomColormap[countDim];
        for (int i = 0; i < dimIds.length; ++i) {
            Object dimId = dimIds[i];
            String path = (String)mapLightmaps.get(dimId);
            CustomColormap colors = CustomColors.getCustomColors((String)path, (int)-1, (int)-1);
            if (colors == null) continue;
            if (colors.getWidth() < 16) {
                CustomColors.warn((String)("Invalid lightmap width: " + colors.getWidth() + ", path: " + path));
                continue;
            }
            int lightmapIndex = (Integer)dimId - minDimId;
            colormaps[lightmapIndex] = colors;
        }
        LightMapPack[] lmps = new LightMapPack[colormaps.length];
        for (int i = 0; i < colormaps.length; ++i) {
            LightMapPack lmp;
            CustomColormap cm = colormaps[i];
            if (cm == null) continue;
            String name = cm.name;
            String basePath = cm.basePath;
            CustomColormap cmRain = CustomColors.getCustomColors((String)(basePath + "/" + name + "_rain.png"), (int)-1, (int)-1);
            CustomColormap cmThunder = CustomColors.getCustomColors((String)(basePath + "/" + name + "_thunder.png"), (int)-1, (int)-1);
            LightMap lm = new LightMap(cm);
            LightMap lmRain = cmRain != null ? new LightMap(cmRain) : null;
            LightMap lmThunder = cmThunder != null ? new LightMap(cmThunder) : null;
            lmps[i] = lmp = new LightMapPack(lm, lmRain, lmThunder);
        }
        return new ImmutablePair((Object)lmps, (Object)minDimId);
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream in = Config.getResourceStream((ame)new ame(path));
            if (in == null) {
                return defHeight;
            }
            BufferedImage bi = ImageIO.read(in);
            in.close();
            if (bi == null) {
                return defHeight;
            }
            return bi.getHeight();
        }
        catch (IOException e) {
            return defHeight;
        }
    }

    private static void readColorProperties(String fileName) {
        try {
            int[] dyeColors;
            ame loc = new ame(fileName);
            InputStream in = Config.getResourceStream((ame)loc);
            if (in == null) {
                return;
            }
            CustomColors.dbg((String)("Loading " + fileName));
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            particleWaterColor = CustomColors.readColor((Properties)props, (String[])new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColors.readColor((Properties)props, (String)"particle.portal");
            lilyPadColor = CustomColors.readColor((Properties)props, (String)"lilypad");
            expBarTextColor = CustomColors.readColor((Properties)props, (String)"text.xpbar");
            bossTextColor = CustomColors.readColor((Properties)props, (String)"text.boss");
            signTextColor = CustomColors.readColor((Properties)props, (String)"text.sign");
            fogColorNether = CustomColors.readColorVec3((Properties)props, (String)"fog.nether");
            fogColorEnd = CustomColors.readColorVec3((Properties)props, (String)"fog.end");
            skyColorEnd = CustomColors.readColorVec3((Properties)props, (String)"sky.end");
            colorsBlockColormaps = CustomColors.readCustomColormaps((Properties)props, (String)fileName);
            spawnEggPrimaryColors = CustomColors.readSpawnEggColors((Properties)props, (String)fileName, (String)"egg.shell.", (String)"Spawn egg shell");
            spawnEggSecondaryColors = CustomColors.readSpawnEggColors((Properties)props, (String)fileName, (String)"egg.spots.", (String)"Spawn egg spot");
            wolfCollarColors = CustomColors.readDyeColors((Properties)props, (String)fileName, (String)"collar.", (String)"Wolf collar");
            sheepColors = CustomColors.readDyeColors((Properties)props, (String)fileName, (String)"sheep.", (String)"Sheep");
            textColors = CustomColors.readTextColors((Properties)props, (String)fileName, (String)"text.code.", (String)"Text");
            int[] mapColors = CustomColors.readMapColors((Properties)props, (String)fileName, (String)"map.", (String)"Map");
            if (mapColors != null) {
                if (mapColorsOriginal == null) {
                    mapColorsOriginal = CustomColors.getMapColors();
                }
                CustomColors.setMapColors((int[])mapColors);
            }
            if ((dyeColors = CustomColors.readDyeColors((Properties)props, (String)fileName, (String)"dye.", (String)"Dye")) != null) {
                if (dyeColorsOriginal == null) {
                    dyeColorsOriginal = CustomColors.getDyeColors();
                }
                CustomColors.setDyeColors((int[])dyeColors);
            }
            potionColors = CustomColors.readPotionColors((Properties)props, (String)fileName, (String)"potion.", (String)"Potion");
            xpOrbTime = Config.parseInt((String)props.getProperty("xporb.time"), (int)-1);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            Config.warn((String)("Error parsing: " + fileName));
            Config.warn((String)(e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CustomColormap[] readCustomColormaps(Properties props, String fileName) {
        void var7_9;
        ArrayList<CustomColormap> list = new ArrayList<CustomColormap>();
        String palettePrefix = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(palettePrefix)) continue;
            map.put(string, value);
        }
        String[] propNames = map.keySet().toArray(new String[map.size()]);
        boolean bl = false;
        while (var7_9 < propNames.length) {
            String name = propNames[var7_9];
            String value = props.getProperty(name);
            CustomColors.dbg((String)("Block palette: " + name + " = " + value));
            String path = name.substring(palettePrefix.length());
            String basePath = TextureUtils.getBasePath((String)fileName);
            path = TextureUtils.fixResourcePath((String)path, (String)basePath);
            CustomColormap colors = CustomColors.getCustomColors((String)path, (int)256, (int)-1);
            if (colors == null) {
                CustomColors.warn((String)("Colormap not found: " + path));
            } else {
                ConnectedParser cp = new ConnectedParser("CustomColors");
                MatchBlock[] mbs = cp.parseMatchBlocks(value);
                if (mbs == null || mbs.length <= 0) {
                    CustomColors.warn((String)("Invalid match blocks: " + value));
                } else {
                    for (int m = 0; m < mbs.length; ++m) {
                        MatchBlock mb = mbs[m];
                        colors.addMatchBlock(mb);
                    }
                    list.add(colors);
                }
            }
            ++var7_9;
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[] customColormapArray = list.toArray(new CustomColormap[list.size()]);
        return customColormapArray;
    }

    private static CustomColormap[][] readBlockColormaps(String[] basePaths, CustomColormap[] basePalettes, int width, int height) {
        int i;
        Object[] paths = ResUtils.collectFiles((String[])basePaths, (String[])new String[]{".properties"});
        Arrays.sort(paths);
        ArrayList blockList = new ArrayList();
        for (i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            CustomColors.dbg((String)("Block colormap: " + (String)path));
            try {
                ame locFile = new ame("minecraft", (String)path);
                InputStream in = Config.getResourceStream((ame)locFile);
                if (in == null) {
                    CustomColors.warn((String)("File not found: " + (String)path));
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                CustomColormap cm = new CustomColormap((Properties)props, (String)path, width, height, paletteFormatDefault);
                if (!cm.isValid((String)path) || !cm.isValidMatchBlocks((String)path)) continue;
                CustomColors.addToBlockList((CustomColormap)cm, blockList);
                continue;
            }
            catch (FileNotFoundException e) {
                CustomColors.warn((String)("File not found: " + (String)path));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (basePalettes != null) {
            for (i = 0; i < basePalettes.length; ++i) {
                CustomColormap cm = basePalettes[i];
                CustomColors.addToBlockList((CustomColormap)cm, blockList);
            }
        }
        if (blockList.size() <= 0) {
            return null;
        }
        CustomColormap[][] cmArr = CustomColors.blockListToArray(blockList);
        return cmArr;
    }

    private static void addToBlockList(CustomColormap cm, List blockList) {
        int[] ids = cm.getMatchBlockIds();
        if (ids == null || ids.length <= 0) {
            CustomColors.warn((String)("No match blocks: " + Config.arrayToString((int[])ids)));
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            int blockId = ids[i];
            if (blockId < 0) {
                CustomColors.warn((String)("Invalid block ID: " + blockId));
                continue;
            }
            CustomColors.addToList((CustomColormap)cm, (List)blockList, (int)blockId);
        }
    }

    private static void addToList(CustomColormap cm, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomColormap> subList = (ArrayList<CustomColormap>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomColormap>();
            list.set(id, subList);
        }
        subList.add(cm);
    }

    private static CustomColormap[][] blockListToArray(List list) {
        CustomColormap[][] colArr = new CustomColormap[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            CustomColormap[] subArr = subList.toArray(new CustomColormap[subList.size()]);
            colArr[i] = subArr;
        }
        return colArr;
    }

    private static int readColor(Properties props, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int col = CustomColors.readColor((Properties)props, (String)name);
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            return -1;
        }
        int color = CustomColors.parseColor((String)(str = str.trim()));
        if (color < 0) {
            CustomColors.warn((String)("Invalid color: " + name + " = " + str));
            return color;
        }
        CustomColors.dbg((String)(name + " = " + str));
        return color;
    }

    private static int parseColor(String str) {
        if (str == null) {
            return -1;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static fis readColorVec3(Properties props, String name) {
        int col = CustomColors.readColor((Properties)props, (String)name);
        if (col < 0) {
            return null;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return new fis((double)redF, (double)greenF, (double)blueF);
    }

    private static CustomColormap getCustomColors(String basePath, String[] paths, int width, int height) {
        for (int i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            CustomColormap cols = CustomColors.getCustomColors((String)(path = basePath + (String)path), (int)width, (int)height);
            if (cols == null) continue;
            return cols;
        }
        return null;
    }

    public static CustomColormap getCustomColors(String pathImage, int width, int height) {
        try {
            ame loc = new ame(pathImage);
            if (!Config.hasResource((ame)loc)) {
                return null;
            }
            CustomColors.dbg((String)("Colormap " + pathImage));
            PropertiesOrdered props = new PropertiesOrdered();
            String pathProps = StrUtils.replaceSuffix((String)pathImage, (String)".png", (String)".properties");
            ame locProps = new ame(pathProps);
            if (Config.hasResource((ame)locProps)) {
                InputStream in = Config.getResourceStream((ame)locProps);
                props.load(in);
                in.close();
                CustomColors.dbg((String)("Colormap properties: " + pathProps));
            } else {
                props.put("format", paletteFormatDefault);
                props.put("source", pathImage);
                pathProps = pathImage;
            }
            CustomColormap cm = new CustomColormap((Properties)props, pathProps, width, height, paletteFormatDefault);
            if (!cm.isValid(pathProps)) {
                return null;
            }
            return cm;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultGrassFoliageColors() {
        useDefaultGrassFoliageColors = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null;
    }

    public static int getColorMultiplier(gyv quad, eeb blockState, dlv blockAccess, jb blockPos, RenderEnv renderEnv) {
        return CustomColors.getColorMultiplier((boolean)quad.a(), (eeb)blockState, (dlv)blockAccess, (jb)blockPos, (RenderEnv)renderEnv);
    }

    public static int getColorMultiplier(boolean quadHasTintIndex, eeb blockState, dlv blockAccess, jb blockPos, RenderEnv renderEnv) {
        IColorizer colorizer;
        dpz block = blockState.b();
        eeb blockStateColormap = blockState;
        if (blockColormaps != null) {
            CustomColormap cm;
            if (!quadHasTintIndex) {
                if (block == dqb.i) {
                    blockStateColormap = BLOCK_STATE_DIRT;
                }
                if (block == dqb.cH) {
                    return -1;
                }
            }
            if (block instanceof dsi && blockState.c((efe)dsi.b) == eex.a) {
                blockPos = blockPos.e();
                blockStateColormap = blockAccess.a_(blockPos);
            }
            if ((cm = CustomColors.getBlockColormap((eeb)blockStateColormap)) != null) {
                if (Config.isSmoothBiomes() && !cm.isColorConstant()) {
                    return CustomColors.getSmoothColorMultiplier((eeb)blockState, (dlv)blockAccess, (jb)blockPos, (IColorizer)cm, (BlockPosM)renderEnv.getColorizerBlockPosM());
                }
                return cm.getColor(blockAccess, blockPos);
            }
        }
        if (!quadHasTintIndex) {
            return -1;
        }
        if (block == dqb.fF) {
            return CustomColors.getLilypadColorMultiplier((dlv)blockAccess, (jb)blockPos);
        }
        if (block == dqb.cH) {
            return CustomColors.getRedstoneColor((eeb)renderEnv.getBlockState());
        }
        if (block instanceof dyg) {
            return CustomColors.getStemColorMultiplier((eeb)blockState, (dly)blockAccess, (jb)blockPos, (RenderEnv)renderEnv);
        }
        if (useDefaultGrassFoliageColors) {
            return -1;
        }
        if (block == dqb.i || block instanceof dyq || block instanceof dsi || block == dqb.ej) {
            colorizer = COLORIZER_GRASS;
        } else if (block instanceof dsi) {
            colorizer = COLORIZER_GRASS;
            if (blockState.c((efe)dsi.b) == eex.a) {
                blockPos = blockPos.e();
            }
        } else if (block instanceof duq) {
            if (block == dqb.aL) {
                colorizer = COLORIZER_FOLIAGE_PINE;
            } else if (block == dqb.aM) {
                colorizer = COLORIZER_FOLIAGE_BIRCH;
            } else {
                if (block == dqb.aP) {
                    return -1;
                }
                if (!blockState.getBlockLocation().isDefaultNamespace()) {
                    return -1;
                }
                colorizer = COLORIZER_FOLIAGE;
            }
        } else if (block == dqb.fx) {
            colorizer = COLORIZER_FOLIAGE;
        } else {
            return -1;
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier((eeb)blockState, (dlv)blockAccess, (jb)blockPos, (IColorizer)colorizer, (BlockPosM)renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockStateColormap, blockAccess, blockPos);
    }

    protected static dnx getColorBiome(dlv blockAccess, jb blockPos) {
        dnx biome = BiomeUtils.getBiome((dlv)blockAccess, (jb)blockPos);
        biome = CustomColors.fixBiome((dnx)biome);
        return biome;
    }

    public static dnx fixBiome(dnx biome) {
        if (!(biome != BiomeUtils.SWAMP && biome != BiomeUtils.MANGROVE_SWAMP || Config.isSwampColors())) {
            return BiomeUtils.PLAINS;
        }
        return biome;
    }

    private static CustomColormap getBlockColormap(eeb blockState) {
        if (blockColormaps == null) {
            return null;
        }
        if (!(blockState instanceof eeb)) {
            return null;
        }
        eeb bs = blockState;
        int blockId = bs.getBlockId();
        if (blockId < 0 || blockId >= blockColormaps.length) {
            return null;
        }
        CustomColormap[] cms = blockColormaps[blockId];
        if (cms == null) {
            return null;
        }
        for (int i = 0; i < cms.length; ++i) {
            CustomColormap cm = cms[i];
            if (!cm.matchesBlock(bs)) continue;
            return cm;
        }
        return null;
    }

    private static int getSmoothColorMultiplier(eeb blockState, dlv blockAccess, jb blockPos, IColorizer colorizer, BlockPosM blockPosM) {
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int x = blockPos.u();
        int y = blockPos.v();
        int z2 = blockPos.w();
        BlockPosM posM = blockPosM;
        int radius = Config.getBiomeBlendRadius();
        int width = radius * 2 + 1;
        int count = width * width;
        for (int ix = x - radius; ix <= x + radius; ++ix) {
            for (int iz = z2 - radius; iz <= z2 + radius; ++iz) {
                posM.setXyz(ix, y, iz);
                int col = colorizer.getColor(blockState, blockAccess, (jb)posM);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
            }
        }
        int r = sumRed / count;
        int g = sumGreen / count;
        int b = sumBlue / count;
        return r << 16 | g << 8 | b;
    }

    public static int getFluidColor(dlv blockAccess, eeb blockState, jb blockPos, RenderEnv renderEnv) {
        dpz block = blockState.b();
        CustomColormap colorizer = CustomColors.getBlockColormap((eeb)blockState);
        if (colorizer == null && blockState.b() == dqb.J) {
            colorizer = COLORIZER_WATER;
        }
        if (colorizer == null) {
            return CustomColors.getBlockColors().a(blockState, blockAccess, blockPos, 0);
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier((eeb)blockState, (dlv)blockAccess, (jb)blockPos, (IColorizer)colorizer, (BlockPosM)renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockState, blockAccess, blockPos);
    }

    public static fvi getBlockColors() {
        return fue.R().az();
    }

    public static void updatePortalFX(gut fx) {
        if (particlePortalColor < 0) {
            return;
        }
        int col = particlePortalColor;
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    public static void updateLavaFX(gut fx) {
        if (lavaDropColors == null) {
            return;
        }
        int age = fx.getAge();
        int col = lavaDropColors.getColor(age);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    public static void updateMyceliumFX(gut fx) {
        if (myceliumParticleColors == null) {
            return;
        }
        int col = myceliumParticleColors.getColorRandom();
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    private static int getRedstoneColor(eeb blockState) {
        if (redstoneColors == null) {
            return -1;
        }
        int level = CustomColors.getRedstoneLevel((eeb)blockState, (int)15);
        int col = redstoneColors.getColor(level);
        return col;
    }

    public static void updateReddustFX(gut fx, dlv blockAccess, double x, double y, double z2) {
        if (redstoneColors == null) {
            return;
        }
        eeb state = blockAccess.a_(jb.a((double)x, (double)y, (double)z2));
        int level = CustomColors.getRedstoneLevel((eeb)state, (int)15);
        int col = redstoneColors.getColor(level);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    private static int getRedstoneLevel(eeb state, int def) {
        dpz block = state.b();
        if (!(block instanceof dwj)) {
            return def;
        }
        Comparable val = state.c((efe)dwj.f);
        if (!(val instanceof Integer)) {
            return def;
        }
        Integer valInt = (Integer)val;
        return valInt;
    }

    public static float getXpOrbTimer(float timer) {
        if (xpOrbTime <= 0) {
            return timer;
        }
        float kt = 628.0f / (float)xpOrbTime;
        return timer * kt;
    }

    public static int getXpOrbColor(float timer) {
        if (xpOrbColors == null) {
            return -1;
        }
        int index = (int)Math.round((double)((bcb.a((float)timer) + 1.0f) * (float)(xpOrbColors.getLength() - 1)) / 2.0);
        int col = xpOrbColors.getColor(index);
        return col;
    }

    public static int getDurabilityColor(float dur, int color) {
        if (durabilityColors == null) {
            return color;
        }
        int index = (int)(dur * (float)durabilityColors.getLength());
        int col = durabilityColors.getColor(index);
        return col;
    }

    public static void updateWaterFX(gut fx, dlv blockAccess, double x, double y, double z2, RenderEnv renderEnv) {
        if (waterColors == null && blockColormaps == null && particleWaterColor < 0) {
            return;
        }
        jb blockPos = jb.a((double)x, (double)y, (double)z2);
        renderEnv.reset(BLOCK_STATE_WATER, blockPos);
        int col = CustomColors.getFluidColor((dlv)blockAccess, (eeb)BLOCK_STATE_WATER, (jb)blockPos, (RenderEnv)renderEnv);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        if (particleWaterColor >= 0) {
            int redDrop = particleWaterColor >> 16 & 0xFF;
            int greenDrop = particleWaterColor >> 8 & 0xFF;
            int blueDrop = particleWaterColor & 0xFF;
            redF = (float)redDrop / 255.0f;
            greenF = (float)greenDrop / 255.0f;
            blueF = (float)blueDrop / 255.0f;
            redF *= (float)redDrop / 255.0f;
            greenF *= (float)greenDrop / 255.0f;
            blueF *= (float)blueDrop / 255.0f;
        }
        fx.a(redF, greenF, blueF);
    }

    private static int getLilypadColorMultiplier(dlv blockAccess, jb blockPos) {
        if (lilyPadColor < 0) {
            return CustomColors.getBlockColors().a(dqb.fF.m(), blockAccess, blockPos, 0);
        }
        return lilyPadColor;
    }

    private static fis getFogColorNether(fis col) {
        if (fogColorNether == null) {
            return col;
        }
        return fogColorNether;
    }

    private static fis getFogColorEnd(fis col) {
        if (fogColorEnd == null) {
            return col;
        }
        return fogColorEnd;
    }

    private static fis getSkyColorEnd(fis col) {
        if (skyColorEnd == null) {
            return col;
        }
        return skyColorEnd;
    }

    public static int getSkyColor(int skyColor, dlv blockAccess, double x, double y, double z2) {
        fis skyColorVec = ColorUtils.argbToVec3((int)skyColor);
        fis newColVec = CustomColors.getSkyColor((fis)skyColorVec, (dlv)blockAccess, (double)x, (double)y, (double)z2);
        int newCol = ColorUtils.vec3ToArgb((fis)newColVec);
        return newCol;
    }

    public static fis getSkyColor(fis skyColor3d, dlv blockAccess, double x, double y, double z2) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int col = skyColors.getColorSmooth(blockAccess, x, y, z2, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)skyColor3d.d / 0.5f;
        float cGreen = (float)skyColor3d.e / 0.66275f;
        float cBlue = (float)skyColor3d.f;
        fis newCol = skyColorFader.getColor((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
        return newCol;
    }

    private static fis getFogColor(fis fogColor3d, dlv blockAccess, double x, double y, double z2) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int col = fogColors.getColorSmooth(blockAccess, x, y, z2, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)fogColor3d.d / 0.753f;
        float cGreen = (float)fogColor3d.e / 0.8471f;
        float cBlue = (float)fogColor3d.f;
        fis newCol = fogColorFader.getColor((double)(redF *= cRed), (double)(greenF *= cGreen), (double)(blueF *= cBlue));
        return newCol;
    }

    public static fis getUnderwaterColor(dlv blockAccess, double x, double y, double z2) {
        return CustomColors.getUnderFluidColor((dlv)blockAccess, (double)x, (double)y, (double)z2, (CustomColormap)underwaterColors, (CustomColorFader)underwaterColorFader);
    }

    public static fis getUnderlavaColor(dlv blockAccess, double x, double y, double z2) {
        return CustomColors.getUnderFluidColor((dlv)blockAccess, (double)x, (double)y, (double)z2, (CustomColormap)underlavaColors, (CustomColorFader)underlavaColorFader);
    }

    public static fis getUnderFluidColor(dlv blockAccess, double x, double y, double z2, CustomColormap underFluidColors, CustomColorFader underFluidColorFader) {
        if (underFluidColors == null) {
            return null;
        }
        int col = underFluidColors.getColorSmooth(blockAccess, x, y, z2, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fis newCol = underFluidColorFader.getColor((double)redF, (double)greenF, (double)blueF);
        return newCol;
    }

    private static int getStemColorMultiplier(eeb blockState, dly blockAccess, jb blockPos, RenderEnv renderEnv) {
        CustomColormap colors = stemColors;
        dpz blockStem = blockState.b();
        if (blockStem == dqb.fv && stemPumpkinColors != null) {
            colors = stemPumpkinColors;
        }
        if (blockStem == dqb.fw && stemMelonColors != null) {
            colors = stemMelonColors;
        }
        if (colors == null) {
            return -1;
        }
        if (!(blockStem instanceof dyg)) {
            return -1;
        }
        int level = (Integer)blockState.c((efe)dyg.c);
        return colors.getColor(level);
    }

    public static boolean updateLightmap(grk world, float torchFlickerX, fnf lmColors, boolean nightvision, float darkLight, float partialTicks) {
        if (world == null) {
            return false;
        }
        if (lightMapPacks == null) {
            return false;
        }
        int dimensionId = WorldUtils.getDimensionId((dmu)world);
        int lightMapIndex = dimensionId - lightmapMinDimensionId;
        if (lightMapIndex < 0 || lightMapIndex >= lightMapPacks.length) {
            return false;
        }
        LightMapPack lightMapPack = lightMapPacks[lightMapIndex];
        if (lightMapPack == null) {
            return false;
        }
        return lightMapPack.updateLightmap(world, torchFlickerX, lmColors, nightvision, darkLight, partialTicks);
    }

    public static fis getWorldFogColor(fis fogVec, dmu world, bzm renderViewEntity, float partialTicks) {
        fue mc = fue.R();
        if (WorldUtils.isNether((dmu)world)) {
            return CustomColors.getFogColorNether((fis)fogVec);
        }
        if (WorldUtils.isOverworld((dmu)world)) {
            return CustomColors.getFogColor((fis)fogVec, (dlv)mc.s, (double)renderViewEntity.dC(), (double)(renderViewEntity.dE() + 1.0), (double)renderViewEntity.dI());
        }
        if (WorldUtils.isEnd((dmu)world)) {
            return CustomColors.getFogColorEnd((fis)fogVec);
        }
        return fogVec;
    }

    public static int getWorldSkyColor(int color, dmu world, bzm renderViewEntity, float partialTicks) {
        fis skyVec = ColorUtils.argbToVec3((int)color);
        fis skyVecNew = CustomColors.getWorldSkyColor((fis)skyVec, (dmu)world, (bzm)renderViewEntity, (float)partialTicks);
        int colorNew = ColorUtils.vec3ToArgb((fis)skyVecNew);
        return colorNew;
    }

    public static fis getWorldSkyColor(fis skyVec, dmu world, bzm renderViewEntity, float partialTicks) {
        fue mc = fue.R();
        if (WorldUtils.isOverworld((dmu)world) && renderViewEntity != null) {
            return CustomColors.getSkyColor((fis)skyVec, (dlv)mc.s, (double)renderViewEntity.dC(), (double)(renderViewEntity.dE() + 1.0), (double)renderViewEntity.dI());
        }
        if (WorldUtils.isEnd((dmu)world)) {
            return CustomColors.getSkyColorEnd((fis)skyVec);
        }
        return skyVec;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] readSpawnEggColors(Properties props, String fileName, String prefix, String logName) {
        void var8_10;
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set<Object> keys = props.keySet();
        int countColors = 0;
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            int id = EntityUtils.getEntityIdByName((String)name);
            try {
                if (id < 0) {
                    id = EntityUtils.getEntityIdByLocation((String)new ame(name).toString());
                }
            }
            catch (ab e) {
                Config.warn((String)("ResourceLocationException: " + e.getMessage()));
            }
            if (id < 0) {
                CustomColors.warn((String)("Invalid spawn egg name: " + string));
                continue;
            }
            int color = CustomColors.parseColor((String)value);
            if (color < 0) {
                CustomColors.warn((String)("Invalid spawn egg color: " + string + " = " + value));
                continue;
            }
            while (list.size() <= id) {
                list.add(-1);
            }
            list.set(id, color);
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        int[] colors = new int[list.size()];
        boolean bl = false;
        while (var8_10 < colors.length) {
            colors[var8_10] = (Integer)list.get((int)var8_10);
            ++var8_10;
        }
        return colors;
    }

    private static int getSpawnEggColor(dec item, dcv itemStack, int layer, int color) {
        int[] eggColors;
        if (spawnEggPrimaryColors == null && spawnEggSecondaryColors == null) {
            return color;
        }
        bzv entityType = item.a((jn.a)Config.getMinecraft().s.K_(), itemStack);
        if (entityType == null) {
            return color;
        }
        int id = mm.f.a((Object)entityType);
        if (id < 0) {
            return color;
        }
        int[] nArray = eggColors = layer == 0 ? spawnEggPrimaryColors : spawnEggSecondaryColors;
        if (eggColors == null) {
            return color;
        }
        if (id < 0 || id >= eggColors.length) {
            return color;
        }
        int eggColor = eggColors[id];
        if (eggColor < 0) {
            return color;
        }
        return eggColor;
    }

    public static int getFullColorFromItemStack(dcv itemStack, int layer, int color) {
        int colNew = CustomColors.getColorFromItemStack((dcv)itemStack, (int)layer, (int)color);
        if (colNew != color) {
            colNew = ColorUtils.combineAlphaRbg((int)color, (int)colNew);
        }
        return colNew;
    }

    private static int getColorFromItemStack(dcv itemStack, int layer, int color) {
        if (itemStack == null) {
            return color;
        }
        dcr item = itemStack.h();
        if (item == null) {
            return color;
        }
        if (item instanceof dec) {
            return CustomColors.getSpawnEggColor((dec)((dec)item), (dcv)itemStack, (int)layer, (int)color);
        }
        if (item == dcz.gE && lilyPadColor != -1) {
            return lilyPadColor;
        }
        return color;
    }

    private static int[] readDyeColors(Properties props, String fileName, String prefix, String logName) {
        dbt[] dyeValues = dbt.values();
        HashMap<String, dbt> mapDyes = new HashMap<String, dbt>();
        for (int i = 0; i < dyeValues.length; ++i) {
            dbt dye2 = dyeValues[i];
            mapDyes.put(dye2.c(), dye2);
        }
        mapDyes.put("lightBlue", dbt.d);
        mapDyes.put("silver", dbt.i);
        int[] colors = new int[dyeValues.length];
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            int argb;
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            dbt dye3 = (dbt)mapDyes.get(name);
            int color = CustomColors.parseColor((String)value);
            if (dye3 == null || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[dye3.ordinal()] = argb = baj.f((int)color);
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    private static int getDyeColors(dbt dye2, int[] dyeColors, int color) {
        if (dyeColors == null) {
            return color;
        }
        if (dye2 == null) {
            return color;
        }
        int customColor = dyeColors[dye2.ordinal()];
        if (customColor == 0) {
            return color;
        }
        return customColor;
    }

    public static int getWolfCollarColors(dbt dye2, int color) {
        return CustomColors.getDyeColors((dbt)dye2, (int[])wolfCollarColors, (int)color);
    }

    public static int getSheepColors(dbt dye2, int color) {
        return CustomColors.getDyeColors((dbt)dye2, (int[])sheepColors, (int)color);
    }

    private static int[] readTextColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[32];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            int code = Config.parseInt((String)name, (int)-1);
            int color = CustomColors.parseColor((String)value);
            if (code < 0 || code >= colors.length || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[code] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    public static int getTextColor(int index, int color) {
        if (textColors == null) {
            return color;
        }
        if (index < 0 || index >= textColors.length) {
            return color;
        }
        int customColor = textColors[index];
        if (customColor < 0) {
            return color;
        }
        return customColor;
    }

    private static int[] readMapColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[fap.am.length];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix((String)string, (String)prefix);
            int index = CustomColors.getMapColorIndex((String)name);
            int color = CustomColors.parseColor((String)value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    private static int[] readPotionColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[CustomColors.getMaxPotionId() + 1];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = string;
            int index = CustomColors.getPotionId((String)name);
            int color = CustomColors.parseColor((String)value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn((String)("Invalid color: " + string + " = " + value));
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg((String)(logName + " colors: " + countColors));
        return colors;
    }

    private static int getMaxPotionId() {
        int maxId = 0;
        Set keys = mm.d.i();
        for (ame rl : keys) {
            byo potion = PotionUtils.getPotion((ame)rl);
            int id = PotionUtils.getId((byo)potion);
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId;
    }

    private static int getPotionId(String name) {
        if (name.equals("potion.water")) {
            return 0;
        }
        name = StrUtils.replacePrefix((String)name, (String)"potion.", (String)"effect.");
        String nameMc = StrUtils.replacePrefix((String)name, (String)"effect.", (String)"effect.minecraft.");
        Set keys = mm.d.i();
        for (ame rl : keys) {
            byo potion = PotionUtils.getPotion((ame)rl);
            String potionName = potion.f();
            if (!potionName.equals(name) && !potionName.equals(nameMc)) continue;
            return PotionUtils.getId((byo)potion);
        }
        return -1;
    }

    public static int getPotionColor(byo potion, int color) {
        int potionId = 0;
        if (potion != null) {
            potionId = PotionUtils.getId((byo)potion);
        }
        return CustomColors.getPotionColor((int)potionId, (int)color);
    }

    public static int getPotionColor(int potionId, int color) {
        if (potionColors == null) {
            return color;
        }
        if (potionId < 0 || potionId >= potionColors.length) {
            return color;
        }
        int potionColor = potionColors[potionId];
        if (potionColor < 0) {
            return color;
        }
        return potionColor;
    }

    private static int getMapColorIndex(String name) {
        if (name == null) {
            return -1;
        }
        if (name.equals("air")) {
            return fap.a.al;
        }
        if (name.equals("grass")) {
            return fap.b.al;
        }
        if (name.equals("sand")) {
            return fap.c.al;
        }
        if (name.equals("cloth")) {
            return fap.d.al;
        }
        if (name.equals("tnt")) {
            return fap.e.al;
        }
        if (name.equals("ice")) {
            return fap.f.al;
        }
        if (name.equals("iron")) {
            return fap.g.al;
        }
        if (name.equals("foliage")) {
            return fap.h.al;
        }
        if (name.equals("clay")) {
            return fap.j.al;
        }
        if (name.equals("dirt")) {
            return fap.k.al;
        }
        if (name.equals("stone")) {
            return fap.l.al;
        }
        if (name.equals("water")) {
            return fap.m.al;
        }
        if (name.equals("wood")) {
            return fap.n.al;
        }
        if (name.equals("quartz")) {
            return fap.o.al;
        }
        if (name.equals("gold")) {
            return fap.E.al;
        }
        if (name.equals("diamond")) {
            return fap.F.al;
        }
        if (name.equals("lapis")) {
            return fap.G.al;
        }
        if (name.equals("emerald")) {
            return fap.H.al;
        }
        if (name.equals("podzol")) {
            return fap.I.al;
        }
        if (name.equals("netherrack")) {
            return fap.J.al;
        }
        if (name.equals("snow") || name.equals("white")) {
            return fap.i.al;
        }
        if (name.equals("adobe") || name.equals("orange")) {
            return fap.p.al;
        }
        if (name.equals("magenta")) {
            return fap.q.al;
        }
        if (name.equals("light_blue") || name.equals("lightBlue")) {
            return fap.r.al;
        }
        if (name.equals("yellow")) {
            return fap.s.al;
        }
        if (name.equals("lime")) {
            return fap.t.al;
        }
        if (name.equals("pink")) {
            return fap.u.al;
        }
        if (name.equals("gray")) {
            return fap.v.al;
        }
        if (name.equals("silver") || name.equals("light_gray")) {
            return fap.w.al;
        }
        if (name.equals("cyan")) {
            return fap.x.al;
        }
        if (name.equals("purple")) {
            return fap.y.al;
        }
        if (name.equals("blue")) {
            return fap.z.al;
        }
        if (name.equals("brown")) {
            return fap.A.al;
        }
        if (name.equals("green")) {
            return fap.B.al;
        }
        if (name.equals("red")) {
            return fap.C.al;
        }
        if (name.equals("black")) {
            return fap.D.al;
        }
        if (name.equals("white_terracotta")) {
            return fap.K.al;
        }
        if (name.equals("orange_terracotta")) {
            return fap.L.al;
        }
        if (name.equals("magenta_terracotta")) {
            return fap.M.al;
        }
        if (name.equals("light_blue_terracotta")) {
            return fap.N.al;
        }
        if (name.equals("yellow_terracotta")) {
            return fap.O.al;
        }
        if (name.equals("lime_terracotta")) {
            return fap.P.al;
        }
        if (name.equals("pink_terracotta")) {
            return fap.Q.al;
        }
        if (name.equals("gray_terracotta")) {
            return fap.R.al;
        }
        if (name.equals("light_gray_terracotta")) {
            return fap.S.al;
        }
        if (name.equals("cyan_terracotta")) {
            return fap.T.al;
        }
        if (name.equals("purple_terracotta")) {
            return fap.U.al;
        }
        if (name.equals("blue_terracotta")) {
            return fap.V.al;
        }
        if (name.equals("brown_terracotta")) {
            return fap.W.al;
        }
        if (name.equals("green_terracotta")) {
            return fap.X.al;
        }
        if (name.equals("red_terracotta")) {
            return fap.Y.al;
        }
        if (name.equals("black_terracotta")) {
            return fap.Z.al;
        }
        if (name.equals("crimson_nylium")) {
            return fap.aa.al;
        }
        if (name.equals("crimson_stem")) {
            return fap.ab.al;
        }
        if (name.equals("crimson_hyphae")) {
            return fap.ac.al;
        }
        if (name.equals("warped_nylium")) {
            return fap.ad.al;
        }
        if (name.equals("warped_stem")) {
            return fap.ae.al;
        }
        if (name.equals("warped_hyphae")) {
            return fap.af.al;
        }
        if (name.equals("warped_wart_block")) {
            return fap.ag.al;
        }
        if (name.equals("deepslate")) {
            return fap.ah.al;
        }
        if (name.equals("raw_iron")) {
            return fap.ai.al;
        }
        if (name.equals("glow_lichen")) {
            return fap.aj.al;
        }
        return -1;
    }

    private static int[] getMapColors() {
        fap[] mapColors = fap.am;
        int[] colors = new int[mapColors.length];
        Arrays.fill(colors, -1);
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            fap mapColor = mapColors[i];
            if (mapColor == null) continue;
            colors[i] = mapColor.ak;
        }
        return colors;
    }

    private static void setMapColors(int[] colors) {
        if (colors == null) {
            return;
        }
        fap[] mapColors = fap.am;
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            int color;
            fap mapColor = mapColors[i];
            if (mapColor == null || (color = colors[i]) < 0 || mapColor.ak == color) continue;
            mapColor.ak = color;
        }
    }

    private static int[] getDyeColors() {
        dbt[] dyeColors = dbt.values();
        int[] colors = new int[dyeColors.length];
        for (int i = 0; i < dyeColors.length && i < colors.length; ++i) {
            dbt dyeColor = dyeColors[i];
            if (dyeColor == null) continue;
            colors[i] = dyeColor.d();
        }
        return colors;
    }

    private static void setDyeColors(int[] colors) {
        if (colors == null) {
            return;
        }
        dbt[] dyeColors = dbt.values();
        for (int i = 0; i < dyeColors.length && i < colors.length; ++i) {
            int color;
            dbt dyeColor = dyeColors[i];
            if (dyeColor == null || (color = colors[i]) == 0 || dyeColor.d() == color) continue;
            dyeColor.setTextureDiffuseColor(color);
        }
    }

    private static void dbg(String str) {
        Config.dbg((String)("CustomColors: " + str));
    }

    private static void warn(String str) {
        Config.warn((String)("CustomColors: " + str));
    }

    public static int getExpBarTextColor(int color) {
        if (expBarTextColor < 0) {
            return color;
        }
        return expBarTextColor;
    }

    public static int getBossTextColor(int color) {
        if (bossTextColor < 0) {
            return color;
        }
        return bossTextColor;
    }

    public static int getSignTextColor(int color) {
        if (color != 0) {
            return color;
        }
        if (signTextColor < 0) {
            return color;
        }
        return signTextColor;
    }
}

