/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.CustomGuis;
import net.optifine.RandomEntityRule;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<ame, ame> textureLocations = null;
    private NbtTagValue nbtName = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private dbt[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final dbt[] COLORS_INVALID = new dbt[0];
    private static final ame ANVIL_GUI_TEXTURE = new ame("textures/gui/container/anvil.png");
    private static final ame BEACON_GUI_TEXTURE = new ame("textures/gui/container/beacon.png");
    private static final ame BREWING_STAND_GUI_TEXTURE = new ame("textures/gui/container/brewing_stand.png");
    private static final ame CHEST_GUI_TEXTURE = new ame("textures/gui/container/generic_54.png");
    private static final ame CRAFTING_TABLE_GUI_TEXTURE = new ame("textures/gui/container/crafting_table.png");
    private static final ame HORSE_GUI_TEXTURE = new ame("textures/gui/container/horse.png");
    private static final ame DISPENSER_GUI_TEXTURE = new ame("textures/gui/container/dispenser.png");
    private static final ame ENCHANTMENT_TABLE_GUI_TEXTURE = new ame("textures/gui/container/enchanting_table.png");
    private static final ame FURNACE_GUI_TEXTURE = new ame("textures/gui/container/furnace.png");
    private static final ame HOPPER_GUI_TEXTURE = new ame("textures/gui/container/hopper.png");
    private static final ame INVENTORY_GUI_TEXTURE = new ame("textures/gui/container/inventory.png");
    private static final ame SHULKER_BOX_GUI_TEXTURE = new ame("textures/gui/container/shulker_box.png");
    private static final ame VILLAGER_GUI_TEXTURE = new ame("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), (Enum[])EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations((Properties)props, (String)"texture", (EnumContainer)this.container, (String)"textures/gui/", (String)this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        EnumVariant[] vars = CustomGuiProperties.getContainerVariants((EnumContainer)this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), (Enum[])vars, "variants", (Enum[])VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors((String)props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static dbt[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        dbt[] cols = new dbt[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            dbt col = CustomGuiProperties.parseEnumDyeColor((String)token);
            if (col == null) {
                CustomGuiProperties.warn((String)("Invalid color: " + token));
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static dbt parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        dbt[] colors = dbt.values();
        for (int i = 0; i < colors.length; ++i) {
            dbt enumDyeColor = colors[i];
            if (enumDyeColor.c().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static ame parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        Object tex = TextureUtils.fixResourcePath((String)(str = str.trim()), (String)basePath);
        if (!((String)tex).endsWith(".png")) {
            tex = (String)tex + ".png";
        }
        return new ame(basePath + "/" + (String)tex);
    }

    private static Map<ame, ame> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<ame, ame> map = new HashMap<ame, ame>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            ame locKey = CustomGuiProperties.getGuiTextureLocation((EnumContainer)container);
            ame locVal = CustomGuiProperties.parseTextureLocation((String)propVal, (String)basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix((String)pathRel, (String)"/", (String)".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            ame locKey = new ame(path);
            ame locVal = CustomGuiProperties.parseTextureLocation((String)val, (String)basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static ame getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (container.ordinal()) {
            case 0: {
                return ANVIL_GUI_TEXTURE;
            }
            case 1: {
                return BEACON_GUI_TEXTURE;
            }
            case 2: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case 3: {
                return CHEST_GUI_TEXTURE;
            }
            case 4: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case 12: {
                return null;
            }
            case 5: {
                return DISPENSER_GUI_TEXTURE;
            }
            case 6: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case 7: {
                return FURNACE_GUI_TEXTURE;
            }
            case 8: {
                return HOPPER_GUI_TEXTURE;
            }
            case 9: {
                return HORSE_GUI_TEXTURE;
            }
            case 13: {
                return INVENTORY_GUI_TEXTURE;
            }
            case 11: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case 10: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn((String)("No name found: " + path));
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn((String)("No base path found: " + path));
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn((String)("No container found: " + path));
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn((String)("No texture found: " + path));
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid professions or careers: " + path));
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid variants: " + path));
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid colors: " + path));
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn((String)("[CustomGuis] " + str));
    }

    private boolean matchesGeneral(EnumContainer ec, jb pos, dmx blockAccess) {
        dnx biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome((dnx)(biome = (dnx)blockAccess.v(pos).a()), (BiomeId[])this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.v());
    }

    public boolean matchesPos(EnumContainer ec, jb pos, dmx blockAccess, get screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName((get)screen))) {
            return false;
        }
        switch (ec.ordinal()) {
            case 1: {
                return this.matchesBeacon(pos, (dlv)blockAccess);
            }
            case 3: {
                return this.matchesChest(pos, (dlv)blockAccess);
            }
            case 5: {
                return this.matchesDispenser(pos, (dlv)blockAccess);
            }
            case 11: {
                return this.matchesShulker(pos, (dlv)blockAccess);
            }
        }
        return true;
    }

    public static String getName(get screen) {
        xo itc = screen.o();
        if (itc == null) {
            return null;
        }
        return itc.getString();
    }

    private boolean matchesBeacon(jb pos, dlv blockAccess) {
        eaz te = blockAccess.c_(pos);
        if (!(te instanceof eau)) {
            return false;
        }
        eau teb = (eau)te;
        if (this.levels != null) {
            if (!Reflector.TileEntityBeacon_levels.exists()) {
                return false;
            }
            int l = Reflector.getFieldValueInt((Object)teb, (ReflectorField)Reflector.TileEntityBeacon_levels, (int)-1);
            if (!this.levels.isInRange(l)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(jb pos, dlv blockAccess) {
        eaz te = blockAccess.c_(pos);
        if (te instanceof ebh) {
            ebh tec = (ebh)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof ebx) {
            ebx teec = (ebx)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(ebh tec, jb pos, dlv blockAccess) {
        eeb blockState = blockAccess.a_(pos);
        eet chestType = blockState.b((efe)drd.d) ? (eet)blockState.c((efe)drd.d) : eet.a;
        boolean isLarge = chestType != eet.a;
        boolean isTrapped = tec instanceof ecy;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(ebx teec, jb pos, dlv blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(jb pos, dlv blockAccess) {
        EnumVariant var;
        eaz te = blockAccess.c_(pos);
        if (!(te instanceof ebu)) {
            return false;
        }
        ebu ted = (ebu)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(ebu ted) {
        if (ted instanceof ebv) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(jb pos, dlv blockAccess) {
        dbt col;
        eaz te = blockAccess.c_(pos);
        if (!(te instanceof ecm)) {
            return false;
        }
        ecm tesb = (ecm)te;
        return this.colors == null || Config.equalsOne((Object)(col = tesb.u()), (Object[])this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, bzm entity, dmx blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.dx(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.cM())) {
            return false;
        }
        switch (ec.ordinal()) {
            case 10: {
                return this.matchesVillager(entity, (dlv)blockAccess);
            }
            case 9: {
                return this.matchesHorse(entity, (dlv)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(bzm entity, dlv blockAccess) {
        int level;
        cug vd;
        cui vp;
        if (!(entity instanceof cuf)) {
            return false;
        }
        cuf entityVillager = (cuf)entity;
        return this.professions == null || MatchProfession.matchesOne((cui)(vp = (cui)(vd = entityVillager.gR()).b().a()), (int)(level = vd.c()), (MatchProfession[])this.professions);
    }

    private boolean matchesHorse(bzm entity, dlv blockAccess) {
        cot el;
        dbt col;
        EnumVariant var;
        if (!(entity instanceof coq)) {
            return false;
        }
        coq ah = (coq)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof cot) || Config.equalsOne((Object)(col = RandomEntityRule.getLlamaColor((cot)(el = (cot)ah))), (Object[])this.colors);
    }

    private EnumVariant getHorseVariant(coq entity) {
        if (entity instanceof cos) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof cor) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof cov) {
            return EnumVariant.MULE;
        }
        if (entity instanceof cot) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public ame getTextureLocation(ame loc) {
        ame locNew = (ame)this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + String.valueOf(this.container) + ", textures: " + String.valueOf(this.textureLocations);
    }
}

