/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private bzm entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<jb> setLitChunkPos = new HashSet();

    public DynamicLight(bzm entity) {
        this.entity = entity;
        this.offsetY = entity.cW();
    }

    public void update(gxh renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dC() - 0.5;
        double posY = this.entity.dE() - 0.5 + this.offsetY;
        double posZ = this.entity.dI() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((bzm)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            jh dirX = (bcb.a((double)posX) & 0xF) >= 8 ? jh.f : jh.e;
            jh dirY = (bcb.a((double)posY) & 0xF) >= 8 ? jh.b : jh.a;
            jh dirZ = (bcb.a((double)posZ) & 0xF) >= 8 ? jh.d : jh.c;
            long chunkPos = this.getChunkPos(posX, posY, posZ);
            hbl.a chunk = renderGlobal.getRenderChunk(chunkPos);
            long chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            hbl.a chunkX = renderGlobal.getRenderChunk(chunkPosX);
            long chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            hbl.a chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            long chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            hbl.a chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            long chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            hbl.a chunkY = renderGlobal.getRenderChunk(chunkPosY);
            long chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            hbl.a chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            long chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            hbl.a chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            long chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            hbl.a chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private long getChunkPos(double x, double y, double z2) {
        int cx = ke.a((int)bcb.a((double)x));
        int cy = ke.a((int)bcb.a((double)y));
        int cz = ke.a((int)bcb.a((double)z2));
        return ke.b((int)cx, (int)cy, (int)cz);
    }

    private long getChunkPos(hbl.a renderChunk, long pos, jh facing) {
        int x = ke.b((long)pos);
        int y = ke.c((long)pos);
        int z2 = ke.d((long)pos);
        return ke.b((int)(x += facing.j()), (int)(y += facing.k()), (int)(z2 += facing.l()));
    }

    private void updateChunkLight(hbl.a renderChunk, Set<jb> setPrevPos, Set<jb> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        hbk compiledChunk = renderChunk.c();
        if (compiledChunk != null && !compiledChunk.isEmpty()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        jb pos = renderChunk.getPosition().j();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(gxh renderGlobal) {
        for (jb posOld : this.setLitChunkPos) {
            hbl.a chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public bzm getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + String.valueOf(this.entity) + ", offsetY: " + this.offsetY;
    }
}

