/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.optifine.BlockPosM;
import net.optifine.render.LightCacheOF;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements dlv {
    private final hbg chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXZ;
    private int[] combinedLights;
    private eeb[] blockStates;
    private dnx[] biomes;
    private final int arraySize;
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(eeb.class, 16);
    private static final ArrayCache cacheBiomes = new ArrayCache(dnx.class, 16);

    public ChunkCacheOF(hbg chunkCache, ke sectionPos) {
        this.chunkCache = chunkCache;
        int minChunkX = sectionPos.u() - 1;
        int minChunkY = sectionPos.v() - 1;
        int minChunkZ = sectionPos.w() - 1;
        int maxChunkX = sectionPos.u() + 1;
        int maxChunkY = sectionPos.v() + 1;
        int maxChunkZ = sectionPos.w() + 1;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXZ = this.sizeX * this.sizeZ;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    public int getPositionIndex(jb pos) {
        int dx = pos.u() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.v() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.w() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dy * this.sizeXZ + dz * this.sizeX + dx;
    }

    public int a(dnd type, jb pos) {
        return this.chunkCache.a(type, pos);
    }

    public eeb a_(jb pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.a_(pos);
        }
        eeb iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.a_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        if (this.blockStates == null) {
            this.blockStates = (eeb[])cacheBlockStates.allocate(this.arraySize);
        }
        if (this.biomes == null) {
            this.biomes = (dnx[])cacheBiomes.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        Arrays.fill(this.blockStates, null);
        Arrays.fill(this.biomes, null);
        this.loadBlockStates();
    }

    private void loadBlockStates() {
        if (this.sizeX != 48 || this.sizeY != 48 || this.sizeZ != 48) {
            return;
        }
        egi chunk = this.chunkCache.getLevelChunk(ke.a((int)this.posX) + 1, ke.a((int)this.posY) + 1, ke.a((int)this.posZ) + 1);
        BlockPosM pos = new BlockPosM();
        for (int y = 16; y < 32; ++y) {
            int dy = y * this.sizeXZ;
            for (int z2 = 16; z2 < 32; ++z2) {
                int dz = z2 * this.sizeX;
                for (int x = 16; x < 32; ++x) {
                    eeb bs;
                    pos.setXyz(this.posX + x, this.posY + y, this.posZ + z2);
                    int index = dy + dz + x;
                    this.blockStates[index] = bs = chunk.a_((jb)pos);
                }
            }
        }
    }

    public void renderFinish() {
        cacheCombinedLights.free((Object)this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free((Object)this.blockStates);
        this.blockStates = null;
        cacheBiomes.free((Object)this.biomes);
        this.biomes = null;
    }

    public int getCombinedLight(eeb blockStateIn, dlv worldIn, jb blockPosIn) {
        if (blockStateIn.hasEmissive()) {
            return LightCacheOF.getPackedLightRaw((dlv)worldIn, (eeb)blockStateIn, (jb)blockPosIn);
        }
        int index = this.getPositionIndex(blockPosIn);
        if (index < 0 || index >= this.combinedLights.length || this.combinedLights == null) {
            return LightCacheOF.getPackedLightRaw((dlv)worldIn, (eeb)blockStateIn, (jb)blockPosIn);
        }
        int light = this.combinedLights[index];
        if (light == -1) {
            this.combinedLights[index] = light = LightCacheOF.getPackedLightRaw((dlv)worldIn, (eeb)blockStateIn, (jb)blockPosIn);
        }
        return light;
    }

    public dnx getBiome(jb pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.biomes == null) {
            return this.chunkCache.getBiome(pos);
        }
        dnx biome = this.biomes[index];
        if (biome == null) {
            this.biomes[index] = biome = this.chunkCache.getBiome(pos);
        }
        return biome;
    }

    public eaz c_(jb pos) {
        return this.chunkCache.c_(pos);
    }

    public boolean h(jb pos) {
        return this.chunkCache.h(pos);
    }

    public fal b_(jb pos) {
        return this.a_(pos).y();
    }

    public int a(jb blockPosIn, dme colorResolverIn) {
        return this.chunkCache.a(blockPosIn, colorResolverIn);
    }

    public faa C_() {
        return this.chunkCache.C_();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }

    public float a(jh directionIn, boolean shadeIn) {
        return this.chunkCache.a(directionIn, shadeIn);
    }

    public int M_() {
        return this.chunkCache.M_();
    }

    public int L_() {
        return this.chunkCache.L_();
    }
}

