/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.CoreLib;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class BaseBlockEntity
extends BlockEntity {
    private boolean dataChanged = true;

    public BaseBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void dataChanged() {
        this.dataChanged = true;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 6);
    }

    protected abstract void writeData(ValueOutput var1);

    protected void writeClientData(ValueOutput output) {
        this.writeData(output);
    }

    protected void writeItemStackData(ValueOutput output) {
        this.writeData(output);
    }

    protected abstract void readData(ValueInput var1);

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.writeData(output.child("data"));
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.readData(valueInput.childOrEmpty("data"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)new ProblemReporter.ScopedCollector(this.problemPath(), CoreLib.LOGGER), (HolderLookup.Provider)provider);
        super.saveAdditional((ValueOutput)output);
        this.writeClientData(output.child("data"));
        return output.buildResult();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.dataChanged) {
            this.dataChanged = false;
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (entity, registryAccess) -> {
                TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)new ProblemReporter.ScopedCollector(this.problemPath(), CoreLib.LOGGER), (HolderLookup.Provider)registryAccess);
                ((BaseBlockEntity)((Object)entity)).writeClientData(output.child("data"));
                return output.buildResult();
            });
        }
        return null;
    }
}

