/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.tag;

import com.supermartijn642.core.data.tag.CustomTagEntry;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;

public class TagEntryAdapter
extends TagEntry {
    final ResourceLocation identifier;
    final CustomTagEntry customEntry;
    private Registry<?> registry;

    TagEntryAdapter(ResourceLocation identifier, CustomTagEntry customEntry) {
        super(ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"dummy"), false, false);
        this.identifier = identifier;
        this.customEntry = customEntry;
    }

    public void setRegistry(Registry<?> registry) {
        this.registry = registry;
    }

    public <T> boolean build(final TagEntry.Lookup<T> lookup, Consumer<T> entryConsumer) {
        CustomTagEntry.TagEntryResolutionContext context = new CustomTagEntry.TagEntryResolutionContext<T>(){

            @Override
            public T getElement(ResourceLocation identifier) {
                return lookup.element(identifier, false);
            }

            @Override
            public Collection<T> getTag(ResourceLocation identifier) {
                return lookup.tag(identifier);
            }

            @Override
            public Collection<T> getAllElements() {
                return TagEntryAdapter.this.registry.stream().collect(Collectors.toList());
            }

            @Override
            public Set<ResourceLocation> getAllIdentifiers() {
                return TagEntryAdapter.this.registry.keySet();
            }
        };
        Collection<T> entries = this.customEntry.resolve(context);
        if (entries != null) {
            entries.forEach(entryConsumer);
        }
        return true;
    }

    public void visitOptionalDependencies(Consumer<ResourceLocation> consumer) {
        Collection<ResourceLocation> dependencies = this.customEntry.getTagDependencies();
        if (dependencies != null) {
            dependencies.forEach(consumer);
        }
    }

    public String toString() {
        return "'" + String.valueOf(this.identifier) + "'{" + String.valueOf(this.customEntry) + "}";
    }
}

