/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.Registries;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class BaseItem
extends Item {
    private final ItemProperties properties;
    private boolean resolvedRegistryDependencies;

    public BaseItem(Item.Properties properties) {
        super(BaseItem.removeDescriptionAndModelFromProperties(properties));
        this.properties = null;
    }

    public BaseItem(ItemProperties properties) {
        super(BaseItem.removeDescriptionAndModelFromProperties(properties.toUnderlying()));
        this.properties = properties;
    }

    private static Item.Properties removeDescriptionAndModelFromProperties(Item.Properties properties) {
        return properties.overrideDescription("").setId(ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"dummy")));
    }

    @ApiStatus.Internal
    public void resolveRegistryDependencies() {
        if (!this.resolvedRegistryDependencies) {
            ResourceLocation identifier = Registries.ITEMS.getIdentifier(this);
            this.descriptionId = identifier.getNamespace() + ".item." + identifier.getPath();
            this.components = DataComponentMap.builder().addAll(this.components).set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.descriptionId)).set(DataComponents.ITEM_MODEL, (Object)identifier).build();
            this.resolvedRegistryDependencies = true;
        }
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
    }

    public ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        return ItemUseResult.fromUnderlying(super.use(level, player, hand));
    }

    public InteractionFeedback interactWithBlockFirst(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        return InteractionFeedback.PASS;
    }

    public InteractionFeedback interactWithBlock(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        return InteractionFeedback.PASS;
    }

    public InteractionFeedback interactWithEntity(ItemStack stack, LivingEntity target, Player player, InteractionHand hand) {
        return InteractionFeedback.PASS;
    }

    public void inventoryUpdate(ItemStack stack, Level level, Entity entity, @Nullable EquipmentSlot slot) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> information, TooltipFlag flag) {
        this.appendItemInformation(stack, information, flag.isAdvanced());
        super.appendHoverText(stack, context, display, information, flag);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        return this.interact(player.getItemInHand(hand), player, hand, level).toUnderlying(level.isClientSide);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return this.interactWithEntity((ItemStack)stack, (LivingEntity)target, (Player)player, (InteractionHand)hand).interactionResult;
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.interactWithBlock((ItemStack)context.getItemInHand(), (Player)context.getPlayer(), (InteractionHand)context.getHand(), (Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (Vec3)context.getClickLocation()).interactionResult;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.interactWithBlockFirst((ItemStack)stack, (Player)context.getPlayer(), (InteractionHand)context.getHand(), (Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (Vec3)context.getClickLocation()).interactionResult;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        this.inventoryUpdate(stack, (Level)level, entity, slot);
    }

    public String getDescriptionId() {
        this.resolveRegistryDependencies();
        return super.getDescriptionId();
    }

    public DataComponentMap components() {
        this.resolveRegistryDependencies();
        return super.components();
    }

    public Component getName(ItemStack itemStack) {
        this.resolveRegistryDependencies();
        return super.getName(itemStack);
    }

    public boolean isInCreativeGroup(CreativeModeTab tab) {
        return this.properties != null && (this.properties.groups.contains(tab) || !this.properties.groups.isEmpty() && tab == CreativeItemGroup.getSearch());
    }

    public static class ItemUseResult {
        private final InteractionResult result;

        public static ItemUseResult pass(ItemStack stack) {
            return new ItemUseResult((InteractionResult)InteractionResult.PASS);
        }

        public static ItemUseResult consume(ItemStack stack) {
            return new ItemUseResult((InteractionResult)InteractionResult.CONSUME.heldItemTransformedTo(stack));
        }

        public static ItemUseResult success(ItemStack stack) {
            return new ItemUseResult((InteractionResult)InteractionResult.SUCCESS.heldItemTransformedTo(stack));
        }

        public static ItemUseResult fail(ItemStack stack) {
            return new ItemUseResult((InteractionResult)InteractionResult.FAIL);
        }

        @Deprecated
        public static ItemUseResult fromUnderlying(InteractionResult underlying) {
            return new ItemUseResult(underlying);
        }

        private ItemUseResult(InteractionResult result) {
            this.result = result;
        }

        @Deprecated
        public InteractionResult toUnderlying(boolean isClientSide) {
            if (!isClientSide && this.result instanceof InteractionResult.Success && ((InteractionResult.Success)this.result).swingSource() == InteractionResult.SwingSource.CLIENT) {
                return InteractionResult.SUCCESS_SERVER.heldItemTransformedTo(((InteractionResult.Success)this.result).itemContext().heldItemTransformedTo());
            }
            return this.result;
        }
    }

    public static enum InteractionFeedback {
        PASS((InteractionResult)InteractionResult.PASS),
        CONSUME((InteractionResult)InteractionResult.CONSUME),
        SUCCESS((InteractionResult)InteractionResult.SUCCESS);

        private final InteractionResult interactionResult;

        private InteractionFeedback(InteractionResult interactionResult) {
            this.interactionResult = interactionResult;
        }

        @Deprecated
        public static InteractionFeedback fromUnderlying(InteractionResult interactionResult) {
            if (interactionResult instanceof InteractionResult.Success) {
                if (((InteractionResult.Success)interactionResult).swingSource() == InteractionResult.SwingSource.NONE) {
                    return CONSUME;
                }
                return SUCCESS;
            }
            if (interactionResult instanceof InteractionResult.Pass) {
                return PASS;
            }
            return CONSUME;
        }

        @Deprecated
        public InteractionResult getUnderlying() {
            return this.interactionResult;
        }
    }
}

