/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.item.ItemRarity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;

public class ItemProperties {
    private int maxStackSize = 64;
    private int durability;
    private Item craftingRemainingItem;
    private Rarity rarity = Rarity.COMMON;
    private FoodProperties foodProperties;
    private boolean isFireResistant;
    final Set<CreativeModeTab> groups = new HashSet<CreativeModeTab>();
    private Map<DataComponentType<Object>, Object> components;

    public static ItemProperties create() {
        return new ItemProperties();
    }

    private ItemProperties() {
    }

    public ItemProperties maxStackSize(int maxStackSize) {
        if (maxStackSize < 1) {
            throw new IllegalArgumentException("Maximum stack size must be greater than zero!");
        }
        if (maxStackSize > 1 && this.durability != 0) {
            throw new RuntimeException("An item cannot have durability and be stackable!");
        }
        this.maxStackSize = maxStackSize;
        return this;
    }

    public ItemProperties durability(int durability) {
        if (this.maxStackSize != 64 && this.maxStackSize > 1) {
            throw new RuntimeException("An item cannot have durability and be stackable!");
        }
        this.durability = durability;
        this.maxStackSize = 1;
        return this;
    }

    public ItemProperties craftRemainder(Item item) {
        this.craftingRemainingItem = item;
        return this;
    }

    public ItemProperties group(CreativeModeTab group) {
        this.groups.add(group);
        return this;
    }

    public ItemProperties rarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public ItemProperties rarity(ItemRarity rarity) {
        this.rarity = rarity.getUnderlying();
        return this;
    }

    public ItemProperties food(FoodProperties foodProperties) {
        this.foodProperties = foodProperties;
        return this;
    }

    public ItemProperties fireResistant() {
        this.isFireResistant = true;
        return this;
    }

    public <T> ItemProperties component(DataComponentType<T> type, T value) {
        if (this.components == null) {
            this.components = new HashMap<DataComponentType<Object>, Object>();
        }
        this.components.put(type, value);
        return this;
    }

    @Deprecated
    public Item.Properties toUnderlying() {
        Item.Properties properties = new Item.Properties();
        properties.stacksTo(this.maxStackSize);
        if (this.durability != 0) {
            properties.durability(this.durability);
        }
        properties.craftRemainder(this.craftingRemainingItem);
        properties.rarity(this.rarity);
        if (this.foodProperties != null) {
            properties.food(this.foodProperties);
        }
        if (this.isFireResistant) {
            properties.fireResistant();
        }
        if (this.components != null) {
            this.components.forEach((arg_0, arg_1) -> ((Item.Properties)properties).component(arg_0, arg_1));
        }
        return properties;
    }
}

