/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.data.tag.CustomTagEntrySerializer;
import com.supermartijn642.core.util.MappedSetView;
import com.supermartijn642.core.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public final class Registries {
    static final Map<ResourceLocation, Registry<?>> IDENTIFIER_TO_REGISTRY = new HashMap();
    static final Map<net.minecraft.core.Registry<?>, Registry<?>> VANILLA_REGISTRY_MAP = new HashMap();
    static final Map<ResourceLocation, Registry<?>> FORGE_REGISTRY_MAP = new HashMap();
    static final Map<Registry<?>, List<Registry<?>>> REGISTRATION_ORDER_MAP = new HashMap();
    public static final Registry<Block> BLOCKS = Registries.forge(BuiltInRegistries.BLOCK, ForgeRegistries.BLOCKS, Block.class);
    public static final Registry<Fluid> FLUIDS = Registries.forge(BuiltInRegistries.FLUID, ForgeRegistries.FLUIDS, Fluid.class);
    public static final Registry<Item> ITEMS = Registries.forge(BuiltInRegistries.ITEM, ForgeRegistries.ITEMS, Item.class);
    public static final Registry<MobEffect> MOB_EFFECTS = Registries.forge(BuiltInRegistries.MOB_EFFECT, ForgeRegistries.MOB_EFFECTS, MobEffect.class);
    public static final Registry<SoundEvent> SOUND_EVENTS = Registries.forge(BuiltInRegistries.SOUND_EVENT, ForgeRegistries.SOUND_EVENTS, SoundEvent.class);
    public static final Registry<Potion> POTIONS = Registries.forge(BuiltInRegistries.POTION, ForgeRegistries.POTIONS, Potion.class);
    public static final Registry<EntityType<?>> ENTITY_TYPES = Registries.forge(BuiltInRegistries.ENTITY_TYPE, ForgeRegistries.ENTITY_TYPES, EntityType.class);
    public static final Registry<BlockEntityType<?>> BLOCK_ENTITY_TYPES = Registries.forge(BuiltInRegistries.BLOCK_ENTITY_TYPE, ForgeRegistries.BLOCK_ENTITY_TYPES, BlockEntityType.class);
    public static final Registry<ParticleType<?>> PARTICLE_TYPES = Registries.forge(BuiltInRegistries.PARTICLE_TYPE, ForgeRegistries.PARTICLE_TYPES, ParticleType.class);
    public static final Registry<MenuType<?>> MENU_TYPES = Registries.forge(BuiltInRegistries.MENU, ForgeRegistries.MENU_TYPES, MenuType.class);
    public static final Registry<RecipeType<?>> RECIPE_TYPES = Registries.forge(BuiltInRegistries.RECIPE_TYPE, ForgeRegistries.RECIPE_TYPES, RecipeType.class);
    public static final Registry<RecipeSerializer<?>> RECIPE_SERIALIZERS = Registries.forge(BuiltInRegistries.RECIPE_SERIALIZER, ForgeRegistries.RECIPE_SERIALIZERS, RecipeSerializer.class);
    public static final Registry<Attribute> ATTRIBUTES = Registries.forge(BuiltInRegistries.ATTRIBUTE, ForgeRegistries.ATTRIBUTES, Attribute.class);
    public static final Registry<StatType<?>> STAT_TYPES = Registries.forge(BuiltInRegistries.STAT_TYPE, ForgeRegistries.STAT_TYPES, StatType.class);
    public static final Registry<MapCodec<? extends ICondition>> RECIPE_CONDITION_SERIALIZERS = Registries.forge(ForgeRegistries.CONDITION_SERIALIZERS, ForgeRegistries.Keys.CONDITION_SERIALIZERS.location(), MapCodec.class);
    public static final Registry<CustomTagEntrySerializer<?>> CUSTOM_TAG_ENTRY_SERIALIZERS = new MapBackedRegistry<CustomTagEntrySerializer>(ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"custom_tag_entries"), CustomTagEntrySerializer.class);
    public static final Registry<DataComponentType<?>> DATA_COMPONENT_TYPES = Registries.vanilla(BuiltInRegistries.DATA_COMPONENT_TYPE, DataComponentType.class);
    public static final Registry<CriterionTrigger<?>> TRIGGER_TYPES = Registries.vanilla(BuiltInRegistries.TRIGGER_TYPES, CriterionTrigger.class);

    private static void addRegistry(Registry<?> registry) {
        if (IDENTIFIER_TO_REGISTRY.containsKey(registry.getRegistryIdentifier())) {
            throw new RuntimeException("Duplicate registry registration for identifier '" + String.valueOf(registry.getRegistryIdentifier()) + "'!");
        }
        if (registry.hasVanillaRegistry() && VANILLA_REGISTRY_MAP.containsKey(registry.getVanillaRegistry())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + String.valueOf(registry.getValueClass()) + "'!");
        }
        if (registry.hasForgeRegistry() && FORGE_REGISTRY_MAP.containsKey(registry.getRegistryIdentifier())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + String.valueOf(registry.getValueClass()) + "'!");
        }
        IDENTIFIER_TO_REGISTRY.put(registry.getRegistryIdentifier(), registry);
        if (registry.hasVanillaRegistry()) {
            VANILLA_REGISTRY_MAP.put(registry.getVanillaRegistry(), registry);
        }
        if (registry.hasForgeRegistry()) {
            FORGE_REGISTRY_MAP.put(registry.getRegistryIdentifier(), registry);
        }
    }

    @Deprecated
    public static <T> Registry<T> fromUnderlying(net.minecraft.core.Registry<T> registry) {
        return VANILLA_REGISTRY_MAP.get(registry);
    }

    @Deprecated
    public static <T> Registry<T> fromUnderlying(IForgeRegistry<T> registry) {
        Registry<?> r = FORGE_REGISTRY_MAP.get(registry.getRegistryName());
        if (r == null) {
            r = IDENTIFIER_TO_REGISTRY.get(registry.getRegistryName());
        }
        return r;
    }

    public static Registry<?> getRegistry(ResourceLocation identifier) {
        return IDENTIFIER_TO_REGISTRY.get(identifier);
    }

    private static <T> Registry<T> vanilla(net.minecraft.core.Registry<T> registry, Class<? super T> valueClass) {
        return new VanillaRegistryWrapper<T>(registry, valueClass);
    }

    private static <T> Registry<T> forge(net.minecraft.core.Registry<T> registry, IForgeRegistry<T> forgeRegistry, Class<? super T> valueClass) {
        return new ForgeRegistryWrapper<T>(registry, forgeRegistry, valueClass);
    }

    private static <T> Registry<T> forge(Supplier<IForgeRegistry<T>> forgeRegistry, ResourceLocation identifier, Class<? super T> valueClass) {
        return new ForgeRegistryWrapper<T>(forgeRegistry, identifier, valueClass);
    }

    static {
        REGISTRATION_ORDER_MAP.put(RECIPE_SERIALIZERS, Lists.newArrayList((Object[])new Registry[]{CUSTOM_TAG_ENTRY_SERIALIZERS}));
    }

    public static interface Registry<T> {
        public ResourceLocation getRegistryIdentifier();

        @Nullable
        public net.minecraft.core.Registry<T> getVanillaRegistry();

        public boolean hasVanillaRegistry();

        @Nullable
        public IForgeRegistry<T> getForgeRegistry();

        public boolean hasForgeRegistry();

        public void register(ResourceLocation var1, T var2);

        public ResourceLocation getIdentifier(T var1);

        public boolean hasIdentifier(ResourceLocation var1);

        public T getValue(ResourceLocation var1);

        public Set<ResourceLocation> getIdentifiers();

        public Collection<T> getValues();

        public Set<Pair<ResourceLocation, T>> getEntries();

        public Class<T> getValueClass();
    }

    private static class VanillaRegistryWrapper<T>
    implements Registry<T> {
        private final net.minecraft.core.Registry<T> registry;
        private final ResourceLocation identifier;
        private final Class<T> valueClass;

        private VanillaRegistryWrapper(net.minecraft.core.Registry<T> registry, Class<? super T> valueClass) {
            this.registry = registry;
            this.identifier = registry.key().location();
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Deprecated
        @Nullable
        public net.minecraft.core.Registry<T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return true;
        }

        @Override
        @Deprecated
        @Nullable
        public IForgeRegistry<T> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            net.minecraft.core.Registry.register(this.registry, (ResourceLocation)identifier, object);
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.registry.getKey(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.registry.containsKey(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return (T)this.registry.getValue(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return this.registry.keySet();
        }

        @Override
        public Collection<T> getValues() {
            return MappedSetView.map(this.registry.entrySet(), Map.Entry::getValue);
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return MappedSetView.map(this.registry.entrySet(), entry -> Pair.of(((ResourceKey)entry.getKey()).location(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            int result = this.registry.hashCode();
            result = 31 * result + this.valueClass.hashCode();
            return result;
        }
    }

    private static class ForgeRegistryWrapper<T>
    implements Registry<T> {
        private final net.minecraft.core.Registry<T> registry;
        private final Supplier<IForgeRegistry<T>> forgeRegistrySupplier;
        private IForgeRegistry<T> forgeRegistry;
        private final ResourceLocation identifier;
        private final Class<T> valueClass;

        private ForgeRegistryWrapper(net.minecraft.core.Registry<T> registry, IForgeRegistry<T> forgeRegistry, Class<? super T> valueClass) {
            this.registry = registry;
            this.forgeRegistrySupplier = null;
            this.forgeRegistry = forgeRegistry;
            this.identifier = forgeRegistry.getRegistryName();
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        private ForgeRegistryWrapper(Supplier<IForgeRegistry<T>> forgeRegistry, ResourceLocation identifier, Class<? super T> valueClass) {
            this.registry = null;
            this.forgeRegistrySupplier = forgeRegistry;
            this.identifier = identifier;
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        private IForgeRegistry<T> resolveForgeRegistry() {
            if (this.forgeRegistry == null) {
                this.forgeRegistry = this.forgeRegistrySupplier.get();
                if (this.forgeRegistry == null) {
                    throw new IllegalStateException("Tried resolving for Forge registry '" + String.valueOf(this.identifier) + "' too early!");
                }
            }
            return this.forgeRegistry;
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Deprecated
        @Nullable
        public net.minecraft.core.Registry<T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return this.registry != null;
        }

        @Override
        @Deprecated
        @Nullable
        public IForgeRegistry<T> getForgeRegistry() {
            return this.resolveForgeRegistry();
        }

        @Override
        public boolean hasForgeRegistry() {
            return true;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            this.resolveForgeRegistry().register(identifier, object);
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.resolveForgeRegistry().getKey(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.resolveForgeRegistry().containsKey(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return (T)this.resolveForgeRegistry().getValue(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return this.resolveForgeRegistry().getKeys();
        }

        @Override
        public Collection<T> getValues() {
            return this.resolveForgeRegistry().getValues();
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return MappedSetView.map(this.resolveForgeRegistry().getEntries(), entry -> Pair.of(((ResourceKey)entry.getKey()).location(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }
    }

    private static class MapBackedRegistry<T>
    implements Registry<T> {
        private final ResourceLocation identifier;
        private final Map<ResourceLocation, T> identifierToObject = new HashMap<ResourceLocation, T>();
        private final Map<T, ResourceLocation> objectToIdentifier = new HashMap<T, ResourceLocation>();
        private final Set<Pair<ResourceLocation, T>> entries = new HashSet<Pair<ResourceLocation, T>>();
        private final Class<T> valueClass;

        private MapBackedRegistry(ResourceLocation identifier, Class<? super T> valueClass) {
            this.identifier = identifier;
            this.valueClass = valueClass;
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        public net.minecraft.core.Registry<T> getVanillaRegistry() {
            return null;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return false;
        }

        @Override
        @Nullable
        public IForgeRegistry<T> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            if (this.identifierToObject.containsKey(identifier)) {
                throw new RuntimeException("Duplicate registry for identifier '" + String.valueOf(identifier) + "'!");
            }
            if (this.objectToIdentifier.containsKey(object)) {
                throw new RuntimeException("Duplicate registry for object under '" + String.valueOf(this.objectToIdentifier.get(object)) + "' and '" + String.valueOf(identifier) + "'!");
            }
            this.identifierToObject.put(identifier, object);
            this.objectToIdentifier.put(object, identifier);
            this.entries.add(Pair.of(identifier, object));
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.objectToIdentifier.get(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.identifierToObject.containsKey(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return this.identifierToObject.get(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return Collections.unmodifiableSet(this.identifierToObject.keySet());
        }

        @Override
        public Collection<T> getValues() {
            return Collections.unmodifiableCollection(this.objectToIdentifier.keySet());
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return Collections.unmodifiableSet(this.entries);
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }
    }
}

