/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.function.Function;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.component.DescriptionComponent;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.item.PortstoneBlockItem;
import net.blay09.mods.waystones.item.SharestoneBlockItem;
import net.blay09.mods.waystones.item.WaystoneBlockItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;

public class ModBlocks {
    private static final DyeColor[] portstoneColors = new DyeColor[]{DyeColor.WHITE, DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.LIGHT_BLUE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.PINK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.BROWN, DyeColor.GREEN, DyeColor.RED, DyeColor.BLACK};
    private static final DyeColor[] sharestoneColors = new DyeColor[]{DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.LIGHT_BLUE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.PINK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.BROWN, DyeColor.GREEN, DyeColor.RED, DyeColor.BLACK};
    public static Block waystone;
    public static Block mossyWaystone;
    public static Block sandyWaystone;
    public static Block deepslateWaystone;
    public static Block blackstoneWaystone;
    public static Block endStoneWaystone;
    public static Block warpPlate;
    public static final PortstoneBlock[] portstones;
    public static final SharestoneBlock[] sharestones;

    public static void initialize(BalmBlocks blocks) {
        blocks.register(identifier -> {
            waystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return waystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("waystone"));
        blocks.register(identifier -> {
            mossyWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return mossyWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("mossy_waystone"));
        blocks.register(identifier -> {
            sandyWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return sandyWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("sandy_waystone"));
        blocks.register(identifier -> {
            deepslateWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier).sound(SoundType.DEEPSLATE));
            return deepslateWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("deepslate_waystone"));
        blocks.register(identifier -> {
            blackstoneWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return blackstoneWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("blackstone_waystone"));
        blocks.register(identifier -> {
            endStoneWaystone = new WaystoneBlock(ModBlocks.defaultProperties(identifier));
            return endStoneWaystone;
        }, ModBlocks::waystoneItemBlock, ModBlocks.id("end_stone_waystone"));
        blocks.register(identifier -> {
            warpPlate = new WarpPlateBlock(ModBlocks.defaultProperties(identifier));
            return warpPlate;
        }, ModBlocks::itemBlock, ModBlocks.id("warp_plate"));
        for (DyeColor color : portstoneColors) {
            blocks.register(identifier -> {
                PortstoneBlock portstoneBlock = new PortstoneBlock(color, ModBlocks.defaultProperties(identifier));
                ModBlocks.portstones[color.ordinal()] = portstoneBlock;
                return portstoneBlock;
            }, (block, name) -> ModBlocks.portstoneItemBlock(block, name, properties -> properties.component((DataComponentType)ModComponents.description.get(), (Object)new DescriptionComponent((Component)Component.translatable((String)"tooltip.waystones.portstone").withStyle(ChatFormatting.GRAY)))), ModBlocks.id(color.getSerializedName() + "_portstone"));
        }
        for (DyeColor color : sharestoneColors) {
            blocks.register(identifier -> {
                SharestoneBlock sharestoneBlock = new SharestoneBlock(color, ModBlocks.defaultProperties(identifier));
                ModBlocks.sharestones[color.ordinal() - 1] = sharestoneBlock;
                return sharestoneBlock;
            }, (block, name) -> ModBlocks.sharestoneItemBlock(block, name, properties -> properties.component((DataComponentType)ModComponents.description.get(), (Object)new DescriptionComponent((Component)Component.translatable((String)("tooltip.waystones." + name.getPath()))))), ModBlocks.id(color.getSerializedName() + "_sharestone"));
        }
    }

    private static BlockItem portstoneItemBlock(Block block, ResourceLocation name, Function<Item.Properties, Item.Properties> properties) {
        return new PortstoneBlockItem(block, properties.apply(ModBlocks.defaultItemProperties(name)));
    }

    private static BlockItem sharestoneItemBlock(Block block, ResourceLocation name, Function<Item.Properties, Item.Properties> properties) {
        return new SharestoneBlockItem(block, properties.apply(ModBlocks.defaultItemProperties(name)));
    }

    private static BlockItem waystoneItemBlock(Block block, ResourceLocation name) {
        return new WaystoneBlockItem(block, ModBlocks.defaultItemProperties(name));
    }

    private static BlockItem itemBlock(Block block, ResourceLocation name) {
        return new BlockItem(block, ModBlocks.defaultItemProperties(name));
    }

    private static BlockItem itemBlock(Block block, ResourceLocation name, Function<Item.Properties, Item.Properties> properties) {
        return new BlockItem(block, properties.apply(ModBlocks.defaultItemProperties(name)));
    }

    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)name);
    }

    private static ResourceKey<Block> blockId(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier);
    }

    private static ResourceKey<Item> itemId(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)identifier);
    }

    private static BlockBehaviour.Properties defaultProperties(ResourceLocation identifier) {
        return BlockBehaviour.Properties.of().setId(ModBlocks.blockId(identifier)).sound(SoundType.STONE).strength(5.0f, 2000.0f);
    }

    private static Item.Properties defaultItemProperties(ResourceLocation identifier) {
        return new Item.Properties().setId(ModBlocks.itemId(identifier));
    }

    @Nullable
    public static SharestoneBlock getSharestone(DyeColor color) {
        int index = color.ordinal() - 1;
        if (index < 0 || index >= sharestones.length) {
            return null;
        }
        return sharestones[index];
    }

    @Nullable
    public static PortstoneBlock getPortstone(DyeColor color) {
        int index = color.ordinal();
        if (index >= portstones.length) {
            return null;
        }
        return portstones[index];
    }

    static {
        portstones = new PortstoneBlock[portstoneColors.length];
        sharestones = new SharestoneBlock[sharestoneColors.length];
    }
}

