/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.client.requirement.RequirementClientRegistry;
import net.blay09.mods.waystones.client.requirement.RequirementRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class WaystoneButton
extends Button {
    private final WarpRequirement warpRequirement;
    private final Waystone waystone;

    public WaystoneButton(int x, int y, Waystone waystone, WarpRequirement warpRequirement, Button.OnPress pressable) {
        super(x, y, 200, 20, WaystoneButton.getWaystoneNameComponent(waystone), pressable, Button.DEFAULT_NARRATION);
        LocalPlayer player = Minecraft.getInstance().player;
        this.warpRequirement = warpRequirement;
        this.waystone = waystone;
        if (player == null) {
            this.active = false;
        } else if (!warpRequirement.canAfford((Player)player) && !player.getAbilities().instabuild) {
            this.active = false;
        }
    }

    private static Component getWaystoneNameComponent(Waystone waystone) {
        MutableComponent effectiveName = waystone.getName().copy();
        if (effectiveName.getString().isEmpty()) {
            effectiveName = Component.translatable((String)"gui.waystones.waystone_selection.unnamed_waystone");
        }
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            effectiveName.withStyle(ChatFormatting.YELLOW);
        }
        return effectiveName;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        Font font = Minecraft.getInstance().font;
        LocalPlayer player = Minecraft.getInstance().player;
        if (this.waystone.getDimension() == player.level().dimension() && this.isActive()) {
            int distance = (int)player.position().distanceTo(this.waystone.getPos().getCenter());
            String distanceStr = distance < 10000 && (font.width((FormattedText)this.getMessage()) < 120 || distance < 1000) ? distance + "m" : String.format("%.1f", Float.valueOf((float)distance / 1000.0f)).replace(",0", "").replace(".0", "") + "km";
            int xOffset = this.getWidth() - font.width(distanceStr);
            guiGraphics.drawString(font, distanceStr, this.getX() + xOffset - 4, this.getY() + 6, 0xFFFFFF);
        }
        this.renderRequirements(this.warpRequirement, guiGraphics, mouseX, mouseY, partialTicks);
    }

    private <T extends WarpRequirement> void renderRequirements(T requirement, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.getInstance().font;
        LocalPlayer player = Minecraft.getInstance().player;
        RequirementRenderer<Class<?>> renderer = RequirementClientRegistry.getRenderer(requirement.getClass());
        if (renderer != null) {
            renderer.renderWidget((Player)player, (Class<?>)((Object)requirement), guiGraphics, mouseX, mouseY, partialTicks, this.getX() + 2, this.getY() + 2);
            if (this.isHovered && mouseX < this.getX() + 2 + renderer.getWidth((Player)player, (Class<?>)((Object)requirement))) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                this.warpRequirement.appendHoverText((Player)player, tooltip);
                Optional optional = Optional.empty();
                Objects.requireNonNull(font);
                guiGraphics.setTooltipForNextFrame(font, tooltip, optional, mouseX, mouseY + 9);
            }
        }
    }
}

