/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.store;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.store.WaystonesStore;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public class InMemoryWaystonesStore
implements WaystonesStore {
    private final List<Waystone> waystones = new ArrayList<Waystone>();
    private final Map<UUID, Waystone> waystonesById = new HashMap<UUID, Waystone>();
    private final Multimap<ResourceLocation, Waystone> waystonesByType = ArrayListMultimap.create();

    public InMemoryWaystonesStore(List<Waystone> waystones) {
        this.waystones.addAll(waystones);
        for (Waystone waystone : waystones) {
            this.waystonesById.put(waystone.getWaystoneUid(), waystone);
            this.waystonesByType.put((Object)waystone.getWaystoneType(), (Object)waystone);
        }
    }

    @Override
    public void addWaystone(Waystone waystone) {
        this.waystones.add(waystone);
        this.waystonesById.put(waystone.getWaystoneUid(), waystone);
        this.waystonesByType.put((Object)waystone.getWaystoneType(), (Object)waystone);
    }

    @Override
    public void updateWaystone(Waystone waystone) {
        Waystone backingWaystone = this.waystonesById.get(waystone.getWaystoneUid());
        if (backingWaystone instanceof MutableWaystone) {
            MutableWaystone mutableWaystone = (MutableWaystone)((Object)backingWaystone);
            mutableWaystone.setName(waystone.getName());
            mutableWaystone.setVisibility(waystone.getVisibility());
        } else if (!(waystone instanceof WaystoneProxy) && waystone.isValid()) {
            this.addWaystone(waystone);
        }
    }

    @Override
    public void removeWaystone(Waystone waystone) {
        Waystone removedWaystone = this.waystonesById.remove(waystone.getWaystoneUid());
        this.waystones.remove(removedWaystone);
        this.waystonesByType.get((Object)waystone.getWaystoneType()).remove(removedWaystone);
    }

    @Override
    public Optional<Waystone> getWaystoneAt(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase blockEntity2 = (WaystoneBlockEntityBase)blockEntity;
            return Optional.of(blockEntity2.getWaystone());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Waystone> getWaystoneById(UUID waystoneUid) {
        return Optional.ofNullable(this.waystonesById.get(waystoneUid));
    }

    @Override
    public Optional<Waystone> findWaystoneByName(String name) {
        return this.waystones.stream().filter(it -> it.getName().getString().equals(name)).findFirst();
    }

    @Override
    public List<Waystone> getWaystones() {
        return this.waystones;
    }

    @Override
    public Collection<Waystone> getWaystonesByType(ResourceLocation type) {
        return this.waystonesByType.get((Object)type);
    }

    @Override
    public List<Waystone> getGlobalWaystones() {
        return this.waystones.stream().filter(it -> it.getVisibility() == WaystoneVisibility.GLOBAL).toList();
    }
}

