/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.data;

import com.supermartijn642.core.generator.BlockStateGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.StabilizerBlock;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.generator.CoalGeneratorBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class WormholeBlockStateGenerator
extends BlockStateGenerator {
    public WormholeBlockStateGenerator(ResourceCache cache) {
        super("wormhole", cache);
    }

    public void generate() {
        this.blockState((Block)Wormhole.portal_frame).emptyVariant(variant -> variant.model("block/portal_frame"));
        this.blockState((Block)Wormhole.portal).variantsForAllExcept((state, variant) -> {
            Direction.Axis axis = (Direction.Axis)state.get(PortalBlock.AXIS_PROPERTY);
            DyeColor color = (DyeColor)state.get(PortalBlock.COLOR_PROPERTY);
            variant.model("block/portals/portal_" + axis.getName() + "_" + color.getName());
        }, new Property[]{PortalBlock.WATERLOGGED});
        this.blockState((Block)Wormhole.portal_stabilizer).variantsForProperty((Property)StabilizerBlock.ON_PROPERTY, (state, variant) -> variant.model("block/portal_stabilizer_" + ((Boolean)state.get((Property)StabilizerBlock.ON_PROPERTY) != false ? "on" : "off")));
        this.blockState((Block)Wormhole.basic_energy_cell).variantsForProperty((Property)EnergyCellBlock.ENERGY_LEVEL, (state, variant) -> variant.model("block/energy_cells/basic_energy_cell_" + String.valueOf(state.get((Property)EnergyCellBlock.ENERGY_LEVEL))));
        this.blockState((Block)Wormhole.advanced_energy_cell).variantsForProperty((Property)EnergyCellBlock.ENERGY_LEVEL, (state, variant) -> variant.model("block/energy_cells/advanced_energy_cell_" + String.valueOf(state.get((Property)EnergyCellBlock.ENERGY_LEVEL))));
        this.blockState((Block)Wormhole.creative_energy_cell).emptyVariant(variant -> variant.model("block/energy_cells/creative_energy_cell"));
        for (TargetCellType type : TargetCellType.values()) {
            this.blockState((Block)type.getBlock()).variantsForProperty((Property)TargetCellBlock.VISUAL_TARGETS, (state, variant) -> variant.model("block/target_cells/" + type.getRegistryName() + "_" + Math.min(type.getVisualCapacity(), (Integer)state.get((Property)TargetCellBlock.VISUAL_TARGETS))));
        }
        this.blockState((Block)Wormhole.coal_generator).variantsForAll((state, variant) -> {
            boolean lit = (Boolean)state.get((Property)CoalGeneratorBlock.LIT);
            int rotation = ((int)((Direction)state.get(CoalGeneratorBlock.FACING)).toYRot() + 180) % 360;
            variant.model(lit ? "block/coal_generator_lit" : "block/coal_generator", 0, rotation);
        });
    }
}

