/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.mojang.serialization.Codec;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.wormhole.portal.IPortalGroupEntity;
import com.supermartijn642.wormhole.portal.PortalGroup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
IEnergyStorage {
    private static final int BLOCKS_PER_TICK = 5;
    protected int energy;
    protected final int energyCapacity;
    private final int energyRange;
    private final int energyTransferLimit;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this);
    private final Set<BlockPos> portalBlocks = new LinkedHashSet<BlockPos>();
    private final HashMap<BlockPos, Direction> energyBlocks = new HashMap();
    private int searchX;
    private int searchY;
    private int searchZ;

    public GeneratorBlockEntity(BaseBlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int energyCapacity, int energyRange, int energyTransferLimit) {
        super(blockEntityType, pos, state);
        this.energyCapacity = energyCapacity;
        this.energyRange = energyRange;
        this.energyTransferLimit = energyTransferLimit;
        this.searchY = this.searchZ = -energyRange;
        this.searchX = this.searchZ;
    }

    public void update() {
        if (!this.level.isClientSide) {
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = this.worldPosition.offset(this.searchX, this.searchY, this.searchZ);
                if (!pos.equals((Object)this.worldPosition)) {
                    BlockEntity entity = this.level.getBlockEntity(pos);
                    if (entity instanceof IPortalGroupEntity && ((IPortalGroupEntity)entity).hasGroup()) {
                        if (!this.portalBlocks.contains(pos) || this.energyBlocks.containsKey(pos)) {
                            this.portalBlocks.add(pos);
                            this.energyBlocks.remove(pos);
                            this.dataChanged();
                        }
                    } else {
                        boolean bl = false;
                        Direction inputSide = Direction.UP;
                        if (entity != null) {
                            for (Direction side : Direction.values()) {
                                LazyOptional optional = entity.getCapability(ForgeCapabilities.ENERGY, side);
                                if (!optional.map(IEnergyStorage::canReceive).orElse(false).booleanValue()) continue;
                                bl = true;
                                inputSide = side;
                                break;
                            }
                        }
                        if (bl && this.energyBlocks.get(pos) != inputSide) {
                            this.energyBlocks.put(pos, inputSide);
                            this.dataChanged();
                        } else if (!bl && this.energyBlocks.containsKey(pos)) {
                            this.energyBlocks.remove(pos);
                            this.dataChanged();
                        }
                        if (this.portalBlocks.contains(pos)) {
                            this.portalBlocks.remove(pos);
                            this.dataChanged();
                        }
                    }
                }
                ++this.searchX;
                if (this.searchX <= this.energyRange) continue;
                this.searchX = -this.energyRange;
                ++this.searchZ;
                if (this.searchZ <= this.energyRange) continue;
                this.searchZ = -this.energyRange;
                ++this.searchY;
                if (this.searchY <= this.energyRange) continue;
                this.searchY = -this.energyRange;
            }
            if (this.energy <= 0) {
                return;
            }
            int toTransfer = Math.min(this.energyTransferLimit, this.energy);
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            for (BlockPos blockPos : this.portalBlocks) {
                BlockEntity entity = this.level.getBlockEntity(blockPos);
                if (entity instanceof IPortalGroupEntity && ((IPortalGroupEntity)entity).hasGroup()) {
                    PortalGroup group = ((IPortalGroupEntity)entity).getGroup();
                    int transferred = group.receiveEnergy(toTransfer, false);
                    toTransfer -= transferred;
                    this.energy -= transferred;
                    this.dataChanged();
                    if (this.energy != 0) continue;
                    return;
                }
                toRemove.add(blockPos);
            }
            if (!toRemove.isEmpty()) {
                this.portalBlocks.removeAll(toRemove);
                toRemove.clear();
                this.dataChanged();
            }
            for (Map.Entry entry : this.energyBlocks.entrySet()) {
                LazyOptional optional;
                BlockPos pos = (BlockPos)entry.getKey();
                BlockEntity entity = this.level.getBlockEntity(pos);
                if (entity != null && (optional = entity.getCapability(ForgeCapabilities.ENERGY, (Direction)entry.getValue())).isPresent()) {
                    int max = toTransfer;
                    int transferred = optional.map(storage -> storage.receiveEnergy(max, false)).orElse(0);
                    toTransfer -= transferred;
                    this.energy -= transferred;
                    this.dataChanged();
                    if (this.energy != 0) continue;
                    return;
                }
                toRemove.add(pos);
            }
            if (!toRemove.isEmpty()) {
                toRemove.forEach(this.energyBlocks::remove);
                this.dataChanged();
            }
        }
    }

    public Set<BlockPos> getChargingPortalBlocks() {
        return this.portalBlocks;
    }

    public Set<BlockPos> getChargingEnergyBlocks() {
        return this.energyBlocks.keySet();
    }

    protected void writeData(ValueOutput output) {
        output.putInt("energy", this.energy);
        BlockPos self = this.worldPosition;
        output.putInt("searchX", this.searchX - self.getX());
        output.putInt("searchY", this.searchY - self.getY());
        output.putInt("searchZ", this.searchZ - self.getZ());
        this.portalBlocks.stream().map(pos -> pos.subtract((Vec3i)self)).mapToLong(BlockPos::asLong).forEach(arg_0 -> ((ValueOutput.TypedOutputList)output.list("portalBlocks", (Codec)Codec.LONG)).add(arg_0));
        int[] energyBlocks = new int[this.energyBlocks.size() * 4];
        int index = 0;
        for (Map.Entry<BlockPos, Direction> entry : this.energyBlocks.entrySet()) {
            energyBlocks[index++] = entry.getKey().getX() - self.getX();
            energyBlocks[index++] = entry.getKey().getY() - self.getY();
            energyBlocks[index++] = entry.getKey().getZ() - self.getZ();
            energyBlocks[index++] = entry.getValue().get3DDataValue();
        }
        output.putIntArray("energyBlocks", energyBlocks);
    }

    protected void writeItemStackData(ValueOutput output) {
        super.writeItemStackData(output);
        output.discard("searchX");
        output.discard("searchY");
        output.discard("searchZ");
        output.discard("portalBlocks");
        output.discard("energyBlocks");
    }

    protected void readData(ValueInput input) {
        this.energy = input.getIntOr("energy", 0);
        BlockPos self = this.worldPosition;
        this.searchX = Math.min(Math.max(input.getIntOr("searchX", 0) + self.getX(), -this.energyRange), this.energyRange);
        this.searchY = Math.min(Math.max(input.getIntOr("searchY", 0) + self.getY(), -this.energyRange), this.energyRange);
        this.searchZ = Math.min(Math.max(input.getIntOr("searchZ", 0) + self.getZ(), -this.energyRange), this.energyRange);
        this.portalBlocks.clear();
        input.listOrEmpty("portalBlocks", (Codec)Codec.LONG).stream().map(BlockPos::of).forEach(this.portalBlocks::add);
        this.energyBlocks.clear();
        int[] energyBlocks = input.getIntArray("energyBlocks").orElseGet(() -> new int[0]);
        int i = 0;
        while (i < energyBlocks.length / 4 * 4) {
            this.energyBlocks.put(new BlockPos(energyBlocks[i++] + self.getX(), energyBlocks[i++] + self.getY(), energyBlocks[i++] + self.getZ()), Direction.from3DDataValue((int)energyBlocks[i++]));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = Math.min(Math.min(this.energy, this.energyTransferLimit), maxExtract);
        if (extracted > 0 && !simulate) {
            this.energy -= extracted;
            this.dataChanged();
        }
        return Math.max(extracted, 0);
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.energyCapacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCapability.invalidate();
    }
}

