/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import com.supermartijn642.core.TextComponents;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class PortalTarget {
    public static final int MAX_NAME_LENGTH = 10;
    public final ResourceKey<Level> dimension;
    public final int x;
    public final int y;
    public final int z;
    public final float yaw;
    public String name;
    public DyeColor color;
    public Component dimensionDisplayName;

    public PortalTarget(ResourceKey<Level> dimension, int x, int y, int z, float yaw, String name, DyeColor color) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.name = name;
        this.color = color;
        this.dimensionDisplayName = TextComponents.dimension(dimension).get();
    }

    public PortalTarget(Level level, BlockPos pos, float yaw, String name) {
        this((ResourceKey<Level>)level.dimension(), pos.getX(), pos.getY(), pos.getZ(), yaw, name, null);
    }

    public PortalTarget(ValueInput input) {
        this((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)input.getString("dimension").map(ResourceLocation::parse).get()), input.getIntOr("x", 0), input.getIntOr("y", 0), input.getIntOr("z", 0), input.getFloatOr("yaw", 0.0f), input.getString("name").orElse("Target Destination"), input.getInt("color").map(DyeColor::byId).orElse(null));
    }

    public static PortalTarget read(ValueInput input) {
        return new PortalTarget(input);
    }

    public void write(ValueOutput output) {
        output.putString("dimension", this.dimension.location().toString());
        output.putInt("x", this.x);
        output.putInt("y", this.y);
        output.putInt("z", this.z);
        output.putFloat("yaw", this.yaw);
        output.putString("name", this.name);
        if (this.color != null) {
            output.putInt("color", this.color.getId());
        }
    }

    public Optional<Level> getLevel(MinecraftServer server) {
        return Optional.ofNullable(server.getLevel(this.dimension));
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Vec3 getCenteredPos() {
        return new Vec3((double)this.x + 0.5, (double)this.y + 0.2, (double)this.z + 0.5);
    }

    public Component getDimensionDisplayName() {
        return this.dimensionDisplayName;
    }
}

