/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.premade.ButtonWidget;
import com.supermartijn642.core.gui.widget.premade.LabelWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeClient;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.packets.PortalAddTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalClearTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalMoveTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalSelectTargetPacket;
import com.supermartijn642.wormhole.portal.screen.PortalGroupScreen;
import com.supermartijn642.wormhole.portal.screen.PortalTargetEditColorButton;
import com.supermartijn642.wormhole.portal.screen.ScreenBlockRenderer;
import com.supermartijn642.wormhole.screen.ArrowButton;
import com.supermartijn642.wormhole.screen.WormholeColoredButton;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PortalTargetScreen
extends PortalGroupScreen {
    public static final ResourceLocation BACKGROUND = PortalTargetScreen.getTexture("select_target_screen/background");
    public static final ResourceLocation BACKGROUND_WITH_DEVICE = PortalTargetScreen.getTexture("select_target_screen/background_with_device");
    public static final ResourceLocation SELECT_HIGHLIGHT = PortalTargetScreen.getTexture("select_target_screen/select_highlight");
    public static final ResourceLocation SELECT_HIGHLIGHT_DEVICE = PortalTargetScreen.getTexture("select_target_screen/device_select_highlight");
    public static final ResourceLocation HOVER_HIGHLIGHT = PortalTargetScreen.getTexture("select_target_screen/hover_highlight");
    public static final ResourceLocation HOVER_HIGHLIGHT_DEVICE = PortalTargetScreen.getTexture("select_target_screen/device_hover_highlight");
    public static final ResourceLocation LOCATION_ICON = PortalTargetScreen.getTexture("select_target_screen/location_icon");
    public static final ResourceLocation ENERGY_ICON = PortalTargetScreen.getTexture("select_target_screen/lightning_icon");
    public static final ResourceLocation DIMENSION_ICON = PortalTargetScreen.getTexture("select_target_screen/dimension_icon");
    public static final ResourceLocation DIRECTION_ICON = PortalTargetScreen.getTexture("select_target_screen/direction_icon");
    public static final ResourceLocation STAR_ICON = PortalTargetScreen.getTexture("select_target_screen/star_icon");
    public static final ResourceLocation SEPARATOR = PortalTargetScreen.getTexture("select_target_screen/separator");
    private static final int WIDTH = 240;
    private static final int HEIGHT = 185;
    private static final int WIDTH_WITH_DEVICE = 353;
    private static final int HEIGHT_WITH_DEVICE = 185;
    private final boolean hasTargetDevice;
    public final InteractionHand hand;
    private int scrollOffset = 0;
    private int selectedPortalTarget;
    private int selectedDeviceTarget = -1;
    private final List<LabelWidget> portalTargetNameLabels = new LinkedList<LabelWidget>();
    private final List<ArrowButton> portalUpArrows = new LinkedList<ArrowButton>();
    private final List<ArrowButton> portalDownArrows = new LinkedList<ArrowButton>();
    private final List<LabelWidget> deviceTargetNameLabels = new LinkedList<LabelWidget>();
    private WormholeColoredButton selectButton;
    private WormholeColoredButton removeButton;
    private PortalTargetEditColorButton colorButton;

    private static ResourceLocation getTexture(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)("gui/" + name));
    }

    public PortalTargetScreen(BlockPos pos) {
        super(0, 0, pos);
        if (this.validateObjectOrClose()) {
            this.selectedPortalTarget = ((PortalGroup)this.object).getActiveTarget() == null ? -1 : ((PortalGroup)this.object).getActiveTargetIndex();
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack stack = ClientUtils.getPlayer().getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof TargetDeviceItem)) {
            stack = ClientUtils.getPlayer().getItemInHand(InteractionHand.OFF_HAND);
            hand = InteractionHand.OFF_HAND;
        }
        this.hasTargetDevice = stack.getItem() instanceof TargetDeviceItem;
        this.hand = hand;
    }

    public PortalTargetScreen(BlockPos pos, int scrollOffset, int selectedPortalTarget, int selectedDeviceTarget) {
        this(pos);
        if (this.validateObjectOrClose()) {
            this.scrollOffset = Math.min(scrollOffset, Math.max(0, ((PortalGroup)this.object).getTotalTargetCapacity() - 10));
        }
        this.selectedPortalTarget = selectedPortalTarget;
        this.selectedDeviceTarget = selectedDeviceTarget;
    }

    protected Component getNarrationMessage(PortalGroup object) {
        return TextComponents.translation((String)"wormhole.portal.targets.gui.title").get();
    }

    protected int width(PortalGroup object) {
        return this.hasTargetDevice ? 353 : 240;
    }

    protected int height(PortalGroup object) {
        return this.hasTargetDevice ? 185 : 185;
    }

    protected void addWidgets(PortalGroup group) {
        this.addPortalTargetWidgets(group);
        if (this.hasTargetDevice) {
            this.addDeviceTargetWidgets();
        }
        this.selectButton = (WormholeColoredButton)this.addWidget((Widget)new WormholeColoredButton(160, 146, 62, 11, (Component)TextComponents.translation((String)"wormhole.portal.targets.gui.select").get(), () -> Wormhole.CHANNEL.sendToServer((BasePacket)new PortalSelectTargetPacket((PortalGroup)this.object, this.selectedPortalTarget))));
        this.removeButton = (WormholeColoredButton)this.addWidget((Widget)new WormholeColoredButton(160, 160, 62, 11, (Component)TextComponents.translation((String)"wormhole.portal.targets.gui.remove").get(), () -> {
            if (this.selectedPortalTarget >= 0) {
                Wormhole.CHANNEL.sendToServer((BasePacket)new PortalClearTargetPacket((PortalGroup)this.object, this.selectedPortalTarget));
            } else if (this.selectedDeviceTarget >= 0) {
                Wormhole.CHANNEL.sendToServer((BasePacket)new PortalAddTargetPacket((PortalGroup)this.object, this.hand, this.selectedDeviceTarget));
            }
        }));
        Supplier<DyeColor> color = () -> {
            PortalTarget target = ((PortalGroup)this.object).getTarget(this.selectedPortalTarget);
            return target == null ? null : target.color;
        };
        this.colorButton = (PortalTargetEditColorButton)this.addWidget((Widget)new PortalTargetEditColorButton(this, 150, 91, () -> this.selectedPortalTarget, color, () -> WormholeClient.openPortalTargetScreen(this.pos, this.scrollOffset, this.selectedPortalTarget, this.selectedDeviceTarget)));
        this.addWidget((Widget)new ButtonWidget(-35, 5, 30, 15, (Component)TextComponents.translation((String)"wormhole.portal.targets.gui.return").get(), () -> WormholeClient.openPortalOverviewScreen(this.pos)));
    }

    protected void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, PortalGroup object) {
        ResourceLocation texture = this.hasTargetDevice ? BACKGROUND_WITH_DEVICE : BACKGROUND;
        graphics.submitSprite(texture, 0.0f, 0.0f, (float)this.width(), (float)this.height());
        if (this.selectedPortalTarget >= this.scrollOffset && this.selectedPortalTarget < this.scrollOffset + 10) {
            graphics.submitSprite(SELECT_HIGHLIGHT, 5.0f, (float)(16 + 16 * (this.selectedPortalTarget - this.scrollOffset)), 130.0f, 16.0f);
        } else if (this.hasTargetDevice && this.selectedDeviceTarget >= 0 && this.selectedDeviceTarget < 10) {
            graphics.submitSprite(SELECT_HIGHLIGHT_DEVICE, 242.0f, (float)(16 + 16 * this.selectedDeviceTarget), 106.0f, 16.0f);
        }
        super.renderBackground(context, graphics, mouseX, mouseY, (Object)object);
    }

    protected void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, PortalGroup group) {
        PortalTarget target;
        int targetIndex;
        super.render(context, graphics, mouseX, mouseY, (Object)group);
        graphics.submitText((FormattedText)TextComponents.translation((String)"wormhole.portal.targets.gui.title").get(), 70.0f, 3.0f, p -> p.color(Integer.MAX_VALUE).centerHorizontally());
        if (this.hasTargetDevice) {
            graphics.submitText((FormattedText)TextComponents.translation((String)"wormhole.target_device.gui.title").get(), 296.0f, 3.0f, p -> p.color(Integer.MAX_VALUE).centerHorizontally());
        }
        if (mouseX > 5 && mouseX < 135 && mouseY > 16 && mouseY < 176) {
            targetIndex = (mouseY - 16) / 16;
            if (group.getTarget(targetIndex + this.scrollOffset) != null) {
                graphics.submitSprite(HOVER_HIGHLIGHT, 5.0f, (float)(16 + targetIndex * 16), 130.0f, 16.0f);
            }
        } else if (this.hasTargetDevice && mouseX > 242 && mouseX < 348 && mouseY > 16 && mouseY < 176 && this.getFromDeviceTargets(arg_0 -> PortalTargetScreen.lambda$render$8(targetIndex = (mouseY - 16) / 16, arg_0), false).booleanValue()) {
            graphics.submitSprite(HOVER_HIGHLIGHT_DEVICE, 242.0f, (float)(16 + targetIndex * 16), 106.0f, 16.0f);
        }
        int activeTarget = group.getActiveTargetIndex();
        for (int count = 0; count < Math.min(10, this.portalTargetNameLabels.size()); ++count) {
            if (count + this.scrollOffset != activeTarget) {
                graphics.submitText(this.scrollOffset + count + 1 + ".", 14.0f, (float)(21 + count * 16), p -> p.centerHorizontally());
                continue;
            }
            graphics.submitSprite(STAR_ICON, 8.0f, (float)(19 + 16 * count), 10.0f, 10.0f);
        }
        if (this.selectedPortalTarget >= 0 && this.selectedPortalTarget < group.getTotalTargetCapacity()) {
            PortalTarget target2 = group.getTarget(this.selectedPortalTarget);
            if (target2 != null) {
                this.renderTargetInfo(graphics, group, target2, true);
            }
        } else if (this.hasTargetDevice && this.selectedDeviceTarget >= 0 && this.selectedDeviceTarget < 10 && (target = (PortalTarget)this.getFromDeviceTargets(list -> this.selectedDeviceTarget < list.size() ? (PortalTarget)list.get(this.selectedDeviceTarget) : null, null)) != null) {
            this.renderTargetInfo(graphics, group, target, false);
        }
        this.updateSelectRemoveColorButtons(group);
    }

    private void renderTargetInfo(GuiGraphicsHelper graphics, PortalGroup group, PortalTarget target, boolean showColor) {
        graphics.submitText(target.name, 191.0f, 31.0f, p -> p.color(Integer.MAX_VALUE).centerHorizontally());
        graphics.submitSprite(SEPARATOR, 153.0f, 41.0f, 77.0f, 1.0f);
        graphics.submitSprite(LOCATION_ICON, 150.0f, 47.0f, 9.0f, 9.0f);
        graphics.submitText("(" + target.x + ", " + target.y + ", " + target.z + ")", 161.0f, 48.0f, p -> p.color(Integer.MAX_VALUE));
        Object block = target.dimension.equals((Object)Level.OVERWORLD) ? Blocks.DIRT_PATH : (target.dimension.equals((Object)Level.NETHER) ? Blocks.NETHERRACK : (target.dimension.equals((Object)Level.END) ? Blocks.END_STONE : null));
        if (block == null) {
            graphics.submitSprite(DIMENSION_ICON, 150.0f, 59.0f, 9.0f, 9.0f);
        } else {
            graphics.submitCustomRendering(148, 57, 13, 13, arg_0 -> PortalTargetScreen.lambda$renderTargetInfo$13((Block)block, arg_0));
        }
        graphics.submitText((FormattedText)target.getDimensionDisplayName(), 161.0f, 60.0f, p -> p.color(Integer.MAX_VALUE));
        graphics.submitSprite(DIRECTION_ICON, 148.0f, 69.0f, 13.0f, 13.0f);
        graphics.submitText((FormattedText)TextComponents.translation((String)("wormhole.direction." + String.valueOf(Direction.fromYRot((double)target.yaw)))).get(), 161.0f, 72.0f, p -> p.color(Integer.MAX_VALUE));
        graphics.submitSprite(SEPARATOR, 153.0f, 85.0f, 77.0f, 1.0f);
        if (showColor) {
            graphics.submitText((FormattedText)TextComponents.translation((String)("wormhole.color." + (target.color == null ? "random" : target.color.getName()))).get(), 161.0f, 92.0f, p -> p.color(Integer.MAX_VALUE));
            graphics.submitSprite(SEPARATOR, 153.0f, 105.0f, 77.0f, 1.0f);
        }
        graphics.submitSprite(ENERGY_ICON, 150.0f, showColor ? 111.0f : 91.0f, 9.0f, 9.0f);
        int cost = PortalGroup.getTeleportCostToTarget(ClientUtils.getWorld(), group.getCenterPos(), target);
        graphics.submitText(EnergyFormat.formatEnergyWithUnit((int)cost), 161.0f, showColor ? 112.0f : 92.0f, p -> p.color(Integer.MAX_VALUE));
    }

    private void addPortalTargetWidgets(PortalGroup group) {
        int portalCapacity = group.getTotalTargetCapacity();
        int count = 0;
        while (count < Math.min(10, portalCapacity)) {
            int index = count++;
            int y = 18 + index * 16;
            this.portalTargetNameLabels.add((LabelWidget)this.addWidget((Widget)new LabelWidget(20, y, 102, 12, () -> {
                PortalTarget target = ((PortalGroup)this.object).getTarget(index + this.scrollOffset);
                return (target == null ? TextComponents.empty() : TextComponents.string((String)target.name)).get();
            })));
            ArrowButton upArrowButton = new ArrowButton(123, y + 1, true, () -> {
                if (this.selectedPortalTarget == this.scrollOffset + index) {
                    --this.selectedPortalTarget;
                } else if (this.selectedPortalTarget == this.scrollOffset + index - 1) {
                    ++this.selectedPortalTarget;
                }
                Wormhole.CHANNEL.sendToServer((BasePacket)new PortalMoveTargetPacket((PortalGroup)this.object, this.scrollOffset + index, true));
            });
            this.portalUpArrows.add((ArrowButton)this.addWidget((Widget)upArrowButton));
            ArrowButton downArrowButton = new ArrowButton(123, y + 6, false, () -> {
                if (this.selectedPortalTarget == this.scrollOffset + index) {
                    ++this.selectedPortalTarget;
                } else if (this.selectedPortalTarget == this.scrollOffset + index + 1) {
                    --this.selectedPortalTarget;
                }
                Wormhole.CHANNEL.sendToServer((BasePacket)new PortalMoveTargetPacket((PortalGroup)this.object, this.scrollOffset + index, false));
            });
            this.portalDownArrows.add((ArrowButton)this.addWidget((Widget)downArrowButton));
        }
        this.updateArrowButtons(group);
    }

    private void addDeviceTargetWidgets() {
        ItemStack stack = ClientUtils.getPlayer().getItemInHand(this.hand);
        if (stack.isEmpty() || !(stack.getItem() instanceof TargetDeviceItem)) {
            return;
        }
        int deviceCapacity = TargetDeviceItem.getMaxTargetCount(stack);
        int count = 0;
        while (count < Math.min(10, deviceCapacity)) {
            int index = count++;
            int y = 18 + index * 16;
            this.deviceTargetNameLabels.add((LabelWidget)this.addWidget((Widget)new LabelWidget(244, y, 102, 12, () -> {
                PortalTarget target = this.getFromDeviceTargets(list -> list.size() > index ? (PortalTarget)list.get(index) : null, null);
                return (target == null ? TextComponents.empty() : TextComponents.string((String)target.name)).get();
            })));
        }
    }

    public void update(PortalGroup group) {
        super.update((Object)group);
        this.updateArrowButtons(group);
    }

    private void updateArrowButtons(PortalGroup group) {
        int capacity = group.getTotalTargetCapacity();
        for (int i = 0; i < this.portalUpArrows.size() && i < this.portalDownArrows.size(); ++i) {
            int index = i + this.scrollOffset;
            boolean hasTarget = group.getTarget(index) != null;
            this.portalUpArrows.get((int)i).active = index > 0 && hasTarget;
            this.portalDownArrows.get((int)i).active = index < capacity - 1 && hasTarget;
        }
    }

    private void updateSelectRemoveColorButtons(PortalGroup group) {
        if (this.selectedPortalTarget >= 0) {
            boolean notEmpty = group.getTarget(this.selectedPortalTarget) != null;
            this.selectButton.setVisible();
            this.selectButton.setColorGreen();
            this.selectButton.setText((Component)TextComponents.translation((String)"wormhole.portal.targets.gui.select").get());
            this.selectButton.setActive(notEmpty && group.getActiveTargetIndex() != this.selectedPortalTarget);
            this.removeButton.setVisible();
            this.removeButton.setColorRed();
            this.removeButton.setText((Component)TextComponents.translation((String)"wormhole.portal.targets.gui.remove").get());
            this.removeButton.setActive(notEmpty);
            this.colorButton.visible = notEmpty;
        } else if (this.selectedDeviceTarget >= 0) {
            boolean notEmpty = this.getFromDeviceTargets(targets -> targets.size() > this.selectedDeviceTarget && targets.get(this.selectedDeviceTarget) != null, false);
            this.selectButton.setInvisible();
            this.removeButton.setVisible();
            this.removeButton.setColorWhite();
            this.removeButton.setText((Component)TextComponents.translation((String)"wormhole.portal.targets.gui.add").get());
            this.removeButton.setActive(notEmpty);
            this.colorButton.visible = false;
        } else {
            this.selectButton.setInvisible();
            this.removeButton.setInvisible();
            this.colorButton.visible = false;
        }
    }

    protected void renderTooltips(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, PortalGroup group) {
        if (mouseX >= 149 && mouseX <= 160 && mouseY >= 46 && mouseY <= 57) {
            graphics.submitTooltipForTopStratum(c -> c.text(new Component[]{TextComponents.translation((String)"wormhole.target.location").get()}), (float)mouseX, (float)mouseY);
        } else if (mouseX >= 149 && mouseX <= 160 && mouseY >= 58 && mouseY <= 69) {
            graphics.submitTooltipForTopStratum(c -> c.text(new Component[]{TextComponents.translation((String)"wormhole.target.dimension").get()}), (float)mouseX, (float)mouseY);
        } else if (mouseX >= 149 && mouseX <= 160 && mouseY >= 70 && mouseY <= 81) {
            graphics.submitTooltipForTopStratum(c -> c.text(new Component[]{TextComponents.translation((String)"wormhole.target.direction").get()}), (float)mouseX, (float)mouseY);
        } else if (mouseX >= 149 && mouseX <= 160 && (this.selectedPortalTarget >= 0 ? mouseY >= 110 && mouseY <= 121 : mouseY >= 90 && mouseY <= 101)) {
            graphics.submitTooltipForTopStratum(c -> c.text(new Component[]{TextComponents.translation((String)"wormhole.target.teleport_cost").get()}), (float)mouseX, (float)mouseY);
        }
        super.renderTooltips(context, graphics, mouseX, mouseY, (Object)group);
    }

    public <T> T getFromDeviceTargets(Function<List<PortalTarget>, T> function, T other) {
        ItemStack stack = ClientUtils.getPlayer().getItemInHand(this.hand);
        if (!stack.isEmpty() && stack.getItem() instanceof TargetDeviceItem) {
            return function.apply(TargetDeviceItem.getTargets(stack));
        }
        return other;
    }

    private void scroll(int amount) {
        this.scrollOffset = Math.min(Math.max(0, this.scrollOffset + amount), Math.max(0, ((PortalGroup)this.object).getTotalTargetCapacity() - 10));
    }

    protected boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled, PortalGroup object) {
        if (!hasBeenHandled && mouseX >= 5 && mouseX <= 135 && mouseY >= 16 && mouseY <= 183) {
            this.scroll(-((int)scrollAmount));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled, (Object)object);
    }

    protected boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled, PortalGroup group) {
        hasBeenHandled |= super.mousePressed(mouseX, mouseY, button, hasBeenHandled, (Object)group);
        if (button == 0) {
            if (mouseX > 5 && mouseX < 135 && mouseY > 16 && mouseY < 176) {
                int targetIndex = (mouseY - 16) / 16 + this.scrollOffset;
                if (group.getTarget(targetIndex) != null) {
                    AbstractButtonWidget.playClickSound();
                    this.selectedPortalTarget = targetIndex;
                    this.selectedDeviceTarget = -1;
                }
                return true;
            }
            if (this.hasTargetDevice && mouseX > 242 && mouseX < 348 && mouseY > 16 && mouseY < 176) {
                int targetIndex = (mouseY - 16) / 16;
                if (this.getFromDeviceTargets(list -> list.size() > targetIndex && list.get(targetIndex) != null, false).booleanValue()) {
                    AbstractButtonWidget.playClickSound();
                    this.selectedPortalTarget = -1;
                    this.selectedDeviceTarget = targetIndex;
                }
                return true;
            }
        }
        return hasBeenHandled;
    }

    private static /* synthetic */ void lambda$renderTargetInfo$13(Block block, PoseStack poseStack) {
        ScreenBlockRenderer.drawBlock(poseStack, block, 6.5, 6.5, 5.5, 45.0f, 40.0f);
    }

    private static /* synthetic */ Boolean lambda$render$8(int targetIndex, List list) {
        return list.size() > targetIndex && list.get(targetIndex) != null;
    }
}

