/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ScreenBlockRenderer {
    private static final RandomSource RANDOM = RandomSource.create();

    public static void drawBlock(PoseStack poseStack, Block block, double x, double y, double scale, float yaw, float pitch) {
        BlockState state = block.defaultBlockState();
        poseStack.pushPose();
        poseStack.translate(x, y, 0.0);
        poseStack.scale(1.0f, -1.0f, -1.0f);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis((double)(pitch / 180.0f) * Math.PI, 1.0, 0.0, 0.0));
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis((double)(yaw / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
        poseStack.translate(-0.5, -0.5, -0.5);
        for (ChunkSectionLayer layer : model.getRenderTypes(state, RANDOM, ModelData.EMPTY)) {
            ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)bufferSource.getBuffer(RenderTypeHelper.getEntityRenderType((ChunkSectionLayer)layer)), (BlockStateModel)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelData)ModelData.EMPTY, (ChunkSectionLayer)layer);
        }
        bufferSource.endBatch();
        poseStack.popPose();
    }
}

