/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetcell;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TargetCellBlock
extends PortalGroupBlock {
    public static final IntegerProperty VISUAL_TARGETS;
    private final TargetCellType type;

    public TargetCellBlock(TargetCellType type) {
        super(type::getBlockEntityType);
        this.type = type;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)VISUAL_TARGETS, (Comparable)Integer.valueOf(0)));
    }

    public void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"wormhole.target_cell.info").color(ChatFormatting.AQUA).get());
        CompoundTag tag = (CompoundTag)stack.get(BaseBlock.TILE_DATA);
        int targets = tag == null || tag.isEmpty() ? 0 : tag.getIntOr("targetCount", 0);
        int targetCapacity = this.type.getCapacity();
        if (targetCapacity > 0) {
            info.accept((Component)TextComponents.translation((String)"wormhole.portal_stabilizer.info.targets", (Object[])new Object[]{targets, targetCapacity}).color(ChatFormatting.YELLOW).get());
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VISUAL_TARGETS});
    }

    static {
        int maxCapacity = 0;
        for (TargetCellType type : TargetCellType.values()) {
            if (type.getVisualCapacity() <= maxCapacity) continue;
            maxCapacity = type.getVisualCapacity();
        }
        VISUAL_TARGETS = IntegerProperty.create((String)"targets", (int)0, (int)maxCapacity);
    }
}

