/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetdevice;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeClient;
import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TargetDeviceItem
extends BaseItem {
    public static DataComponentType<List<PortalTarget>> TARGETS = DataComponentType.builder().persistent(RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(t -> t.dimension), (App)Codec.INT.fieldOf("x").forGetter(t -> t.x), (App)Codec.INT.fieldOf("y").forGetter(t -> t.y), (App)Codec.INT.fieldOf("z").forGetter(t -> t.z), (App)Codec.FLOAT.fieldOf("yaw").forGetter(t -> Float.valueOf(t.yaw)), (App)Codec.STRING.fieldOf("name").forGetter(t -> t.name), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(t -> Optional.ofNullable(t.color))).apply((Applicative)instance, (dim, x, y, z, yaw, name, color) -> new PortalTarget((ResourceKey<Level>)dim, (int)x, (int)y, (int)z, yaw.floatValue(), (String)name, color.orElse(null)))).listOf()).networkSynchronized(StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), t -> t.dimension, (StreamCodec)BlockPos.STREAM_CODEC, t -> new BlockPos(t.x, t.y, t.z), (StreamCodec)ByteBufCodecs.FLOAT, t -> Float.valueOf(t.yaw), (StreamCodec)ByteBufCodecs.STRING_UTF8, t -> t.name, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), t -> Optional.ofNullable(t.color), (dim, pos, yaw, name, color) -> new PortalTarget((ResourceKey<Level>)dim, pos.getX(), pos.getY(), pos.getZ(), yaw.floatValue(), (String)name, color.orElse(null))).apply(ByteBufCodecs.list())).build();
    private final Supplier<Integer> maxTargetCount;

    public TargetDeviceItem(Supplier<Integer> maxTargetCount) {
        super(ItemProperties.create().maxStackSize(1).group((CreativeModeTab)Wormhole.ITEM_GROUP));
        this.maxTargetCount = maxTargetCount;
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        if (level.isClientSide) {
            WormholeClient.openTargetDeviceScreen(hand, player.blockPosition(), Math.round(player.getYRot() / 90.0f) * 90);
        }
        return BaseItem.ItemUseResult.consume((ItemStack)player.getItemInHand(hand));
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"wormhole.target_device.info").color(ChatFormatting.AQUA).get());
        List<PortalTarget> targets = TargetDeviceItem.getTargets(stack);
        int capacity = TargetDeviceItem.getMaxTargetCount(stack);
        info.accept((Component)TextComponents.translation((String)"wormhole.target_device.info.targets", (Object[])new Object[]{targets.size(), capacity}).color(ChatFormatting.YELLOW).get());
    }

    public static List<PortalTarget> getTargets(ItemStack stack) {
        return stack.has(TARGETS) ? Collections.unmodifiableList((List)stack.get(TARGETS)) : Collections.emptyList();
    }

    public static void setTargets(ItemStack stack, List<PortalTarget> targets) {
        if (targets == null || targets.isEmpty()) {
            stack.remove(TARGETS);
        } else {
            stack.set(TARGETS, targets);
        }
    }

    public static void addTarget(ItemStack stack, PortalTarget target) {
        ArrayList<PortalTarget> list = new ArrayList<PortalTarget>(TargetDeviceItem.getTargets(stack));
        list.add(target);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void removeTarget(ItemStack stack, int index) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        list = new ArrayList<PortalTarget>(list);
        list.remove(index);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void moveTarget(ItemStack stack, int index, boolean up) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        if (up ? index == 0 : index == list.size() - 1) {
            return;
        }
        list = new ArrayList<PortalTarget>(list);
        PortalTarget target = list.remove(index);
        list.add(index + (up ? -1 : 1), target);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void changeTargetName(ItemStack stack, int index, String name) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        list.get((int)index).name = name;
        TargetDeviceItem.setTargets(stack, list);
    }

    public static int getMaxTargetCount(ItemStack stack) {
        return stack.getItem() instanceof TargetDeviceItem ? ((TargetDeviceItem)stack.getItem()).maxTargetCount.get() : -1;
    }
}

