/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.google.common.base.Suppliers;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCClientEventHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretHangingSignBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.items.KeycardHolderItem;
import net.geforcemods.securitycraft.items.LensItem;
import net.geforcemods.securitycraft.items.MineRemoteAccessToolItem;
import net.geforcemods.securitycraft.items.SentryRemoteAccessToolItem;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.misc.OverlayToggleHandler;
import net.geforcemods.securitycraft.models.BlockMineModel;
import net.geforcemods.securitycraft.models.BulletModel;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.models.IMSBombModel;
import net.geforcemods.securitycraft.models.SecureRedstoneInterfaceDishModel;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.models.SentryModel;
import net.geforcemods.securitycraft.models.SonicSecuritySystemModel;
import net.geforcemods.securitycraft.particle.FloorTrapCloudParticle;
import net.geforcemods.securitycraft.particle.InterfaceHighlightParticle;
import net.geforcemods.securitycraft.renderers.BlockPocketManagerRenderer;
import net.geforcemods.securitycraft.renderers.BouncingBettyRenderer;
import net.geforcemods.securitycraft.renderers.BulletRenderer;
import net.geforcemods.securitycraft.renderers.ClaymoreRenderer;
import net.geforcemods.securitycraft.renderers.DisguisableBlockEntityRenderer;
import net.geforcemods.securitycraft.renderers.DisplayCaseRenderer;
import net.geforcemods.securitycraft.renderers.IMSBombRenderer;
import net.geforcemods.securitycraft.renderers.KeypadChestRenderer;
import net.geforcemods.securitycraft.renderers.OwnableBlockEntityRenderer;
import net.geforcemods.securitycraft.renderers.ProjectorRenderer;
import net.geforcemods.securitycraft.renderers.ReinforcedPistonHeadRenderer;
import net.geforcemods.securitycraft.renderers.RetinalScannerRenderer;
import net.geforcemods.securitycraft.renderers.SecretHangingSignRenderer;
import net.geforcemods.securitycraft.renderers.SecretSignRenderer;
import net.geforcemods.securitycraft.renderers.SecureRedstoneInterfaceRenderer;
import net.geforcemods.securitycraft.renderers.SecurityCameraRenderer;
import net.geforcemods.securitycraft.renderers.SecuritySeaBoatRenderer;
import net.geforcemods.securitycraft.renderers.SentryRenderer;
import net.geforcemods.securitycraft.renderers.SonicSecuritySystemRenderer;
import net.geforcemods.securitycraft.renderers.TrophySystemRenderer;
import net.geforcemods.securitycraft.screen.AlarmScreen;
import net.geforcemods.securitycraft.screen.BlockChangeDetectorScreen;
import net.geforcemods.securitycraft.screen.BlockPocketManagerScreen;
import net.geforcemods.securitycraft.screen.BlockReinforcerScreen;
import net.geforcemods.securitycraft.screen.BriefcasePasscodeScreen;
import net.geforcemods.securitycraft.screen.CameraMonitorScreen;
import net.geforcemods.securitycraft.screen.CheckPasscodeScreen;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.EditModuleScreen;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.geforcemods.securitycraft.screen.ItemInventoryScreen;
import net.geforcemods.securitycraft.screen.KeyChangerScreen;
import net.geforcemods.securitycraft.screen.KeycardReaderScreen;
import net.geforcemods.securitycraft.screen.KeypadBlastFurnaceScreen;
import net.geforcemods.securitycraft.screen.KeypadFurnaceScreen;
import net.geforcemods.securitycraft.screen.KeypadSmokerScreen;
import net.geforcemods.securitycraft.screen.LaserBlockScreen;
import net.geforcemods.securitycraft.screen.MineRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.geforcemods.securitycraft.screen.ReinforcedLecternScreen;
import net.geforcemods.securitycraft.screen.RiftStabilizerScreen;
import net.geforcemods.securitycraft.screen.SCManualScreen;
import net.geforcemods.securitycraft.screen.SSSItemScreen;
import net.geforcemods.securitycraft.screen.SecureRedstoneInterfaceScreen;
import net.geforcemods.securitycraft.screen.SentryRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.SetPasscodeScreen;
import net.geforcemods.securitycraft.screen.SingleLensScreen;
import net.geforcemods.securitycraft.screen.SonicSecuritySystemScreen;
import net.geforcemods.securitycraft.screen.TrophySystemScreen;
import net.geforcemods.securitycraft.screen.UsernameLoggerScreen;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.geforcemods.securitycraft.util.Reinforced;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.HangingSignEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.LecternRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHandler {
    public static final float EMPTY_STATE = 0.0f;
    public static final float UNKNOWN_STATE = 0.25f;
    public static final float NOT_LINKED_STATE = 0.5f;
    public static final float LINKED_STATE = 0.75f;
    public static final ModelLayerLocation BULLET_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "bullet"), "main");
    public static final ModelLayerLocation IMS_BOMB_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "ims_bomb"), "main");
    public static final ModelLayerLocation DISPLAY_CASE_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "display_case"), "main");
    public static final ModelLayerLocation GLOW_DISPLAY_CASE_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "glow_display_case"), "main");
    public static final ModelLayerLocation SENTRY_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "sentry"), "main");
    public static final ModelLayerLocation SECURE_REDSTONE_INTERFACE_DISH_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "secure_redstone_interface_dish"), "main");
    public static final ModelLayerLocation SECURITY_CAMERA_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "security_camera"), "main");
    public static final ModelLayerLocation SONIC_SECURITY_SYSTEM_LOCATION = new ModelLayerLocation(new ResourceLocation("securitycraft", "sonic_security_system"), "main");
    public static final BlockEntityRenderDelegate DISGUISED_BLOCK_RENDER_DELEGATE = new BlockEntityRenderDelegate();
    public static final BlockEntityRenderDelegate PROJECTOR_RENDER_DELEGATE = new BlockEntityRenderDelegate();
    public static IGuiOverlay cameraOverlay;
    private static Map<Block, Integer> blocksWithReinforcedTint;
    private static Map<Block, Integer> blocksWithCustomTint;
    private static Supplier<Block[]> disguisableBlocks;
    public static final HumanoidModel.ArmPose TASER_ARM_POSE;
    public static final ResourceLocation LINKING_STATE_PROPERTY;

    private ClientHandler() {
    }

    @SubscribeEvent
    public static void onModelBakingCompleted(ModelEvent.ModifyBakingResult event) {
        String[] mines = new String[]{"ancient_debris", "blast_furnace", "coal_ore", "cobbled_deepslate", "cobblestone", "copper_ore", "deepslate", "deepslate_coal_ore", "deepslate_copper_ore", "deepslate_diamond_ore", "deepslate_emerald_ore", "deepslate_gold_ore", "deepslate_iron_ore", "deepslate_lapis_ore", "deepslate_redstone_ore", "diamond_ore", "dirt", "emerald_ore", "gravel", "gold_ore", "gilded_blackstone", "furnace", "iron_ore", "lapis_ore", "nether_gold_ore", "redstone_ore", "sand", "smoker", "stone", "suspicious_gravel", "suspicious_sand"};
        Map modelRegistry = event.getModels();
        for (Block block : disguisableBlocks.get()) {
            for (BlockState state : block.m_49965_().m_61056_()) {
                ClientHandler.registerDisguisedModel(modelRegistry, Utils.getRegistryName(block), state.m_61148_().entrySet().stream().map(StateHolder.f_61110_).collect(Collectors.joining(",")));
            }
        }
        for (String string : mines) {
            ClientHandler.registerBlockMineModel(event, new ResourceLocation("securitycraft", string.replace("_ore", "") + "_mine"), new ResourceLocation(string));
        }
        ClientHandler.registerBlockMineModel(event, new ResourceLocation("securitycraft", "quartz_mine"), new ResourceLocation("nether_quartz_ore"));
    }

    private static void registerDisguisedModel(Map<ResourceLocation, BakedModel> modelRegistry, ResourceLocation rl, String stateString) {
        ModelResourceLocation mrl = new ModelResourceLocation(rl, stateString);
        modelRegistry.put((ResourceLocation)mrl, (BakedModel)new DisguisableDynamicBakedModel(modelRegistry.get(mrl)));
    }

    private static void registerBlockMineModel(ModelEvent.ModifyBakingResult event, ResourceLocation mineRl, ResourceLocation realBlockRl) {
        ModelResourceLocation mineMrl = new ModelResourceLocation(mineRl, "inventory");
        event.getModels().put(mineMrl, new BlockMineModel((BakedModel)event.getModels().get(new ModelResourceLocation(realBlockRl, "inventory")), (BakedModel)event.getModels().get(mineMrl)));
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        RenderType translucent = RenderType.m_110466_();
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FAKE_WATER.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FLOWING_FAKE_WATER.get()), (RenderType)translucent);
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.BLOCK_REINFORCER_MENU.get()), BlockReinforcerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.BRIEFCASE_INVENTORY_MENU.get()), ItemInventoryScreen.Briefcase::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.CUSTOMIZE_BLOCK_MENU.get()), CustomizeBlockScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.CUSTOMIZE_ENTITY_MENU.get()), CustomizeBlockScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.DISGUISE_MODULE_MENU.get()), DisguiseModuleScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.INVENTORY_SCANNER_MENU.get()), InventoryScannerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.KEYPAD_FURNACE_MENU.get()), KeypadFurnaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.KEYPAD_SMOKER_MENU.get()), KeypadSmokerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.KEYPAD_BLAST_FURNACE_MENU.get()), KeypadBlastFurnaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.KEYCARD_READER_MENU.get()), KeycardReaderScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.BLOCK_POCKET_MANAGER_MENU.get()), BlockPocketManagerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.PROJECTOR_MENU.get()), ProjectorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.BLOCK_CHANGE_DETECTOR_MENU.get()), BlockChangeDetectorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.KEYCARD_HOLDER_MENU.get()), ItemInventoryScreen.KeycardHolder::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.TROPHY_SYSTEM_MENU.get()), TrophySystemScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.SINGLE_LENS_MENU.get()), SingleLensScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.LASER_BLOCK_MENU.get()), LaserBlockScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)SCContent.REINFORCED_LECTERN_MENU.get()), ReinforcedLecternScreen::new);
            ItemProperties.register((Item)((Item)SCContent.KEYCARD_HOLDER.get()), (ResourceLocation)KeycardHolderItem.COUNT_PROPERTY, (stack, level, entity, id) -> (float)KeycardHolderItem.getCardCount(stack) / 5.0f);
            ItemProperties.register((Item)((Item)SCContent.LENS.get()), (ResourceLocation)LensItem.COLOR_PROPERTY, (stack, level, entity, id) -> ((DyeableLeatherItem)stack.m_41720_()).m_41113_(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)SCContent.CAMERA_MONITOR.get()), (ResourceLocation)LINKING_STATE_PROPERTY, (stack, level, entity, id) -> {
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                Player player = (Player)entity;
                float linkingState = ClientHandler.getLinkingState((Level)level, player, stack, bhr -> level.m_7702_(bhr.m_82425_()) instanceof SecurityCameraBlockEntity, 30, (tag, i) -> {
                    if (!tag.m_128441_("Camera" + i)) {
                        return null;
                    }
                    String camera = tag.m_128461_("Camera" + i);
                    return (Integer[])Arrays.stream(camera.substring(0, camera.lastIndexOf(32)).split(" ")).map(Integer::parseInt).toArray(Integer[]::new);
                });
                if (!CameraMonitorItem.hasCameraAdded(stack.m_41783_())) {
                    if (linkingState == 0.5f) {
                        return 0.5f;
                    }
                    return 0.0f;
                }
                return linkingState;
            });
            ItemProperties.register((Item)((Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get()), (ResourceLocation)LINKING_STATE_PROPERTY, (stack, level, entity, id) -> {
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                Player player = (Player)entity;
                float linkingState = ClientHandler.getLinkingState((Level)level, player, stack, bhr -> level.m_8055_(bhr.m_82425_()).m_60734_() instanceof IExplosive, 30, (tag, i) -> {
                    if (tag.m_128465_("mine" + i).length > 0) {
                        return (Integer[])Arrays.stream(tag.m_128465_("mine" + i)).boxed().toArray(Integer[]::new);
                    }
                    return null;
                });
                if (!MineRemoteAccessToolItem.hasMineAdded(stack.m_41783_())) {
                    if (linkingState == 0.5f) {
                        return 0.5f;
                    }
                    return 0.0f;
                }
                return linkingState;
            });
            ItemProperties.register((Item)((Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get()), (ResourceLocation)LINKING_STATE_PROPERTY, (stack, level, entity, id) -> {
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                Entity patt19851$temp = Minecraft.m_91087_().f_91076_;
                if (patt19851$temp instanceof Sentry) {
                    Sentry sentry = (Sentry)patt19851$temp;
                    float linkingState = ClientHandler.loop(12, (tag, i) -> (Integer[])Arrays.stream(tag.m_128465_("sentry" + i)).boxed().toArray(Integer[]::new), stack.m_41784_(), sentry.m_20183_());
                    if (!SentryRemoteAccessToolItem.hasSentryAdded(stack.m_41783_())) {
                        if (linkingState == 0.5f) {
                            return 0.5f;
                        }
                        return 0.0f;
                    }
                    return linkingState;
                }
                return SentryRemoteAccessToolItem.hasSentryAdded(stack.m_41783_()) ? 0.25f : 0.0f;
            });
            ItemProperties.register((Item)((Item)SCContent.SONIC_SECURITY_SYSTEM_ITEM.get()), (ResourceLocation)LINKING_STATE_PROPERTY, (stack, level, entity, id) -> {
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                Player player = (Player)entity;
                float linkingState = ClientHandler.getLinkingState((Level)level, player, stack, bhr -> {
                    IOwnable ownable;
                    BlockEntity patt20748$temp = level.m_7702_(bhr.m_82425_());
                    if (!(patt20748$temp instanceof ILockable)) {
                        return false;
                    }
                    ILockable lockable = (ILockable)patt20748$temp;
                    return lockable instanceof IOwnable && (ownable = (IOwnable)((Object)lockable)).isOwnedBy((Entity)player) || !IDisguisable.getDisguisedBlockState((LevelReader)level, bhr.m_82425_()).isPresent();
                }, 0, null, false, SonicSecuritySystemItem::isAdded);
                if (!SonicSecuritySystemItem.hasLinkedBlock(stack.m_41783_())) {
                    if (linkingState == 0.5f) {
                        return 0.5f;
                    }
                    return 0.0f;
                }
                return linkingState;
            });
            ItemProperties.register((Item)((Item)SCContent.CODEBREAKER.get()), (ResourceLocation)CodebreakerItem.STATE_PROPERTY, (stack, level, entity, id) -> {
                CompoundTag tag = stack.m_41783_();
                boolean isPlayer = entity instanceof Player;
                if ((!isPlayer || !((Player)entity).m_7500_() && !((Player)entity).m_5833_()) && CodebreakerItem.wasRecentlyUsed(stack)) {
                    return tag.m_128471_("was_successful") ? 0.75f : 0.5f;
                }
                if (!isPlayer) {
                    return 0.0f;
                }
                float state = ClientHandler.getLinkingState((Level)level, (Player)entity, stack, bhr -> level.m_7702_(bhr.m_82425_()) instanceof ICodebreakable, 0, null, false, (_tag, pos) -> true);
                if (state == 0.75f || state == 0.5f) {
                    return 0.25f;
                }
                return 0.0f;
            });
        });
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        cameraOverlay = SCClientEventHandler::cameraOverlay;
        event.registerAboveAll("camera_overlay", cameraOverlay);
        OverlayToggleHandler.disable(cameraOverlay);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SCContent.BOUNCING_BETTY_ENTITY.get(), BouncingBettyRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.IMS_BOMB_ENTITY.get(), IMSBombRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SENTRY_ENTITY.get(), SentryRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.BULLET_ENTITY.get(), BulletRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SECURITY_SEA_BOAT_ENTITY.get(), SecuritySeaBoatRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.BLOCK_POCKET_MANAGER_BLOCK_ENTITY.get(), BlockPocketManagerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get(), ClaymoreRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get(), KeypadChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.DISPLAY_CASE_BLOCK_ENTITY.get(), ctx -> new DisplayCaseRenderer(ctx, false));
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.GLOW_DISPLAY_CASE_BLOCK_ENTITY.get(), ctx -> new DisplayCaseRenderer(ctx, true));
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.OWNABLE_BLOCK_ENTITY.get(), OwnableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_LECTERN_BLOCK_ENTITY.get(), LecternRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.PROJECTOR_BLOCK_ENTITY.get(), ProjectorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_PISTON_BLOCK_ENTITY.get(), ReinforcedPistonHeadRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.RETINAL_SCANNER_BLOCK_ENTITY.get(), RetinalScannerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECURE_REDSTONE_INTERFACE_BLOCK_ENTITY.get(), SecureRedstoneInterfaceRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), SecurityCameraRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECRET_HANGING_SIGN_BLOCK_ENTITY.get(), SecretHangingSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECRET_SIGN_BLOCK_ENTITY.get(), SecretSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SONIC_SECURITY_SYSTEM_BLOCK_ENTITY.get(), SonicSecuritySystemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get(), TrophySystemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.BLOCK_CHANGE_DETECTOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.CAGE_TRAP_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.DISGUISABLE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.FLOOR_TRAP_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYCARD_READER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BARREL_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BLAST_FURNACE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_DOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_TRAPDOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_FURNACE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_SMOKER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.PROTECTO_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_DISPENSER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_DROPPER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_HOPPER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.RIFT_STABILIZER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SCANNER_DOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SCANNER_TRAPDOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.USERNAME_LOGGER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BULLET_LOCATION, BulletModel::createLayer);
        event.registerLayerDefinition(IMS_BOMB_LOCATION, IMSBombModel::createLayer);
        event.registerLayerDefinition(DISPLAY_CASE_LOCATION, DisplayCaseRenderer::createModelLayer);
        event.registerLayerDefinition(GLOW_DISPLAY_CASE_LOCATION, DisplayCaseRenderer::createModelLayer);
        event.registerLayerDefinition(SENTRY_LOCATION, SentryModel::createLayer);
        event.registerLayerDefinition(SECURITY_CAMERA_LOCATION, SecurityCameraModel::createLayer);
        event.registerLayerDefinition(SONIC_SECURITY_SYSTEM_LOCATION, SonicSecuritySystemModel::createLayer);
        event.registerLayerDefinition(SECURE_REDSTONE_INTERFACE_DISH_LAYER_LOCATION, SecureRedstoneInterfaceDishModel::createLayer);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SCContent.FLOOR_TRAP_CLOUD.get(), FloorTrapCloudParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SCContent.INTERFACE_HIGHLIGHT.get(), InterfaceHighlightParticle.Provider::new);
    }

    private static void initTint() {
        for (Field field : SCContent.class.getFields()) {
            if (!field.isAnnotationPresent(Reinforced.class)) continue;
            try {
                Block block = (Block)((RegistryObject)field.get(null)).get();
                int customTint = field.getAnnotation(Reinforced.class).customTint();
                if (field.getAnnotation(Reinforced.class).hasReinforcedTint()) {
                    blocksWithReinforcedTint.put(block, customTint);
                    continue;
                }
                if (customTint == 0xFFFFFF) continue;
                blocksWithCustomTint.put(block, customTint);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        int crystalQuartzTint = 1422242;
        blocksWithReinforcedTint.put((Block)SCContent.BLOCK_POCKET_MANAGER.get(), crystalQuartzTint);
        blocksWithReinforcedTint.put((Block)SCContent.BLOCK_POCKET_WALL.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_SLAB.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CHISELED_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_BLOCK.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_BRICKS.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_PILLAR.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_STAIRS.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ_SLAB.get(), crystalQuartzTint);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ_STAIRS.get(), crystalQuartzTint);
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersBlock(RegisterColorHandlersEvent.Block event) {
        ClientHandler.initTint();
        blocksWithReinforcedTint.forEach((block, tint) -> event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(tint);
            }
            return 0xFFFFFF;
        }, new Block[]{block}));
        blocksWithCustomTint.forEach((block, tint) -> event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return tint;
            }
            return 0xFFFFFF;
        }, new Block[]{block}));
        event.register((state, level, pos, tintIndex) -> {
            IDisguisable disguisedBlock;
            Block blockFromItem;
            BlockState defaultBlockState;
            Block block = state.m_60734_();
            if (block instanceof IDisguisable && !(defaultBlockState = (blockFromItem = Block.m_49814_((Item)(disguisedBlock = (IDisguisable)block).getDisguisedStack((BlockGetter)level, pos).m_41720_())).m_49966_()).m_60795_() && !(blockFromItem instanceof IDisguisable)) {
                return Minecraft.m_91087_().m_91298_().m_92577_(defaultBlockState, level, pos, tintIndex);
            }
            if (block instanceof IReinforcedBlock) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(0xFFFFFF);
            }
            return 0xFFFFFF;
        }, disguisableBlocks.get());
        event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 1 && !((Boolean)state.m_61143_((Property)SnowyDirtBlock.f_56637_)).booleanValue()) {
                int grassTint = level != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get();
        }, new Block[]{(Block)SCContent.REINFORCED_GRASS_BLOCK.get()});
        event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return level != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos) : -1;
            }
            return (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get();
        }, new Block[]{(Block)SCContent.REINFORCED_WATER_CAULDRON.get()});
        event.register((state, level, pos, tintIndex) -> {
            Direction direction = LaserFieldBlock.getFieldDirection(state);
            return ClientHandler.iterateFields(level, pos, direction, (Integer)ConfigHandler.SERVER.laserBlockRange.get(), (Block)SCContent.LASER_BLOCK.get(), LaserBlockBlockEntity.class::isInstance, be -> ((LaserBlockBlockEntity)be).getLensContainer().m_8020_(direction.m_122424_().ordinal()));
        }, new Block[]{(Block)SCContent.LASER_FIELD.get()});
        event.register((state, level, pos, tintIndex) -> {
            Direction direction = (Direction)state.m_61143_((Property)InventoryScannerFieldBlock.FACING);
            return ClientHandler.iterateFields(level, pos, direction, (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(), (Block)SCContent.INVENTORY_SCANNER.get(), InventoryScannerBlockEntity.class::isInstance, be -> ((InventoryScannerBlockEntity)be).getLensContainer().m_8020_(0));
        }, new Block[]{(Block)SCContent.INVENTORY_SCANNER_FIELD.get()});
    }

    public static int iterateFields(BlockAndTintGetter level, BlockPos pos, Direction direction, int range, Block block, Predicate<BlockEntity> beTest, Function<BlockEntity, ItemStack> lensGetter) {
        try {
            return ClientHandler.iterateFieldsInternal(level, pos, direction, range, block, beTest, lensGetter);
        }
        catch (Exception e1) {
            direction = direction.m_122424_();
            try {
                return ClientHandler.iterateFieldsInternal(level, pos, direction, range, block, beTest, lensGetter);
            }
            catch (Exception exception) {
                return -1;
            }
        }
    }

    private static int iterateFieldsInternal(BlockAndTintGetter level, BlockPos pos, Direction direction, int range, Block block, Predicate<BlockEntity> beTest, Function<BlockEntity, ItemStack> lensGetter) throws ArrayIndexOutOfBoundsException {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        for (int i = 0; i < range; ++i) {
            BlockEntity be;
            if (level.m_8055_((BlockPos)mutablePos).m_60713_(block) && beTest.test(be = level.m_7702_((BlockPos)mutablePos))) {
                ItemStack stack = lensGetter.apply(be);
                Item item = stack.m_41720_();
                if (!(item instanceof DyeableLeatherItem)) break;
                DyeableLeatherItem lens = (DyeableLeatherItem)item;
                return lens.m_41121_(stack);
            }
            mutablePos.m_122173_(direction);
        }
        return -1;
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersItem(RegisterColorHandlersEvent.Item event) {
        blocksWithReinforcedTint.forEach((item, tint) -> event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(tint);
            }
            return 0xFFFFFF;
        }, new ItemLike[]{item}));
        blocksWithCustomTint.forEach((item, tint) -> event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return tint;
            }
            return 0xFFFFFF;
        }, new ItemLike[]{item}));
        event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                DyeableLeatherItem item = (DyeableLeatherItem)stack.m_41720_();
                if (item.m_41113_(stack)) {
                    return item.m_41121_(stack);
                }
                return 0x333333;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)SCContent.BRIEFCASE.get()});
        event.register((stack, tintIndex) -> {
            DyeableLeatherItem item;
            if (tintIndex == 0 && (item = (DyeableLeatherItem)stack.m_41720_()).m_41113_(stack)) {
                return item.m_41121_(stack);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)SCContent.LENS.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                int grassTint = GrassColor.m_46415_((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get();
        }, new ItemLike[]{(ItemLike)SCContent.REINFORCED_GRASS_BLOCK.get()});
        blocksWithReinforcedTint = null;
        blocksWithCustomTint = null;
    }

    public static int mixWithReinforcedTintIfEnabled(int tint) {
        boolean tintReinforcedBlocks = Minecraft.m_91087_().f_91073_ == null ? ((Boolean)ConfigHandler.CLIENT.reinforcedBlockTint.get()).booleanValue() : ((Boolean)ConfigHandler.SERVER.forceReinforcedBlockTint.get() != false ? (Boolean)ConfigHandler.SERVER.reinforcedBlockTint.get() : (Boolean)ConfigHandler.CLIENT.reinforcedBlockTint.get()).booleanValue();
        return tintReinforcedBlocks ? FastColor.ARGB32.m_13657_((int)tint, (int)((Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get())) : tint;
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static void displayMRATScreen(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new MineRemoteAccessToolScreen(stack));
    }

    public static void displaySRATScreen(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new SentryRemoteAccessToolScreen(stack));
    }

    public static void displayEditModuleScreen(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new EditModuleScreen(stack));
    }

    public static void displayCameraMonitorScreen(Inventory inv, CameraMonitorItem item, CompoundTag stackTag) {
        Minecraft.m_91087_().m_91152_((Screen)new CameraMonitorScreen(inv, item, stackTag));
    }

    public static void displaySCManualScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new SCManualScreen());
    }

    public static void displayEditSecretSignScreen(SecretSignBlockEntity be, boolean isFront) {
        Minecraft.m_91087_().m_91152_((Screen)new SignEditScreen((SignBlockEntity)be, isFront, Minecraft.m_91087_().m_167974_()));
    }

    public static void displayEditSecretHangingSignScreen(SecretHangingSignBlockEntity be, boolean isFront) {
        Minecraft.m_91087_().m_91152_((Screen)new HangingSignEditScreen((SignBlockEntity)be, isFront, Minecraft.m_91087_().m_167974_()));
    }

    public static void displaySonicSecuritySystemScreen(SonicSecuritySystemBlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new SonicSecuritySystemScreen(be));
    }

    public static void displayBriefcasePasscodeScreen(Component title) {
        Minecraft.m_91087_().m_91152_((Screen)new BriefcasePasscodeScreen(title, false));
    }

    public static void displayBriefcaseSetupScreen(Component title) {
        Minecraft.m_91087_().m_91152_((Screen)new BriefcasePasscodeScreen(title, true));
    }

    public static void displayUsernameLoggerScreen(UsernameLoggerBlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new UsernameLoggerScreen(be));
    }

    public static void displayUniversalKeyChangerScreen(BlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new KeyChangerScreen((IPasscodeProtected)be));
    }

    public static void displayUniversalKeyChangerScreen(Entity entity) {
        Minecraft.m_91087_().m_91152_((Screen)new KeyChangerScreen((IPasscodeProtected)entity));
    }

    public static void displayCheckPasscodeScreen(BlockEntity be) {
        Component component;
        if (be instanceof Nameable) {
            Nameable nameable = (Nameable)be;
            component = nameable.m_5446_();
        } else {
            component = Component.m_237115_((String)be.m_58900_().m_60734_().m_7705_());
        }
        Component displayName = component;
        Minecraft.m_91087_().m_91152_((Screen)new CheckPasscodeScreen((IPasscodeProtected)be, displayName));
    }

    public static void displayCheckPasscodeScreen(Entity entity) {
        Minecraft.m_91087_().m_91152_((Screen)new CheckPasscodeScreen((IPasscodeProtected)entity, entity.m_5446_()));
    }

    public static void displaySetPasscodeScreen(BlockEntity be) {
        Component component;
        if (be instanceof Nameable) {
            Nameable nameable = (Nameable)be;
            component = nameable.m_5446_();
        } else {
            component = Component.m_237115_((String)be.m_58900_().m_60734_().m_7705_());
        }
        Component displayName = component;
        Minecraft.m_91087_().m_91152_((Screen)new SetPasscodeScreen((IPasscodeProtected)be, displayName));
    }

    public static void displaySetPasscodeScreen(Entity entity) {
        Minecraft.m_91087_().m_91152_((Screen)new SetPasscodeScreen((IPasscodeProtected)entity, entity.m_5446_()));
    }

    public static void displaySSSItemScreen(ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new SSSItemScreen(stack));
    }

    public static void displayRiftStabilizerScreen(RiftStabilizerBlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new RiftStabilizerScreen(be));
    }

    public static void displaySecureRedstoneInterfaceScreen(SecureRedstoneInterfaceBlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new SecureRedstoneInterfaceScreen(be));
    }

    public static void displayAlarmScreen(AlarmBlockEntity be) {
        Minecraft.m_91087_().m_91152_((Screen)new AlarmScreen(be, be.getSound().m_11660_()));
    }

    public static void refreshModelData(BlockEntity be) {
        BlockPos pos = be.m_58899_();
        Minecraft.m_91087_().f_91073_.getModelDataManager().requestRefresh(be);
        Minecraft.m_91087_().f_91060_.m_109494_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static boolean isPlayerMountedOnCamera() {
        return Minecraft.m_91087_().f_91075_ instanceof SecurityCamera;
    }

    public static void putDisguisedBeRenderer(BlockEntity disguisableBlockEntity, ItemStack stack) {
        DISGUISED_BLOCK_RENDER_DELEGATE.putDelegateFor(disguisableBlockEntity, NbtUtils.m_247651_((HolderGetter)disguisableBlockEntity.m_58904_().m_246945_(Registries.f_256747_), (CompoundTag)stack.m_41784_().m_128469_("SavedState")));
    }

    public static void updateBlockColorAroundPosition(BlockPos pos) {
        Minecraft.m_91087_().f_91060_.m_109544_((BlockGetter)Minecraft.m_91087_().f_91073_, pos, null, null, 0);
    }

    private static float getLinkingState(Level level, Player player, ItemStack stackInHand, Predicate<BlockHitResult> isValidHitResult, int tagSize, BiFunction<CompoundTag, Integer, Integer[]> getCoords) {
        return ClientHandler.getLinkingState(level, player, stackInHand, isValidHitResult, tagSize, getCoords, true, null);
    }

    protected static float getLinkingState(Level level, Player player, ItemStack stackInHand, Predicate<BlockHitResult> isValidHitResult, int tagSize, BiFunction<CompoundTag, Integer, Integer[]> getCoords, boolean loop, BiPredicate<CompoundTag, BlockPos> useCheckmark) {
        BlockHitResult hitResult;
        double reachDistance = player.getBlockReach();
        double eyeHeight = player.m_20192_();
        Vec3 lookVec = new Vec3(player.m_20185_() + player.m_20154_().f_82479_ * reachDistance, eyeHeight + player.m_20186_() + player.m_20154_().f_82480_ * reachDistance, player.m_20189_() + player.m_20154_().f_82481_ * reachDistance);
        if (level != null && (hitResult = level.m_45547_(new ClipContext(new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_()), lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player))) != null && hitResult.m_6662_() == HitResult.Type.BLOCK && isValidHitResult.test(hitResult)) {
            if (loop) {
                return ClientHandler.loop(tagSize, getCoords, stackInHand.m_41784_(), hitResult.m_82425_());
            }
            return useCheckmark.test(stackInHand.m_41784_(), hitResult.m_82425_()) ? 0.75f : 0.5f;
        }
        return 0.25f;
    }

    private static float loop(int tagSize, BiFunction<CompoundTag, Integer, Integer[]> getCoords, CompoundTag tag, BlockPos pos) {
        for (int i = 1; i <= tagSize; ++i) {
            Integer[] coords = getCoords.apply(tag, i);
            if (coords == null || coords.length != 3 || coords[0].intValue() != pos.m_123341_() || coords[1].intValue() != pos.m_123342_() || coords[2].intValue() != pos.m_123343_()) continue;
            return 0.75f;
        }
        return 0.5f;
    }

    static {
        blocksWithReinforcedTint = new HashMap<Block, Integer>();
        blocksWithCustomTint = new HashMap<Block, Integer>();
        disguisableBlocks = Suppliers.memoize(() -> new Block[]{(Block)SCContent.BLOCK_CHANGE_DETECTOR.get(), (Block)SCContent.CAGE_TRAP.get(), (Block)SCContent.FLOOR_TRAP.get(), (Block)SCContent.INVENTORY_SCANNER.get(), (Block)SCContent.KEYCARD_READER.get(), (Block)SCContent.KEYPAD.get(), (Block)SCContent.KEYPAD_BARREL.get(), (Block)SCContent.KEYPAD_BLAST_FURNACE.get(), (Block)SCContent.KEYPAD_CHEST.get(), (Block)SCContent.KEYPAD_DOOR.get(), (Block)SCContent.KEYPAD_FURNACE.get(), (Block)SCContent.KEYPAD_SMOKER.get(), (Block)SCContent.KEYPAD_TRAPDOOR.get(), (Block)SCContent.LASER_BLOCK.get(), (Block)SCContent.PROJECTOR.get(), (Block)SCContent.PROTECTO.get(), (Block)SCContent.REINFORCED_DISPENSER.get(), (Block)SCContent.REINFORCED_DROPPER.get(), (Block)SCContent.REINFORCED_HOPPER.get(), (Block)SCContent.REINFORCED_OBSERVER.get(), (Block)SCContent.RETINAL_SCANNER.get(), (Block)SCContent.RIFT_STABILIZER.get(), (Block)SCContent.SCANNER_DOOR.get(), (Block)SCContent.SCANNER_TRAPDOOR.get(), (Block)SCContent.SECURITY_CAMERA.get(), (Block)SCContent.SECURE_REDSTONE_INTERFACE.get(), (Block)SCContent.SENTRY_DISGUISE.get(), (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), (Block)SCContent.TROPHY_SYSTEM.get(), (Block)SCContent.USERNAME_LOGGER.get()});
        TASER_ARM_POSE = HumanoidModel.ArmPose.create((String)"securitycraft_taser", (boolean)true, (model, entity, arm) -> {
            ModelPart leftArm = model.f_102812_;
            ModelPart rightArm = model.f_102811_;
            leftArm.f_104204_ = 0.5f;
            rightArm.f_104204_ = -0.5f;
            rightArm.f_104203_ = -1.5f;
            leftArm.f_104203_ = -1.5f;
        });
        LINKING_STATE_PROPERTY = new ResourceLocation("securitycraft", "linking_state");
    }
}

