/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface ICodebreakable {
    public boolean shouldAttemptCodebreak(Player var1);

    public void useCodebreaker(Player var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean handleCodebreaking(Player player, InteractionHand hand) {
        double chance = (Double)ConfigHandler.SERVER.codebreakerChance.get();
        if (chance < 0.0) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.CODEBREAKER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
            return true;
        } else {
            IOwnable ownable;
            if (!this.shouldAttemptCodebreak(player)) {
                return false;
            }
            ItemStack codebreaker = player.m_21120_(hand);
            if (!codebreaker.m_150930_((Item)SCContent.CODEBREAKER.get())) return false;
            boolean canBypass = player.m_7500_() || player.m_5833_();
            ICodebreakable iCodebreakable = this;
            if (iCodebreakable instanceof IOwnable && (ownable = (IOwnable)((Object)iCodebreakable)).isOwnedBy((Entity)player) && !canBypass) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.CODEBREAKER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:codebreaker.owned", new Object[0]), ChatFormatting.RED);
                return false;
            }
            if (!canBypass && CodebreakerItem.wasRecentlyUsed(codebreaker)) {
                return false;
            }
            boolean isSuccessful = canBypass || SecurityCraft.RANDOM.nextDouble() < chance;
            CompoundTag tag = codebreaker.m_41784_();
            if (!canBypass) {
                codebreaker.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            tag.m_128356_("last_used_time", System.currentTimeMillis());
            tag.m_128379_("was_successful", isSuccessful);
            if (isSuccessful) {
                this.useCodebreaker(player);
                return true;
            } else {
                PlayerUtils.sendMessageToPlayer(player, Component.m_237115_((String)((Item)SCContent.CODEBREAKER.get()).m_5524_()), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                return false;
            }
        }
    }
}

