/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.network.PacketDistributor;

public class DisguisableBlockEntity
extends CustomizableBlockEntity {
    public DisguisableBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.DISGUISABLE_BLOCK_ENTITY.get(), pos, state);
    }

    public DisguisableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted(this, stack, toggled);
        }
    }

    public static void onDisguiseModuleInserted(BlockEntity be, ItemStack stack, boolean toggled) {
        BlockState state = be.m_58900_();
        Level level = be.m_58904_();
        BlockPos worldPosition = be.m_58899_();
        if (!level.f_46443_) {
            SecurityCraft.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(worldPosition)), (Object)new RefreshDisguisableModel(worldPosition, true, stack, toggled));
            if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                level.m_186469_(worldPosition, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
                level.m_46672_(worldPosition, state.m_60734_());
            }
        } else {
            ClientHandler.putDisguisedBeRenderer(be, stack);
            if (state.getLightEmission((BlockGetter)level, worldPosition) > 0) {
                level.m_7726_().m_7827_().m_7174_(worldPosition);
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved(this, stack, toggled);
        }
    }

    public static void onDisguiseModuleRemoved(BlockEntity be, ItemStack stack, boolean toggled) {
        Level level = be.m_58904_();
        BlockPos worldPosition = be.m_58899_();
        if (!level.f_46443_) {
            BlockState state = be.m_58900_();
            SecurityCraft.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(worldPosition)), (Object)new RefreshDisguisableModel(worldPosition, false, stack, toggled));
            if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                level.m_186469_(worldPosition, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
                level.m_46672_(worldPosition, state.m_60734_());
            }
        } else {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
            IDisguisable.getDisguisedBlockStateFromStack(level, stack).ifPresent(disguisedState -> {
                if (disguisedState.getLightEmission((BlockGetter)level, worldPosition) > 0) {
                    level.m_7726_().m_7827_().m_7174_(worldPosition);
                }
            });
        }
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public static <T extends BlockEntity> void onHandleUpdateTag(T be) {
        Level level = be.m_58904_();
        if (level != null && level.f_46443_) {
            ItemStack stack = ((IModuleInventory)be).getModule(ModuleType.DISGUISE);
            if (!stack.m_41619_()) {
                ClientHandler.putDisguisedBeRenderer(be, stack);
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        DisguisableBlockEntity.onSetRemoved(this);
    }

    public static void onSetRemoved(BlockEntity be) {
        if (be.m_58904_().f_46443_) {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[0];
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData(this);
    }

    public static ModelData getModelData(BlockEntity be) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(Blocks.f_50016_.m_49966_(), (BlockGetter)be.m_58904_(), be.m_58899_());
        return ModelData.builder().with(DisguisableDynamicBakedModel.DISGUISED_STATE, (Object)disguisedState).build();
    }
}

