/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.Collection;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SecureRedstoneInterfaceBlock;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.particle.InterfaceHighlightParticleOptions;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SecureRedstoneInterfaceBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity {
    public static final Vector3f SENDER_PARTICLE_COLOR = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f RECEIVER_PARTICLE_COLOR = new Vector3f(1.0f, 1.0f, 0.0f);
    public static final Vector3f RECEIVER_PARTICLE_COLOR_NO_SIGNAL = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f RECEIVER_PROTECTED_PARTICLE_COLOR = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f RECEIVER_PROTECTED_PARTICLE_COLOR_NO_SIGNAL = new Vector3f(0.0f, 0.0f, 0.0f);
    public final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private boolean tracked = false;
    private boolean refreshed = false;
    private boolean sender = true;
    private int power = 0;
    private int frequency = 0;
    private int senderRange = 24;
    private boolean protectedSignal = false;
    private boolean sendExactPower = true;
    private boolean receiveInvertedPower = false;
    private boolean highlightConnections = false;
    private float dishRotationDegrees = 0.0f;
    private float oDishRotationDegrees = 0.0f;
    private boolean changed = false;
    private boolean updateNeighbors = false;

    public SecureRedstoneInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SECURE_REDSTONE_INTERFACE_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_) {
            Collection<ServerPlayer> players;
            if (!this.tracked) {
                if (this.isSender()) {
                    this.refreshPower();
                }
                BlockEntityTracker.SECURE_REDSTONE_INTERFACE.track(this);
                this.tracked = true;
            } else if (!this.refreshed) {
                this.refreshed = true;
                if (this.isSender()) {
                    this.tellSimilarReceiversToRefresh();
                }
            }
            if (this.changed) {
                level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
                this.changed = false;
            }
            if (this.updateNeighbors) {
                BlockUtils.updateIndirectNeighbors(level, this.f_58858_, this.m_58900_().m_60734_(), ((Direction)this.m_58900_().m_61143_((Property)SecureRedstoneInterfaceBlock.FACING)).m_122424_());
                this.updateNeighbors = false;
            }
            if (this.shouldHighlightConnections() && level.m_46467_() % 5L == 0L && !(players = TeamUtils.getOnlinePlayersFromOwner(level.m_7654_(), this.getOwner())).isEmpty()) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 myPos = Vec3.m_82512_((Vec3i)pos);
                if (this.isSender()) {
                    for (SecureRedstoneInterfaceBlockEntity be : this.getReceiversISendTo()) {
                        if (be.isDisabled()) continue;
                        Vec3 receiverPos = Vec3.m_82512_((Vec3i)be.f_58858_);
                        this.showParticleTrail(players, serverLevel, myPos, receiverPos, SENDER_PARTICLE_COLOR);
                    }
                } else {
                    for (SecureRedstoneInterfaceBlockEntity be : this.getSendersThatSendToMe()) {
                        Vec3 senderPos = Vec3.m_82512_((Vec3i)be.f_58858_);
                        Vector3f color = be.getPower() == 0 ? (be.isProtectedSignal() ? RECEIVER_PROTECTED_PARTICLE_COLOR_NO_SIGNAL : RECEIVER_PARTICLE_COLOR_NO_SIGNAL) : (be.isProtectedSignal() ? RECEIVER_PROTECTED_PARTICLE_COLOR : RECEIVER_PARTICLE_COLOR);
                        this.showParticleTrail(players, serverLevel, senderPos, myPos, color);
                    }
                }
            }
        } else {
            this.oDishRotationDegrees = this.dishRotationDegrees;
            if (!this.isDisabled()) {
                this.dishRotationDegrees = this.oDishRotationDegrees + 0.05f;
                if (this.dishRotationDegrees >= 360.0f) {
                    this.dishRotationDegrees = 0.0f;
                }
            }
        }
    }

    public void showParticleTrail(Collection<ServerPlayer> players, ServerLevel level, Vec3 senderPos, Vec3 receiverPos, Vector3f color) {
        Vec3 senderToReceiver = receiverPos.m_82546_(senderPos);
        Vector3f particleDirection = senderToReceiver.m_82541_().m_82490_((double)0.01f).m_252839_();
        double step = senderToReceiver.m_82553_() * 6.0;
        int i = 0;
        while ((double)i < step) {
            Vec3 particlePos = receiverPos.m_165921_(senderPos, (double)i / step);
            for (ServerPlayer player : players) {
                level.m_8624_(player, (ParticleOptions)new InterfaceHighlightParticleOptions(new Vector3f(color.x, color.y, color.z), particleDirection, 1.0f), false, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            ++i;
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (!this.f_58857_.f_46443_) {
            BlockEntityTracker.SECURE_REDSTONE_INTERFACE.stopTracking(this);
        }
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
        if (this.isSender()) {
            int currentFrequency = this.getFrequency();
            int range = this.getSenderRange();
            this.tellSimilarReceiversToRefresh(oldOwner, currentFrequency, range);
        } else {
            this.setPower(0);
        }
    }

    @Override
    public boolean needsValidation() {
        return true;
    }

    @Override
    public void onValidate() {
        this.refreshPower();
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.disabled) {
            if (this.isDisabled()) {
                this.setPower(0);
            } else {
                this.refreshPower();
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.sender = tag.m_128471_("sender");
        this.power = tag.m_128451_("power");
        this.frequency = tag.m_128451_("frequency");
        this.senderRange = tag.m_128451_("sender_range");
        this.protectedSignal = tag.m_128471_("protected_signal");
        this.sendExactPower = tag.m_128471_("send_exact_power");
        this.receiveInvertedPower = tag.m_128471_("receive_inverted_power");
        this.highlightConnections = tag.m_128471_("highlight_connections");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("sender", this.sender);
        tag.m_128405_("power", this.power);
        tag.m_128405_("frequency", this.frequency);
        tag.m_128405_("sender_range", this.senderRange);
        tag.m_128379_("protected_signal", this.protectedSignal);
        tag.m_128379_("send_exact_power", this.sendExactPower);
        tag.m_128379_("receive_inverted_power", this.receiveInvertedPower);
        tag.m_128379_("highlight_connections", this.highlightConnections);
    }

    public boolean isSender() {
        return this.sender;
    }

    public void setSender(boolean sender) {
        if (this.isSender() == sender || !this.getOwner().isValidated()) {
            return;
        }
        this.sender = sender;
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecureRedstoneInterfaceBlock.SENDER, (Comparable)Boolean.valueOf(sender)));
            this.m_6596_();
            if (!this.isDisabled()) {
                this.tellSimilarReceiversToRefresh();
            }
            this.updateNeighbors();
        }
    }

    public int getPower() {
        return this.power;
    }

    public void refreshPower() {
        this.refreshPower(this.getFrequency());
    }

    public void refreshPower(int frequency) {
        if (this.f_58857_.f_46443_ || this.isDisabled() || !this.getOwner().isValidated()) {
            return;
        }
        if (this.isSender()) {
            int bestSignal = this.isProtectedSignal() ? (BlockUtils.hasActiveSCBlockNextTo(this.f_58857_, this.f_58858_) ? 15 : 0) : this.f_58857_.m_277086_(this.f_58858_);
            if (this.sendsExactPower()) {
                this.setPower(bestSignal);
            } else {
                this.setPower(bestSignal > 0 ? 15 : 0);
            }
        } else {
            int highestPower = 0;
            boolean protectedSignal = true;
            boolean foundSender = false;
            for (SecureRedstoneInterfaceBlockEntity be : this.getSendersThatSendToMe(frequency)) {
                int ownPower = be.getPower();
                foundSender = true;
                if (ownPower > highestPower) {
                    highestPower = ownPower;
                }
                if (!be.isProtectedSignal()) {
                    protectedSignal = false;
                }
                if (highestPower != 15 || protectedSignal) continue;
                break;
            }
            if (!foundSender) {
                protectedSignal = false;
            }
            if (this.receivesInvertedPower()) {
                highestPower = 15 - highestPower;
            }
            if (this.protectedSignal != protectedSignal) {
                this.protectedSignal = protectedSignal;
                this.updateNeighbors();
            }
            this.setPower(highestPower);
        }
    }

    public void setPower(int power) {
        if (this.getPower() == power) {
            return;
        }
        this.power = power;
        if (!this.f_58857_.f_46443_) {
            if (this.isSender()) {
                this.tellSimilarReceiversToRefresh();
            }
            this.m_6596_();
            this.updateNeighbors();
        }
    }

    public int getRedstonePowerOutput() {
        if (!this.isSender() && !this.isDisabled()) {
            return this.getPower();
        }
        return 0;
    }

    public boolean isProtectedSignal() {
        return this.protectedSignal;
    }

    public void setProtectedSignal(boolean protectedSignal) {
        if (this.isProtectedSignal() == protectedSignal || !this.getOwner().isValidated()) {
            return;
        }
        this.protectedSignal = protectedSignal;
        if (!this.f_58857_.f_46443_) {
            this.refreshPower();
            if (this.isSender()) {
                this.tellSimilarReceiversToRefresh();
            } else {
                this.updateNeighbors();
            }
            this.m_6596_();
        }
    }

    public boolean sendsExactPower() {
        return this.sendExactPower;
    }

    public void setSendExactPower(boolean sendExactPower) {
        if (this.sendsExactPower() == sendExactPower || !this.getOwner().isValidated()) {
            return;
        }
        this.sendExactPower = sendExactPower;
        if (!this.f_58857_.f_46443_ && this.isSender()) {
            this.refreshPower();
            this.m_6596_();
            this.updateNeighbors();
        }
    }

    public boolean receivesInvertedPower() {
        return this.receiveInvertedPower;
    }

    public void setReceiveInvertedPower(boolean receiveInvertedPower) {
        if (this.receivesInvertedPower() == receiveInvertedPower || !this.getOwner().isValidated()) {
            return;
        }
        this.receiveInvertedPower = receiveInvertedPower;
        if (!this.f_58857_.f_46443_ && !this.isSender()) {
            this.refreshPower();
            this.m_6596_();
            this.updateNeighbors();
        }
    }

    public void tellSimilarReceiversToRefresh() {
        this.tellSimilarReceiversToRefresh(this.getOwner(), this.getFrequency(), this.getSenderRange());
    }

    public void tellSimilarReceiversToRefresh(Owner owner, int frequency, int range) {
        if (!this.f_58857_.f_46443_ && this.getOwner().isValidated()) {
            for (SecureRedstoneInterfaceBlockEntity be : this.getReceiversToSendTo(owner, frequency, range)) {
                be.refreshPower(frequency);
            }
        }
    }

    public void setFrequency(int frequency) {
        int oldFrequency = this.getFrequency();
        if (oldFrequency == frequency || !this.getOwner().isValidated()) {
            return;
        }
        this.frequency = frequency;
        if (!this.f_58857_.f_46443_) {
            Owner owner = this.getOwner();
            int range = this.getSenderRange();
            if (this.isSender()) {
                this.tellSimilarReceiversToRefresh(owner, oldFrequency, range);
                this.tellSimilarReceiversToRefresh(owner, frequency, range);
            } else {
                this.refreshPower();
            }
            this.m_6596_();
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean isSameFrequency(int frequency) {
        return this.getFrequency() == frequency;
    }

    public void setSenderRange(int senderRange) {
        senderRange = Mth.m_14045_((int)senderRange, (int)1, (int)64);
        if (this.getSenderRange() == senderRange || !this.getOwner().isValidated()) {
            return;
        }
        int oldRange = this.senderRange;
        this.senderRange = senderRange;
        if (!this.f_58857_.f_46443_ && !this.isDisabled() && this.isSender()) {
            Owner owner = this.getOwner();
            int frequency = this.getFrequency();
            this.tellSimilarReceiversToRefresh(owner, frequency, Math.max(oldRange, senderRange));
            this.m_6596_();
        }
    }

    public List<SecureRedstoneInterfaceBlockEntity> getReceiversISendTo() {
        return this.getReceiversToSendTo(this.getOwner(), this.getFrequency(), this.getSenderRange());
    }

    public List<SecureRedstoneInterfaceBlockEntity> getReceiversToSendTo(Owner owner, int frequency, int range) {
        List<SecureRedstoneInterfaceBlockEntity> all = BlockEntityTracker.SECURE_REDSTONE_INTERFACE.getBlockEntitiesAround(this.f_58857_, this.f_58858_, range);
        all.removeIf(be -> be.isSender() || !be.isOwnedBy(owner) || !be.isSameFrequency(frequency));
        return all;
    }

    public List<SecureRedstoneInterfaceBlockEntity> getSendersThatSendToMe() {
        return this.getSendersThatSendToMe(this.getFrequency());
    }

    public List<SecureRedstoneInterfaceBlockEntity> getSendersThatSendToMe(int frequency) {
        List<SecureRedstoneInterfaceBlockEntity> all = BlockEntityTracker.SECURE_REDSTONE_INTERFACE.getBlockEntitiesInRange(this.f_58857_, this.f_58858_);
        all.removeIf(be -> be.isDisabled() || !be.isSender() || !be.isOwnedBy(this.getOwner()) || !be.isSameFrequency(frequency));
        return all;
    }

    public int getSenderRange() {
        return this.senderRange;
    }

    public boolean shouldHighlightConnections() {
        return this.highlightConnections;
    }

    public void setHighlightConnections(boolean highlightConnections) {
        this.highlightConnections = highlightConnections;
        this.m_6596_();
    }

    public void updateNeighbors() {
        this.updateNeighbors = true;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled};
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE};
    }

    public float getOriginalDishRotationDegrees() {
        return this.oDishRotationDegrees;
    }

    public float getDishRotationDegrees() {
        return this.dishRotationDegrees;
    }

    public void m_6596_() {
        this.changed = true;
        super.m_6596_();
    }
}

