/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.SingleLensMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SecurityCameraBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
IEMPAffectedBE,
MenuProvider,
ContainerListener,
SingleLensMenu.SingleLensContainer {
    private double cameraRotation = 0.0;
    private double oCameraRotation = 0.0;
    private boolean addToRotation = SecurityCraft.RANDOM.nextBoolean();
    private boolean down = false;
    private boolean initialized = false;
    private int playersViewing = 0;
    private boolean shutDown = false;
    private float initialXRotation;
    private float initialYRotation;
    private float initialZoom = 1.0f;
    private Option.DoubleOption rotationSpeedOption = new Option.DoubleOption("rotationSpeed", 0.018, 0.01, 0.025, 0.001);
    private Option.DoubleOption movementSpeedOption = new Option.DoubleOption("movementSpeed", 2.0, 0.0, 20.0, 0.1);
    private Option.BooleanOption shouldRotateOption = new Option.BooleanOption("shouldRotate", true);
    private Option.DoubleOption customRotationOption = new Option.DoubleOption("customRotation", this.getCameraRotation(), 1.55, -1.55, (Double)this.rotationSpeedOption.get());
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IntOption opacity = new Option.IntOption("opacity", 100, 0, 255, 1);
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private LazyOptional<IItemHandler> lensHandler;
    private LensContainer lens = new LensContainer(1);

    public SecurityCameraBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), pos, state);
        this.lens.m_19164_(this);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.initialized) {
            Direction facing = (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING);
            this.initialized = true;
            boolean bl = this.down = facing == Direction.DOWN;
            if (!this.isModuleEnabled(ModuleType.SMART)) {
                this.setDefaultViewingDirection(facing, this.initialZoom);
            }
        }
        this.oCameraRotation = this.getCameraRotation();
        if (!this.shutDown && !((Boolean)this.disabled.get()).booleanValue()) {
            if (!((Boolean)this.shouldRotateOption.get()).booleanValue()) {
                this.cameraRotation = (Double)this.customRotationOption.get();
                return;
            }
            if (this.addToRotation && this.getCameraRotation() <= (double)1.55f) {
                this.cameraRotation = this.getCameraRotation() + (Double)this.rotationSpeedOption.get();
            } else {
                this.addToRotation = false;
            }
            if (!this.addToRotation && this.getCameraRotation() >= (double)-1.55f) {
                this.cameraRotation = this.getCameraRotation() - (Double)this.rotationSpeedOption.get();
            } else {
                this.addToRotation = true;
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("shutDown", this.shutDown);
        tag.m_128365_("lens", (Tag)this.lens.m_7927_());
        tag.m_128350_("initial_x_rotation", this.initialXRotation);
        tag.m_128350_("initial_y_rotation", this.initialYRotation);
        tag.m_128350_("initial_zoom", this.initialZoom);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.shutDown = tag.m_128471_("shutDown");
        this.lens.m_7797_(tag.m_128437_("lens", 10));
        this.initialXRotation = tag.m_128457_("initial_x_rotation");
        this.initialYRotation = tag.m_128457_("initial_y_rotation");
        if (tag.m_128441_("initial_zoom")) {
            this.initialZoom = tag.m_128457_("initial_zoom");
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return BlockUtils.isAllowedToExtractFromProtectedObject(side, this) ? this.getNormalHandler().cast() : this.getInsertOnlyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.insertOnlyHandler != null) {
            this.insertOnlyHandler.invalidate();
        }
        if (this.lensHandler != null) {
            this.lensHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.insertOnlyHandler = null;
        this.lensHandler = null;
        super.reviveCaps();
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((Container)this.lens));
        }
        return this.insertOnlyHandler;
    }

    private LazyOptional<IItemHandler> getNormalHandler() {
        if (this.lensHandler == null) {
            this.lensHandler = LazyOptional.of(() -> new InvWrapper((Container)this.lens));
        }
        return this.lensHandler;
    }

    public void m_5757_(Container container) {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new SingleLensMenu(id, this.f_58857_, this.f_58858_, inventory);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @Override
    public Container getLensContainer() {
        return this.lens;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.rotationSpeedOption, this.shouldRotateOption, this.customRotationOption, this.disabled, this.opacity, this.movementSpeedOption};
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        } else if (module == ModuleType.SMART) {
            this.setDefaultViewingDirection((Direction)this.m_58900_().m_61143_((Property)SecurityCameraBlock.FACING), this.initialZoom);
        }
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option.getName().equals("disabled") && !this.f_58857_.f_46443_ && ((Boolean)((Option.BooleanOption)option).get()).booleanValue()) {
            for (ServerPlayer player : ((ServerLevel)this.f_58857_).m_6907_()) {
                SecurityCamera camera;
                Entity entity = player.m_8954_();
                if (!(entity instanceof SecurityCamera) || !(camera = (SecurityCamera)entity).m_20183_().equals((Object)this.f_58858_)) continue;
                camera.stopViewing(player);
            }
        }
        super.onOptionChanged(option);
    }

    @Override
    public void shutDown() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        IEMPAffectedBE.super.shutDown();
        if (state.m_60734_() == SCContent.SECURITY_CAMERA.get() && ((Boolean)state.m_61143_((Property)SecurityCameraBlock.POWERED)).booleanValue()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public void startViewing() {
        if (this.playersViewing++ == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void stopViewing() {
        if (--this.playersViewing == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public double getCameraRotation() {
        return this.cameraRotation;
    }

    public double getOriginalCameraRotation() {
        return this.oCameraRotation;
    }

    public boolean isDown() {
        return this.down;
    }

    public int getOpacity() {
        return (Integer)this.opacity.get();
    }

    public double getMovementSpeed() {
        return (Double)this.movementSpeedOption.get();
    }

    public void setDefaultViewingDirection(Direction facing, float zoom) {
        float f = this.down ? 75.0f : 30.0f;
        this.setDefaultViewingDirection(f, switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.EAST -> 270.0f;
            case Direction.DOWN, Direction.UP -> 0.0f;
        }, zoom);
    }

    public void setDefaultViewingDirection(float initialXRotation, float initialYRotation, float initialZoom) {
        this.initialXRotation = initialXRotation;
        this.initialYRotation = initialYRotation;
        this.initialZoom = initialZoom;
        this.m_6596_();
    }

    public float getInitialXRotation() {
        return this.initialXRotation;
    }

    public float getInitialYRotation() {
        return this.initialYRotation;
    }

    public float getInitialZoom() {
        return this.initialZoom;
    }
}

