/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.GlowDisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DisplayCaseBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.f_61376_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape FLOOR = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    public static final VoxelShape CEILING = Block.m_49796_((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape WALL_N = Block.m_49796_((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0, (double)16.0);
    public static final VoxelShape WALL_E = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0);
    public static final VoxelShape WALL_S = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)6.0);
    public static final VoxelShape WALL_W = Block.m_49796_((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private final boolean glowing;

    public DisplayCaseBlock(BlockBehaviour.Properties properties, boolean glowing) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(ATTACH_FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.glowing = glowing;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.m_61143_(ATTACH_FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> FLOOR;
            case AttachFace.CEILING -> CEILING;
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        yield WALL_N;
                    }
                    case EAST: {
                        yield WALL_E;
                    }
                    case SOUTH: {
                        yield WALL_S;
                    }
                    case WEST: {
                        yield WALL_W;
                    }
                }
                yield Shapes.m_83040_();
            }
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        for (Direction direction : ctx.m_6232_()) {
            BlockState state = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACH_FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACH_FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!state.m_60710_((LevelReader)level, pos)) continue;
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = this.getConnectedDirection(state).m_122424_();
        BlockPos relativePos = pos.m_121945_(direction);
        return level.m_8055_(relativePos).m_60783_((BlockGetter)level, relativePos, direction.m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof DisplayCaseBlockEntity) {
            DisplayCaseBlockEntity be = (DisplayCaseBlockEntity)blockEntity;
            ItemStack heldStack = player.m_21120_(hand);
            if (be.isLocked() && be.disableInteractionWhenLocked(level, pos, player)) {
                MutableComponent blockName = Utils.localize(this.m_7705_(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
                return InteractionResult.SUCCESS;
            }
            if (be.isOpen()) {
                ItemStack displayedStack = be.getDisplayedStack();
                if (displayedStack.m_41619_()) {
                    if (!heldStack.m_41619_()) {
                        ItemStack toAdd;
                        if (player.m_7500_()) {
                            toAdd = heldStack.m_41777_();
                            toAdd.m_41764_(1);
                        } else {
                            toAdd = heldStack.m_41620_(1);
                        }
                        be.setDisplayedStack(toAdd);
                        level.m_5594_(null, pos, this.glowing ? SoundEvents.f_144154_ : SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResult.SUCCESS;
                    }
                } else if (player.m_6144_()) {
                    player.m_36356_(displayedStack);
                    level.m_5594_(null, pos, this.glowing ? SoundEvents.f_144157_ : SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    be.setDisplayedStack(ItemStack.f_41583_);
                    return InteractionResult.SUCCESS;
                }
                be.setOpen(false);
            } else if (be.isDisabled()) {
                player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(be);
                } else if (!player.m_21120_(hand).m_150930_((Item)SCContent.CODEBREAKER.get())) {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(DisplayCaseBlockEntity be) {
        be.setOpen(true);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof DisplayCaseBlockEntity) {
                DisplayCaseBlockEntity displayCase = (DisplayCaseBlockEntity)be;
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)displayCase.getDisplayedStack());
            }
            if (be instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)be;
                inv.dropAllModules();
            }
            if (be instanceof IPasscodeProtected) {
                IPasscodeProtected passcodeProtected = (IPasscodeProtected)be;
                SaltData.removeSalt(passcodeProtected.getSaltKey());
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getConnectedDirection(state).m_122424_() == facing && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        DisplayCaseBlockEntity be;
        ItemStack displayedStack;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DisplayCaseBlockEntity && !(displayedStack = (be = (DisplayCaseBlockEntity)blockEntity).getDisplayedStack()).m_41619_() && be.isOpen() && !Screen.m_96637_()) {
            return displayedStack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.glowing ? new GlowDisplayCaseBlockEntity(pos, state) : new DisplayCaseBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            if (this.glowing) {
                return DisplayCaseBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.GLOW_DISPLAY_CASE_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
            }
            return DisplayCaseBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.DISPLAY_CASE_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ATTACH_FACE, WATERLOGGED});
    }

    private Direction getConnectedDirection(BlockState state) {
        return switch ((AttachFace)state.m_61143_(ATTACH_FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)state.m_61143_((Property)FACING);
        };
    }
}

