/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.blockentities.PanicButtonBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PanicButtonBlock
extends ButtonBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape FLOOR_NS_POWERED = Block.m_49796_((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0);
    private static final VoxelShape FLOOR_NS_UNPOWERED = Block.m_49796_((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)2.0, (double)11.0);
    private static final VoxelShape FLOOR_EW_POWERED = Block.m_49796_((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)13.0);
    private static final VoxelShape FLOOR_EW_UNPOWERED = Block.m_49796_((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)2.0, (double)13.0);
    private static final VoxelShape WALL_N_POWERED = Block.m_49796_((double)3.0, (double)5.0, (double)15.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_N_UNPOWERED = Block.m_49796_((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_S_POWERED = Block.m_49796_((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)1.0);
    private static final VoxelShape WALL_S_UNPOWERED = Block.m_49796_((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)2.0);
    private static final VoxelShape WALL_E_POWERED = Block.m_49796_((double)0.0, (double)5.0, (double)3.0, (double)1.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_E_UNPOWERED = Block.m_49796_((double)0.0, (double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_POWERED = Block.m_49796_((double)15.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_UNPOWERED = Block.m_49796_((double)14.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape CEILING_NS_POWERED = Block.m_49796_((double)3.0, (double)15.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_NS_UNPOWERED = Block.m_49796_((double)3.0, (double)14.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_EW_POWERED = Block.m_49796_((double)5.0, (double)15.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);
    private static final VoxelShape CEILING_EW_UNPOWERED = Block.m_49796_((double)5.0, (double)14.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);

    public PanicButtonBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType, int ticksToStayPressed, boolean arrowsCanPush) {
        super(properties, blockSetType, ticksToStayPressed, arrowsCanPush);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState superState = super.m_5573_(ctx);
        if (superState != null) {
            return (BlockState)superState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        PanicButtonBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PanicButtonBlockEntity && ((be = (PanicButtonBlockEntity)blockEntity).isOwnedBy((Entity)player) || be.isAllowed((Entity)player))) {
            boolean newPowered = (Boolean)state.m_61143_((Property)f_51045_) == false;
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)f_51045_, (Comparable)Boolean.valueOf(newPowered)));
            this.m_51067_(player, (LevelAccessor)level, pos, newPowered);
            this.notifyNeighbors(level, pos, switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
                default -> throw new IncompatibleClassChangeError();
                case AttachFace.WALL -> (Direction)state.m_61143_((Property)f_54117_);
                case AttachFace.CEILING -> Direction.DOWN;
                case AttachFace.FLOOR -> Direction.UP;
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void notifyNeighbors(Level level, BlockPos pos, Direction facing) {
        level.m_46672_(pos, (Block)this);
        level.m_46672_(pos.m_121945_(facing.m_122424_()), (Block)this);
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity be = level.m_7702_(pos);
        return be != null && be.m_7531_(id, param);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case AttachFace.FLOOR -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield FLOOR_NS_POWERED;
                        }
                        yield FLOOR_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield FLOOR_EW_POWERED;
                        }
                        yield FLOOR_EW_UNPOWERED;
                    }
                }
                yield Shapes.m_83144_();
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield WALL_N_POWERED;
                        }
                        yield WALL_N_UNPOWERED;
                    }
                    case SOUTH: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield WALL_S_POWERED;
                        }
                        yield WALL_S_UNPOWERED;
                    }
                    case EAST: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield WALL_E_POWERED;
                        }
                        yield WALL_E_UNPOWERED;
                    }
                    case WEST: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield WALL_W_POWERED;
                        }
                        yield WALL_W_UNPOWERED;
                    }
                }
                yield Shapes.m_83144_();
            }
            case AttachFace.CEILING -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield CEILING_NS_POWERED;
                        }
                        yield CEILING_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.m_61143_((Property)f_51045_)).booleanValue()) {
                            yield CEILING_EW_POWERED;
                        }
                        yield CEILING_EW_UNPOWERED;
                    }
                }
                yield Shapes.m_83144_();
            }
            default -> Shapes.m_83144_();
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PanicButtonBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

